package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Eugine on 9/30/2015.
 */
public class PropertiesObj
{
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";

    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";

    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data)
    {
        mProperties = data;
    }

    public JSONObject getData()
    {
        return mProperties;
    }

    public int getConfigVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(CONFIG_VERSION_KEY, 1);
        }
        return result;
    }

    public int getSdkStyleVersion()
    {
        int result = -1;
        if (mProperties != null)
        {
            result = mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties()
    {
        return mProperties;
    }

    public String getHtmlLoaderDefaultLink()
    {
        String result = "";
        if (mProperties != null)
        {
            result = mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink()
    {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (mProperties != null)
        {
            result = mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public void setConfigVersion(int version)
    {
        try
        {
            mProperties.put(CONFIG_VERSION_KEY, version);
        } catch (Exception ex)
        {

        }
    }

    // Update Configuration properties from other properties object (Updates all except the Configuration Version field)
    public void updateConfigFromData(PropertiesObj data)
    {
        try
        {
            if (data != null)
            {
                mProperties.put(CONFIG_VERSION_KEY, data.getConfigVersion());
                mProperties.put(SDK_STYLE_VERSION_KEY, data.getSdkStyleVersion());
                mProperties.put(HTML_LOADER_DEFAULT_URL_KEY, data.getHtmlLoaderDefaultLink());
                mProperties.put(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, data.getDefaultYouTubePlayerHtmlLink());
            }
        } catch (JSONException e)
        {
        }
    }
}
