/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.animations;

import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ViewAnimator;
import com.kidoz.sdk.api.general.animations.FlipAnimation;

public class AnimationFactory {
    private static final int DEFAULT_FLIP_TRANSITION_DURATION = 500;

    public static Animation[] flipAnimation(View fromView, View toView, FlipDirection dir, long duration, Interpolator interpolator) {
        Animation[] result = new Animation[2];
        float centerX = (float)fromView.getWidth() / 2.0f;
        float centerY = (float)fromView.getHeight() / 2.0f;
        FlipAnimation outFlip = new FlipAnimation(dir.getStartDegreeForFirstView(), dir.getEndDegreeForFirstView(), centerX, centerY, 0.75f, FlipAnimation.ScaleUpDownEnum.SCALE_DOWN);
        outFlip.setDuration(duration);
        outFlip.setFillAfter(true);
        outFlip.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        if (dir == FlipDirection.BOTTOM_TOP || dir == FlipDirection.TOP_BOTTOM) {
            outFlip.setDirection(0);
        } else {
            outFlip.setDirection(1);
        }
        AnimationSet outAnimation = new AnimationSet(true);
        outAnimation.addAnimation((Animation)outFlip);
        result[0] = outAnimation;
        FlipAnimation inFlip = new FlipAnimation(dir.getStartDegreeForSecondView(), dir.getEndDegreeForSecondView(), centerX, centerY, 0.75f, FlipAnimation.ScaleUpDownEnum.SCALE_UP);
        inFlip.setDuration(duration);
        inFlip.setFillAfter(true);
        inFlip.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        inFlip.setStartOffset(duration);
        if (dir == FlipDirection.BOTTOM_TOP || dir == FlipDirection.TOP_BOTTOM) {
            inFlip.setDirection(0);
        } else {
            inFlip.setDirection(1);
        }
        AnimationSet inAnimation = new AnimationSet(true);
        inAnimation.addAnimation((Animation)inFlip);
        result[1] = inAnimation;
        return result;
    }

    public static void flipTransition(ViewAnimator viewAnimator, FlipDirection dir) {
        AnimationFactory.flipTransition(viewAnimator, dir, 500L);
    }

    public static void flipTransition(ViewAnimator viewAnimator, FlipDirection dir, long duration) {
        View fromView = viewAnimator.getCurrentView();
        int currentIndex = viewAnimator.getDisplayedChild();
        int nextIndex = (currentIndex + 1) % viewAnimator.getChildCount();
        View toView = viewAnimator.getChildAt(nextIndex);
        Animation[] animc = AnimationFactory.flipAnimation(fromView, toView, nextIndex < currentIndex ? dir.theOtherDirection() : dir, duration, null);
        viewAnimator.setOutAnimation(animc[0]);
        viewAnimator.setInAnimation(animc[1]);
        viewAnimator.showNext();
    }

    public static Animation inFromLeftAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation inFromLeft = new TranslateAnimation(2, -1.0f, 2, 0.0f, 2, 0.0f, 2, 0.0f);
        inFromLeft.setDuration(duration);
        inFromLeft.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return inFromLeft;
    }

    public static Animation outToRightAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation outtoRight = new TranslateAnimation(2, 0.0f, 2, 1.0f, 2, 0.0f, 2, 0.0f);
        outtoRight.setDuration(duration);
        outtoRight.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return outtoRight;
    }

    public static Animation inFromRightAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation inFromRight = new TranslateAnimation(2, 1.0f, 2, 0.0f, 2, 0.0f, 2, 0.0f);
        inFromRight.setDuration(duration);
        inFromRight.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return inFromRight;
    }

    public static Animation outToLeftAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation outtoLeft = new TranslateAnimation(2, 0.0f, 2, -1.0f, 2, 0.0f, 2, 0.0f);
        outtoLeft.setDuration(duration);
        outtoLeft.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return outtoLeft;
    }

    public static Animation inFromTopAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation infromtop = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, -1.0f, 2, 0.0f);
        infromtop.setDuration(duration);
        infromtop.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return infromtop;
    }

    public static Animation outToTopAnimation(long duration, Interpolator interpolator) {
        TranslateAnimation outtotop = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, 0.0f, 2, -1.0f);
        outtotop.setDuration(duration);
        outtotop.setInterpolator((Interpolator)(interpolator == null ? new AccelerateInterpolator() : interpolator));
        return outtotop;
    }

    public static Animation fadeInAnimation(long duration, long delay) {
        AlphaAnimation fadeIn = new AlphaAnimation(0.0f, 1.0f);
        fadeIn.setInterpolator((Interpolator)new DecelerateInterpolator());
        fadeIn.setDuration(duration);
        fadeIn.setStartOffset(delay);
        return fadeIn;
    }

    public static Animation fadeOutAnimation(long duration, long delay) {
        AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
        fadeOut.setStartOffset(delay);
        fadeOut.setDuration(duration);
        return fadeOut;
    }

    public static Animation fadeInAnimation(long duration, final View view) {
        Animation animation = AnimationFactory.fadeInAnimation(500L, 0L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
                view.setVisibility(8);
            }
        });
        return animation;
    }

    public static Animation fadeOutAnimation(long duration, final View view) {
        Animation animation = AnimationFactory.fadeOutAnimation(500L, 0L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
                view.setVisibility(0);
            }
        });
        return animation;
    }

    public static Animation[] fadeInThenOutAnimation(long duration, long delay) {
        return new Animation[]{AnimationFactory.fadeInAnimation(duration, 0L), AnimationFactory.fadeOutAnimation(duration, duration + delay)};
    }

    public static void fadeOut(View v) {
        if (v == null) {
            return;
        }
        v.startAnimation(AnimationFactory.fadeOutAnimation(500L, v));
    }

    public static void fadeIn(View v) {
        if (v == null) {
            return;
        }
        v.startAnimation(AnimationFactory.fadeInAnimation(500L, v));
    }

    public static void fadeInThenOut(final View v, long delay) {
        if (v == null) {
            return;
        }
        v.setVisibility(0);
        AnimationSet animation = new AnimationSet(true);
        Animation[] fadeInOut = AnimationFactory.fadeInThenOutAnimation(500L, delay);
        animation.addAnimation(fadeInOut[0]);
        animation.addAnimation(fadeInOut[1]);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                v.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
                v.setVisibility(0);
            }
        });
        v.startAnimation((Animation)animation);
    }

    public static enum FlipDirection {
        LEFT_RIGHT,
        RIGHT_LEFT,
        TOP_BOTTOM,
        BOTTOM_TOP;


        public float getStartDegreeForFirstView() {
            return 0.0f;
        }

        public float getStartDegreeForSecondView() {
            switch (this) {
                case LEFT_RIGHT: 
                case TOP_BOTTOM: {
                    return -90.0f;
                }
                case RIGHT_LEFT: 
                case BOTTOM_TOP: {
                    return 90.0f;
                }
            }
            return 0.0f;
        }

        public float getEndDegreeForFirstView() {
            switch (this) {
                case LEFT_RIGHT: 
                case TOP_BOTTOM: {
                    return 90.0f;
                }
                case RIGHT_LEFT: 
                case BOTTOM_TOP: {
                    return -90.0f;
                }
            }
            return 0.0f;
        }

        public float getEndDegreeForSecondView() {
            return 0.0f;
        }

        public FlipDirection theOtherDirection() {
            switch (this) {
                case LEFT_RIGHT: {
                    return RIGHT_LEFT;
                }
                case TOP_BOTTOM: {
                    return BOTTOM_TOP;
                }
                case RIGHT_LEFT: {
                    return LEFT_RIGHT;
                }
                case BOTTOM_TOP: {
                    return TOP_BOTTOM;
                }
            }
            return null;
        }
    }
}

