/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.Event;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventLogDatabaseManager;
import com.kidoz.events.EventParameters;
import com.kidoz.events.EventSyncAsyncTask;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONObject;

public class EventManager {
    private static final String TAG = EventManager.class.getSimpleName();
    public static int LOG_CRITICAL_LEVEL = 0;
    public static int LOG_NORMAL_LEVEL = 1;
    public static int LOG_CLOSE_ANY_EVENT_LEVEL = 0;
    public static int LOG_CLOSE_RESOURCE_LEVEL = 1;
    public static int LOG_CLOSE_ACTIVITY_LEVEL = 2;
    public static int LOG_CLOSE_SESSION_LEVEL = 3;
    private static final int NIGHT_TIME_HOUR_VALUE_START = 21;
    private static final int NIGHT_TIME_HOUR_VALUE_END = 8;
    private static final int DAY_TIME_AMOUNT = 10;
    private static final int NIGHT_TIME_AMOUNT_EXTRA = 50;
    private static final int THREE_G_CONNECTON_TYPE_AMOUNT = 10;
    private static final int WIFI_CONNECTON_TYPE_AMOUNT_EXTRA = 20;
    private static final int SCREEN_STATE_ON_AMOUNT = 10;
    private static final int SCREEN_STATE_OFF_AMOUNT_EXTRA = 20;
    private static final String OS_TYPE = "Android";
    private static final long DEFAULT_DELTA_TIME_BETWEEN_ACTIVITES_FOR_NEW_SESSION = 30000L;
    public static final String EVENTS_SHARED_PREFERENCES_KEY = "events_shared_preferences";
    public static final String EVENTS_LAST_SESSION_ID_KEY = "last_session_id";
    private static final String EVENTS_LAST_ACTIVITY_ID_KEY = "last_activity_id";
    private static final String EVENT_SERVER_ADDRESS_KEY = "event_server_address";
    private static final String DELTA_FOR_NEW_SESSION_KEY = "delta_for_new_session_key";
    public static final String LOG_LEVEL_KEY = "log_level";
    public static int SDK_STYLE_VERSION_NUM = 0;
    private static EventManager mEventManager;
    private int mLogLevel;
    private long mSessionID;
    private long mActivityID;
    private String mActivityName;
    private Date mLastEventTimeStamp;
    private Date mLastActivityEndTime;
    private String mDeveloperID;
    private ArrayList<Event> mOpenedEventsList;
    private EventLogDatabaseManager mDatabaseManager;
    private static Utils.StaticHandler mSyncEventHandler;
    private EventSyncAsyncTask mEventSyncAsyncTask;
    private ArrayList<Event> mTempStoredEventsList = new ArrayList();

    private EventManager() {
        this.mOpenedEventsList = new ArrayList();
    }

    public static EventManager getInstance(Context context) {
        if (mEventManager == null) {
            mEventManager = new EventManager();
            mEventManager.init(context, null);
        }
        return mEventManager;
    }

    private EventLogDatabaseManager getEventDB(Context context) {
        if (this.mDatabaseManager == null) {
            this.mDatabaseManager = new EventLogDatabaseManager(context);
        }
        return this.mDatabaseManager;
    }

    private Handler getMyHandler() {
        if (mSyncEventHandler == null) {
            mSyncEventHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return mSyncEventHandler;
    }

    public void init(Context context, JSONObject params) {
        SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
        try {
            if (params != null) {
                this.mLogLevel = params.optInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                String mServerAdress = params.optString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                this.mDeveloperID = params.optString("DeveloperID", "");
                this.mSessionID = params.optInt("SessionID", 0);
                SharedPreferences.Editor editor = eventsPref.edit();
                editor.putInt(LOG_LEVEL_KEY, this.mLogLevel);
                editor.putString("DeveloperID", this.mDeveloperID);
                editor.apply();
            } else {
                this.mLogLevel = eventsPref.getInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                String mServerAdress = eventsPref.getString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                this.mDeveloperID = eventsPref.getString("DeveloperID", "");
                this.mSessionID = -1L;
            }
            this.mActivityID = 0L;
            if (this.mDatabaseManager == null) {
                this.mDatabaseManager = new EventLogDatabaseManager(context);
            }
            SDKLogger.printInfoLog("init Event manager");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager init " + ex.getMessage());
        }
    }

    public boolean getIsNeedEventsSync(Context context) {
        return !this.getEventDB(context).getEventsTable().isDBempty();
    }

    public EventBulk getNextBulk(Context context) {
        EventBulk result = new EventBulk();
        result.setDeviceParamsJSONObject(this.getBulkDeviceParamsJsonObject(context));
        result.setEventArrayList(this.getEventDB(context).getEventsTable().getEvents(this.calculateBulkSize(context)));
        return result;
    }

    public void removeBulkFromDB(Context context, EventBulk eventBulk) {
        this.getEventDB(context).getEventsTable().removeLogEventsFromDB(eventBulk.getEventArrayList());
    }

    private int calculateBulkSize(Context context) {
        int result = 30;
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        if (currentHour >= 21 || currentHour <= 8) {
            result += 50;
        }
        if (ScreenUtils.getIsScreenOff(context)) {
            result += 20;
        }
        return result;
    }

    public long activityStart(Context context, String widgetType, String styleId, int logLevel, String activityName) {
        try {
            this.mLastEventTimeStamp = new Date();
            if (this.mLastActivityEndTime == null) {
                this.mLastActivityEndTime = new Date(0L);
            }
            Date lastEventTime = this.mLastEventTimeStamp;
            this.mLastEventTimeStamp = new Date();
            Long timeDelta = this.mLastEventTimeStamp.getTime() - this.mLastActivityEndTime.getTime();
            ++this.mActivityID;
            Event openedEvent = new Event();
            this.fillBaseEventParameters(openedEvent, "Activity", "Activity End", activityName, widgetType, styleId);
            openedEvent.setLogLevel(LOG_CRITICAL_LEVEL);
            openedEvent.setCloseLevel(LOG_CLOSE_ACTIVITY_LEVEL);
            this.mOpenedEventsList.add(openedEvent);
            this.mActivityName = activityName;
            this.internalLogEvent(context, widgetType, styleId, logLevel, null, "Activity", "Activity Start", activityName);
            SDKLogger.printInfoLog("activity start event generated");
            return this.mActivityID;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager activityStart " + ex.getMessage());
            return -1L;
        }
    }

    public int activityEnd(Context context, String widgetType, String styleId, int logLevel, long activityID, boolean storeForLaterSending) {
        try {
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getCloseLevel() > LOG_CLOSE_ACTIVITY_LEVEL) continue;
                long duration = System.currentTimeMillis() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", duration);
                this.internalLogEvent(context, widgetType, styleId, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager activity end " + ex.getMessage());
        }
        this.mLastActivityEndTime = new Date();
        return 0;
    }

    public int logClickEvent(Context context, String widgetType, String styleId, String action, String label, String itemID, int position) {
        Event event = new Event();
        event.addParameterToJsonObject("ItemID", itemID);
        event.addParameterToJsonObject("ItemIndex", position);
        this.internalLogEvent(context, widgetType, styleId, LOG_NORMAL_LEVEL, event, "Content Click", action, label);
        return 0;
    }

    public int logEvent(Context context, String widgetType, String styleId, int logLevel, String category, String action, String label) {
        this.internalLogEvent(context, widgetType, styleId, logLevel, null, category, action, label);
        return 0;
    }

    public int logEventWithDuration(Context context, String widgetType, String styleId, int logLevel, int resourceID, int closeLevel, String category, String action, String label, String itemID, boolean storeForLaterSending) {
        try {
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() != resourceID) continue;
                long duration = System.currentTimeMillis() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", duration);
                opendEvent.addParameterToJsonObject("ItemID", itemID);
                this.internalLogEvent(context, widgetType, styleId, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        Event openedEvent = new Event();
        this.fillBaseEventParameters(openedEvent, category, action, label, widgetType, styleId);
        openedEvent.setLogLevel(logLevel);
        openedEvent.setCloseLevel(closeLevel);
        openedEvent.setResourceID(resourceID);
        this.mOpenedEventsList.add(openedEvent);
        return 0;
    }

    public int logEventWithDurationEnd(Context context, String widgetType, String styleId, int resourceID, boolean storeForLaterSending) {
        try {
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() != resourceID) continue;
                long duration = System.currentTimeMillis() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", duration);
                this.internalLogEvent(context, widgetType, styleId, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        return 0;
    }

    public int logSponsoredContentImpressionEvent(Context context, String widgetType, String styleId, String action, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", action, label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentClickEvent(Context context, String widgetType, String styleId, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Click", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredConversionEvent(Context context, String widgetType, String styleId, Event event, String label, String advertiserID, String itemID, int positionIndex, int rewardKey, int rewardValue) {
        try {
            if (event == null) {
                event = new Event();
            }
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            event.addParameterToJsonObject("intField", rewardKey);
            event.addParameterToJsonObject("intField2", rewardValue);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Conversion", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logSponsoredConversionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentInstallEvent(Context context, String widgetType, String styleId, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Install Completed", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int LogEventWithIntField(Context context, String widgetType, String styleId, int logLevel, String category, String action, String label, int intField) {
        Event event = new Event();
        event.addParameterToJsonObject("intField", intField);
        return this.internalLogEvent(context, widgetType, styleId, logLevel, event, category, action, label);
    }

    public int logEvent(Context context, String widgetType, String styleId, int logLevel, Event event, String category, String action, String label) {
        return this.internalLogEvent(context, widgetType, styleId, logLevel, event, category, action, label);
    }

    private int internalLogEvent(Context context, String widgetType, String styleId, int logLevel, Event event, String category, String action, String label) {
        if (logLevel <= this.mLogLevel) {
            Event tempEvent = event == null ? new Event() : event;
            this.fillBaseEventParameters(tempEvent, category, action, label, widgetType, styleId);
            SDKLogger.printInfoLog("Event sent to DB: " + tempEvent.getJSONObject().toString());
            this.getEventDB(context).getEventsTable().insertLogEventToDB(tempEvent);
        }
        return 0;
    }

    private int fillBaseEventParameters(Event event, String category, String action, String label, String widgetType, String styleId) {
        if (category != null) {
            event.addParameterToJsonObject("Category", category);
        }
        if (action != null) {
            event.addParameterToJsonObject("Action", action);
        }
        if (label != null) {
            event.addParameterToJsonObject("Label", label);
        }
        event.addParameterToJsonObject("ActivityName", this.mActivityName);
        event.addParameterToJsonObject("ActivityID", this.mActivityID);
        event.addParameterToJsonObject("SessionID", this.mSessionID);
        if (widgetType != null) {
            event.addParameterToJsonObject("WidgetType", widgetType);
        }
        if (styleId != null) {
            event.addParameterToJsonObject("StyleId", styleId);
        }
        event.addParameterToJsonObject("SdkVersion", "0.5.7");
        return 0;
    }

    private JSONObject getBulkDeviceParamsJsonObject(Context context) {
        JSONObject result = new JSONObject();
        if (context != null) {
            try {
                if (this.mDeveloperID == null) {
                    SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
                    this.mDeveloperID = eventsPref.getString("DeveloperID", "");
                }
                result.put("DeviceHash", (Object)Utils.generateUniqeDeviceID(context.getPackageName(), this.mDeveloperID));
                result.put("UserRefferal", (Object)DeviceUtils.getDeviceReferral(context));
                result.put("PackageID", (Object)context.getPackageName());
                PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                result.put("AppVersion", (Object)String.valueOf(pInfo.versionName));
                result.put("AppID", (Object)String.valueOf(pInfo.packageName));
                result.put("DeveloperID", (Object)this.mDeveloperID);
                result.put("EventVersion", 0);
                result.put("DeviceType", (Object)String.valueOf(Build.DEVICE));
                result.put("DeviceBrand", (Object)String.valueOf(Build.MANUFACTURER));
                result.put("DeviceModel", (Object)String.valueOf(Build.MODEL));
                result.put("ScreenType", (Object)String.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
                result.put("ScreenSize", (Object)String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                DisplayMetrics metrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(metrics);
                result.put("DpiFactor", (Object)String.valueOf(metrics.densityDpi));
                result.put("ScreenW", (Object)String.valueOf(DeviceUtils.getScreenSize(context, true)));
                result.put("ScreenH", (Object)String.valueOf(DeviceUtils.getScreenSize(context, false)));
                result.put("OsType", (Object)String.valueOf(OS_TYPE));
                result.put("OsVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
                result.put("DeviceLang", (Object)String.valueOf(Locale.getDefault().getLanguage()));
                result.put("TimeZone", (Object)EventParameters.getCurrentTimezoneOffset());
                result.put("Country", (Object)String.valueOf(Locale.getDefault().getCountry()));
                result.put("EventType", (Object)"Device Info");
                result.put("SdkVersion", (Object)"0.5.7");
                result.put("ExtensionType", ConstantDef.SDK_EXTENSION_TYPE);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog("Error when trying to create device params: " + ex.getMessage());
            }
        }
        return result;
    }

    public void startEventsSync(final Context context) {
        this.getMyHandler().post(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.mEventSyncAsyncTask == null || EventManager.this.mEventSyncAsyncTask.isCancelled() || EventManager.this.mEventSyncAsyncTask.getStatus() == AsyncTask.Status.FINISHED) {
                    EventManager.this.mEventSyncAsyncTask = new EventSyncAsyncTask(context);
                    if (Build.VERSION.SDK_INT < 11) {
                        EventManager.this.mEventSyncAsyncTask.execute(new Void[0]);
                    } else {
                        EventManager.this.mEventSyncAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                    }
                }
            }
        });
    }

    public void startEventsSync(final Context context, int posDelayMillis) {
        this.getMyHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.mEventSyncAsyncTask == null || EventManager.this.mEventSyncAsyncTask.isCancelled() || EventManager.this.mEventSyncAsyncTask.getStatus() == AsyncTask.Status.FINISHED) {
                    EventManager.this.mEventSyncAsyncTask = new EventSyncAsyncTask(context);
                    if (Build.VERSION.SDK_INT < 11) {
                        EventManager.this.mEventSyncAsyncTask.execute(new Void[0]);
                    } else {
                        EventManager.this.mEventSyncAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                    }
                }
            }
        }, (long)posDelayMillis);
    }
}

