package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Point;
import android.os.Looper;
import android.os.Message;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

/**
 * Created by roni on 10/7/2015.
 */
public class PanelSliderView extends RelativeLayout
{
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.12f;

    private PANEL_TYPE mPanelType;
    private RecyclerView mCustomRecyclerView;
    private PanelAdapter mPanelAdapter;
    private LoadingProgressView mLoadingProgressView;

    private Utils.StaticHandler mStaticHandler;
    private PanelViewListener mPanelViewListener;
    private int mScrollingValue;

    private RelativeLayout.LayoutParams innerParams;

    public PanelSliderView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        initRecyclerView();
        initProgressBar();
    }

    public void initRecyclerView()
    {
        // Create an instance of the recycler view
        mCustomRecyclerView = new RecyclerView(getContext());
        mCustomRecyclerView.setHasFixedSize(true);
        mCustomRecyclerView.setClipToPadding(false);

        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);

        mPanelAdapter = new PanelAdapter(getContext(), mPanelType);
        mCustomRecyclerView.setAdapter(mPanelAdapter);

        // Add the recycler view to the root layout
        innerParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        innerParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        addView(mCustomRecyclerView, innerParams);
    }

    private void initProgressBar()
    {

        mLoadingProgressView = new LoadingProgressView(getContext());
        mLoadingProgressView.setVisibility(View.GONE);

        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * LOADING_PROGRESS_DEFAULT_RATIO);
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
        prParams.addRule(RelativeLayout.CENTER_IN_PARENT);

        addView(mLoadingProgressView, prParams);
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        mPanelAdapter.setPanelType(mPanelType);
        if (mPanelType != null)
        {
            switch (mPanelType)
            {
                case TOP:
                {
                    mScrollingValue = ScreenUtils.getScreenSize(getContext(), true);
                    break;
                }
                case LEFT:
                {
                    mScrollingValue = ScreenUtils.getScreenSize(getContext(), false);
                    break;
                }
                case RIGHT:
                {
                    mScrollingValue = ScreenUtils.getScreenSize(getContext(), false);
                    break;
                }
                case BOTTOM:
                {
                    mScrollingValue = ScreenUtils.getScreenSize(getContext(), true);
                    break;
                }
            }
        }

        preparePanelSlider();
    }

    private void preparePanelSlider()
    {
        // Set the width and height and layout manager orientation
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        int itemWidth = (int) (517f * SCALE_FACTOR);
        int itemHeight = (int) (402f * SCALE_FACTOR);


        LinearLayoutManager customLinearLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        switch (mPanelType)
        {
            case LEFT:
            {
                innerParams.width = itemWidth  ;
                innerParams.height = LayoutParams.MATCH_PARENT;
                customLinearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
                mCustomRecyclerView.addItemDecoration(new EqualSpaceItemDecoration(Utils.dpTOpx(getContext(), 1f),Utils.dpTOpx(getContext(), 2)));
                mPanelAdapter.setSizePropertiesAndUpdate(itemWidth - Utils.dpTOpx(getContext(), 2) * 2 - Utils.dpTOpx(getContext(), 6) * 3, itemHeight);
                break;
            }
            case TOP:
            {
                innerParams.width = LayoutParams.MATCH_PARENT;
                innerParams.height = itemHeight ;
                customLinearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
                mCustomRecyclerView.addItemDecoration(new EqualSpaceItemDecoration(Utils.dpTOpx(getContext(), 2),Utils.dpTOpx(getContext(), 1.2f)));
                mPanelAdapter.setSizePropertiesAndUpdate(itemWidth , itemHeight);
                break;
            }
            case RIGHT:
            {
                innerParams.width = itemWidth;
                innerParams.height = LayoutParams.MATCH_PARENT;
                customLinearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
                mCustomRecyclerView.addItemDecoration(new EqualSpaceItemDecoration(Utils.dpTOpx(getContext(), 1f),Utils.dpTOpx(getContext(), 2)));
                mPanelAdapter.setSizePropertiesAndUpdate(itemWidth - Utils.dpTOpx(getContext(), 2) * 2 - Utils.dpTOpx(getContext(), 5) * 3, itemHeight);
                break;
            }
            case BOTTOM:
            {
                innerParams.width = LayoutParams.MATCH_PARENT;
                innerParams.height = itemHeight;
                customLinearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
                mCustomRecyclerView.addItemDecoration(new EqualSpaceItemDecoration(Utils.dpTOpx(getContext(), 2),Utils.dpTOpx(getContext(), 1.2f)));
                mPanelAdapter.setSizePropertiesAndUpdate(itemWidth , itemHeight);
                break;
            }
        }

        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);
    }

    public void setContentData(ContentData contentData)
    {
        mPanelAdapter.setContent(contentData);
        mPanelAdapter.toggleClick(false);
        mCustomRecyclerView.setOnTouchListener(new OnTouchListener()
        {
            @Override
            public boolean onTouch(View v, MotionEvent event)
            {
                return true;
            }
        });
        setScrollingStartPosition();
        getMyHandlerInstance().postDelayed(new Runnable()
        {
            @Override
            public void run()
            {
                animateScrollingToStartPosition();
            }
        }, 1000);
        getMyHandlerInstance().postDelayed(new Runnable()
        {
            @Override
            public void run()
            {
                mCustomRecyclerView.setOnTouchListener(null);
                mPanelAdapter.toggleClick(true);
            }
        }, 1500);
    }

    public void clearContent()
    {
        mPanelAdapter.clearContent();
    }

    public void setPanelViewListener(PanelViewListener panelViewListener)
    {
        mPanelViewListener = panelViewListener;
        if (mPanelAdapter != null)
        {
            mPanelAdapter.setPanelViewListener(panelViewListener);
        }
    }

    private void setScrollingStartPosition()
    {
        if (mPanelType != null)
        {
            switch (mPanelType)
            {
                case TOP:
                {
                    mCustomRecyclerView.scrollBy(mScrollingValue, 0);
                    break;
                }
                case LEFT:
                {
                    mCustomRecyclerView.scrollBy(0, mScrollingValue);
                    break;
                }
                case RIGHT:
                {
                    mCustomRecyclerView.scrollBy(0, mScrollingValue);
                    break;
                }
                case BOTTOM:
                {
                    mCustomRecyclerView.scrollBy(mScrollingValue, 0);
                    break;
                }
            }
        }
    }

    private void animateScrollingToStartPosition()
    {
        if (mPanelType != null)
        {
            switch (mPanelType)
            {
                case TOP:
                {
                    mCustomRecyclerView.smoothScrollBy(-mScrollingValue, 0);
                    break;
                }
                case LEFT:
                {
                    mCustomRecyclerView.smoothScrollBy(0, -mScrollingValue);
                    break;
                }
                case RIGHT:
                {
                    mCustomRecyclerView.smoothScrollBy(0, -mScrollingValue);
                    break;
                }
                case BOTTOM:
                {
                    mCustomRecyclerView.smoothScrollBy(-mScrollingValue, 0);
                    break;
                }
            }
        }
    }

    /**
     * Show or Hide loading progress view
     *
     * @param show
     */
    public void showLoadingProgressView(boolean show)
    {
        if (show)
        {
            mLoadingProgressView.setVisibility(View.VISIBLE);
            mLoadingProgressView.startLoadingAnimation();
        } else
        {
            mLoadingProgressView.stopLoadingAnimation();
            mLoadingProgressView.setVisibility(View.GONE);
        }
    }

    /**
     * Get handler instance
     */
    private Utils.StaticHandler getMyHandlerInstance()
    {
        if (mStaticHandler == null)
        {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper())
            {
                @Override
                public void handleMessage(Message message)
                {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }

    @Override
    protected void onDetachedFromWindow()
    {

        super.onDetachedFromWindow();
    }
}
