package com.kidoz.sdk.api.ui_views.one_item_view;

import android.database.DataSetObserver;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;

/**
 * A PagerAdapter that wraps around another PagerAdapter to handle paging wrap-around.
 */
public class InfinitePagerAdapter extends PagerAdapter
{
    private static final String TAG = "InfinitePagerAdapter";
    private PagerAdapter adapter;
    private IOnFistItemInstaniateListener mItemInstaniateListener;
    private boolean mFirstItemCreated = false;

    public InfinitePagerAdapter(PagerAdapter adapter)
    {
        this.adapter = adapter;
    }

    @Override
    public int getCount()
    {
        if (getRealCount() == 0)
        {
            return 0;
        }
        // warning: scrolling to very high values (1,000,000+) results in
        // strange drawing behaviour
        return Integer.MAX_VALUE;
    }

    /**
     * @return the {@link #getCount()} result of the wrapped adapter
     */
    public int getRealCount()
    {
        return adapter.getCount();
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position)
    {
        int virtualPosition = position % getRealCount();
        // only expose virtual position to the inner adapter
        Object item = adapter.instantiateItem(container, virtualPosition);
        if(position == 0 && mFirstItemCreated == false) {
            mFirstItemCreated = true;
            if(mItemInstaniateListener != null) {
                mItemInstaniateListener.onFirstItemReady();
            }
        }
        return item;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object)
    {
        if(getRealCount() != 0) {
            int virtualPosition = position % getRealCount();
            // only expose virtual position to the inner adapter
            adapter.destroyItem(container, virtualPosition, object);
        }
    }

    /*
     * Delegate rest of methods directly to the inner adapter.
     */
    @Override
    public void finishUpdate(ViewGroup container)
    {
        adapter.finishUpdate(container);
    }

    @Override
    public boolean isViewFromObject(View view, Object object)
    {
        return adapter.isViewFromObject(view, object);
    }

    @Override
    public void restoreState(Parcelable bundle, ClassLoader classLoader)
    {
        adapter.restoreState(bundle, classLoader);
    }

    @Override
    public Parcelable saveState()
    {
        return adapter.saveState();
    }

    @Override
    public void startUpdate(ViewGroup container)
    {
        adapter.startUpdate(container);
    }

    @Override
    public CharSequence getPageTitle(int position)
    {
        int virtualPosition = position % getRealCount();
        return adapter.getPageTitle(virtualPosition);
    }

    @Override
    public float getPageWidth(int position)
    {
        return adapter.getPageWidth(position);
    }

    @Override
    public void setPrimaryItem(ViewGroup container, int position, Object object)
    {
        adapter.setPrimaryItem(container, position, object);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer)
    {
        adapter.unregisterDataSetObserver(observer);
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer)
    {
        adapter.registerDataSetObserver(observer);
    }

    @Override
    public void notifyDataSetChanged()
    {
        adapter.notifyDataSetChanged();
    }

    @Override
    public int getItemPosition(Object object)
    {
        return adapter.getItemPosition(object);
    }


    public void setOnFirstItemListener(IOnFistItemInstaniateListener listener) {
        mItemInstaniateListener = listener;
    }

    public interface IOnFistItemInstaniateListener {
        void onFirstItemReady();
    }
}
