package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;

import de.greenrobot.event.EventBus;

public class KidozAdActivity extends Activity
{
    public static ContentItem itm;

    public static final String STYLE_ID_KEY = "styleId";

    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected boolean mIsDefault;
    protected boolean mIsImmersive = false;
    protected boolean mIsBlockBackBtn = false;
    protected boolean mIsLandscape = false;
    protected int mBgColor = Color.BLACK;
    protected int mViewDuration = 0;

    private Utils.StaticHandler mHandler;
    protected int mCurrentOrientationState = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        setTheme(android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);

        mHandler = new Utils.StaticHandler(getMainLooper());
        Intent intent = getIntent();
        if (intent != null)
        {
            String styleId = intent.getStringExtra(STYLE_ID_KEY);

            if (itm != null)
            {
                mIsDefault = !itm.getIsNonDefaultHtml();
                mIsBlockBackBtn = itm.getExtraParameters().optBoolean("intrstBlockBackBtn", true);
                mIsImmersive = itm.getExtraParameters().optBoolean("intrstImmersiveModeOn", false);
                mIsLandscape = itm.getExtraParameters().optBoolean("intrstForceLandscape", false);
                mViewDuration = itm.getExtraParameters().optInt("viewDurationSec", 0);
                try
                {
                    mBgColor = Color.parseColor(itm.getExtraParameters().optString("intrstBgColor", "000000"));
                }
                catch (Exception e)
                {
                }
            }

            if (mIsDefault)
            {
                mWebView = HtmlManager.getIntrstDefaultHtmlView(this);
                mWebView.setData(itm);
            }
            else
            {
                mWebView = new HtmlViewWrapper(this, false);
                mWebView.setData(itm);
                mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                mWebView.setHtmlWebViewListener(new IOnHtmlWebViewInterface()
                {
                    @Override
                    public void onHtmlStartLoading()
                    {
                        super.onHtmlStartLoading();
                        mWebView.showLoadingProgressView();
                    }

                    @Override
                    public void onHtmlFinishedLoading()
                    {
                        super.onHtmlFinishedLoading();
                        mWebView.hideLoadingProgressView();
                    }
                });
            }

            if (mWebView != null)
            {
                mWebView.setInFocusActivityContext(KidozAdActivity.this);

                mInnerContainer = new RelativeLayout(this);
                mInnerContainer.setBackgroundColor(mBgColor);
                mInnerContainer.addView(mWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));
                setContentView(mInnerContainer, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

                if (mIsDefault)
                {
                    mWebView.requestWidgetOpen(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                }

                EventManager.getInstance(this).logEvent(this, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), styleId, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.INTERSTITIAL_VIEW);

                if (mIsLandscape)
                {
                    mCurrentOrientationState = getResources().getConfiguration().orientation;
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                }
            }
            else
            {
                finish();
            }
        }
        else
        {
            finish();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus)
    {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus)
        {
            if (mIsImmersive)
            {
                applyImmersiveMode();
            }
        }
    }

    private void applyImmersiveMode()
    {
        int flags = View.SYSTEM_UI_FLAG_HIDE_NAVIGATION;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN;
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT)
        {
            flags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        }

        getWindow().getDecorView().setSystemUiVisibility(flags);
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        doOnResume();
        if (mWebView != null)
        {
            mHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    if (mIsDefault)
                    {
                        mWebView.requestFocusOn(true);
                    }
                    else
                    {
                        mWebView.loadHtml(itm.getData());
                    }
                }
            }, 300);
        }
    }

    @Override
    protected void onPause()
    {
        mHandler.removeCallbacksAndMessages(null);
        mWebView.requestFocusOff();

        if (!mIsDefault)
        {
            mWebView.stopAndReleaseWebView();
        }
        doOnPause();

        super.onPause();
    }

    @Override
    protected void onDestroy()
    {
        super.onDestroy();
        if (!mIsDefault)
        {
            mWebView.requestWidgetClose(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }
    }

    public void onEvent(WidgetEventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE)
        {
            if (isFinishing() == false)
            {
                finish();
            }
        }
        else if (event.getMessageType() == EventMessage.MessageType.PLAYER_OPEN)
        {
            mHandler.removeCallbacksAndMessages(null);
            mWebView.requestFocusOff();

            if (!mIsDefault)
            {
                mWebView.stopAndReleaseWebView();
            }
        }
        else if (event.getMessageType() == EventMessage.MessageType.PLAYER_CLOSE)
        {
            if (mWebView != null)
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        if (mIsDefault)
                        {
                            mWebView.requestFocusOn(true);
                        }
                        else
                        {
                            mWebView.loadHtml(itm.getData());
                        }
                    }
                }, 300);
            }
        }
    }

    @Override
    public void onBackPressed()
    {
        if (mIsBlockBackBtn)
        {
            if (mWebView != null)
            {
                mWebView.requestFocusOff();
                if (!mIsDefault)
                {
                    mWebView.stopAndReleaseWebView();
                }
            }

            super.onBackPressed();

            WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
            EventBus.getDefault().post(eventMessage);
        }
    }

    /**
     * Restore user original orientation
     */
    public void restoreUserOriginalOrientation()
    {
        if (isFinishing() == false)
        {
            switch (mCurrentOrientationState)
            {
                case Configuration.ORIENTATION_LANDSCAPE:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                    break;
                }

                case Configuration.ORIENTATION_PORTRAIT:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                    break;
                }
                case Configuration.ORIENTATION_UNDEFINED:
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                    break;
                }
            }
        }
    }

    private void doOnPause()
    {
        if (EventBus.getDefault().isRegistered(this))
        {
            EventBus.getDefault().unregister(this);
        }

        if (mIsLandscape)
        {
            restoreUserOriginalOrientation();
        }
    }

    private void doOnResume()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        if (mViewDuration > 0)
        {
            mHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    finish();

                    WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    EventBus.getDefault().post(eventMessage);
                }
            }, mViewDuration * 1000);
        }
    }
}
