package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.kidoz.sdk.api.players.web_player.WebPreferenceConstants;

import org.json.JSONObject;

/**
 * Created by Eugine on 3/3/2016.
 */
public class HtmlFiveWebView extends WebView
{
    private final String TAG = HtmlFiveWebView.class.getSimpleName();

    public HtmlFiveWebView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        //initWebView(context);
        if (Build.VERSION.SDK_INT >= 21)
        {
            getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
    }

    public HtmlFiveWebView(Context context)
    {
        super(context);

        initWebView(context);
        if (Build.VERSION.SDK_INT >= 21)
        {
            getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
    }

    private void initWebView(Context context)
    {
        setDrawingCacheBackgroundColor(0x00000000);
        setBackgroundColor(Color.TRANSPARENT);
        setFocusableInTouchMode(true);
        setFocusable(true);

        setAnimationCacheEnabled(true);
        setDrawingCacheEnabled(true);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
        {
            setBackground(null);
            getRootView().setBackground(null);
        } else
        {
            getRootView().setBackgroundDrawable(null);
        }

        if (Build.VERSION.SDK_INT < 19)
        {
            String databasePath = context.getDir("database", Context.MODE_PRIVATE).getPath();
            getSettings().setDatabasePath(databasePath);
        }

        getSettings().setAppCacheEnabled(true);
        getSettings().setDatabaseEnabled(true);

        if (Build.VERSION.SDK_INT < 18)
        {
            getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17)
        {
            getSettings().setEnableSmoothTransition(true);
        }

        getSettings().setBuiltInZoomControls(false);
        getSettings().setDisplayZoomControls(false);
        getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        getSettings().setAppCachePath(context.getCacheDir().toString());
        getSettings().setAllowContentAccess(false);
        getSettings().setDefaultTextEncodingName("utf-8");
        getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 5.1; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");
        getSettings().setGeolocationEnabled(true);
        getSettings().setSupportMultipleWindows(false);
        getSettings().setJavaScriptEnabled(true);
        getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        getSettings().setBlockNetworkImage(false);

        SharedPreferences mPreferences = context.getSharedPreferences(WebPreferenceConstants.PREFERENCES, 0);
        if (Build.VERSION.SDK_INT < 19)
        {
            switch (mPreferences.getInt(WebPreferenceConstants.ADOBE_FLASH_SUPPORT, 0))
            {
                case 0:
                    getSettings().setPluginState(WebSettings.PluginState.OFF);
                    break;
                case 1:
                    getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
                    break;
                case 2:
                    getSettings().setPluginState(WebSettings.PluginState.ON);
                    break;
                default:
                    break;
            }
        }

        if (Build.VERSION.SDK_INT < 18)
        {
            getSettings().setSavePassword(false);
        }

        if (mPreferences.getBoolean(WebPreferenceConstants.TEXT_REFLOW, false))
        {
            getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT)
        {
            getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
        } else
        {
            getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }

        //*********************************************************************//
        applyProperties(new JSONObject());

        if (Build.VERSION.SDK_INT >= 17)
        {
            getSettings().setMediaPlaybackRequiresUserGesture(false);
        }

        getSettings().setDomStorageEnabled(true);
        getSettings().setAllowFileAccess(true);
        getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16)
        {
            getSettings().setAllowFileAccessFromFileURLs(true);
            getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        getSettings().setSaveFormData(false);
        getSettings().setLoadWithOverviewMode(false);
        getSettings().setUseWideViewPort(false);
        getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);

        if (Build.VERSION.SDK_INT >= 11)
        {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        }

        if (Build.VERSION.SDK_INT >= 21)
        {
            getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
    }

    public synchronized void stopAndReleaseWebView()
    {
        loadUrl("");
        stopLoading();
        clearHistory();
        removeAllViews();
        destroyDrawingCache();
    }

    /**
     * Set and apply webview properties defined in the passed JSON object
     */
    public void applyProperties(JSONObject properties)
    {
        if (properties != null)
        {
            if (Build.VERSION.SDK_INT >= 17)
            {
                getSettings().setMediaPlaybackRequiresUserGesture(properties.optBoolean("setMediaPlaybackRequiersGesture", false));
            }

            getSettings().setDomStorageEnabled(properties.optBoolean("setDomStorageEnabled", true));
            getSettings().setAllowFileAccess(properties.optBoolean("setAllowFileAccess", true));
            getSettings().setSupportZoom(properties.optBoolean("setZoomSupport", false));
            if (Build.VERSION.SDK_INT >= 16)
            {
                getSettings().setAllowFileAccessFromFileURLs(properties.optBoolean("setAllowFileAccessFromFileUrls", true));
                getSettings().setAllowUniversalAccessFromFileURLs(properties.optBoolean("setAllowUniversalAccessFromFileURLs", true));
            }
            getSettings().setSaveFormData(properties.optBoolean("setSaveFormData", false));
            getSettings().setLoadWithOverviewMode(properties.optBoolean("setLoadWithOverviewMode", false));
            getSettings().setUseWideViewPort(properties.optBoolean("setUseWideViewPort", false));
            getSettings().setCacheMode(properties.optInt("setCacheMode", WebSettings.LOAD_DEFAULT));

            if (properties.optBoolean("setHardwareAcceleration", true))
            {
                setLayerType(View.LAYER_TYPE_HARDWARE, null);
            } else
            {
                setLayerType(View.LAYER_TYPE_SOFTWARE, null);
            }
        }

        if (properties.has("setBackgroundColor"))
        {
            try
            {
                setBackgroundColor(Color.parseColor(properties.optString("setBackgroundColor", "#00000000")));
            } catch (Exception e)
            {
            }
        }
    }
}
