package com.kidoz.sdk.api.ui_views.feed_view;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

import org.json.JSONObject;

import java.io.File;

public class FeedFamilyViewDialog extends BaseDialog
{
    public static final String TAG = FeedFamilyViewDialog.class.getSimpleName();

    private RelativeLayout mRootView;
    private RelativeLayout mViewContainer;
    private OneItemFamilyView mOneItemFamilyView;
    private AssetView mNextButton;
    private AssetView mPreviousButton;
    private AssetView mAnimation;

    private AssetView mParentalLockButton;
    private AssetView mAboutButton;
    private AssetView mExitButton;

    private TextView mKidozLabelTextView;
    private LoadingProgressView mLoadingProgressView;

    protected JSONObject mProperties;

    // Close button click listener
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mAllowClickHandling = true;
    private boolean mIsAutomaticInvocation = false;

    private String mStyleId = null;

    public FeedFamilyViewDialog(Context context, IOnFeedViewEventListener listener, boolean automatic, JSONObject properties)
    {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);

        mProperties = properties;
        mStyleId = mProperties.optString(STYLE_ID);

        mIsAutomaticInvocation = automatic;
        mOnInterstitialViewEventListener = listener;
        initDialog();
    }

    private void initDialog()
    {
        setCancelable(false);
        setCanceledOnTouchOutside(false);

        initRootView();

        initFamilyOneItemView();

        initLoadingProgressView();
        initNextAndPreviousButtons();
        initAnimation();

        initParentalLockButton();
        initAboutKidozButton();
        initExitButton();

        initKidozText();

        // Apply layout params
        applayViewContainerParams();
        applyViewPagerLayoutParams();
        applyNextButtonLayoutParams();
        applyPreviousButtonLayoutParams();
        applyAnimationLayoutParams();
        applyLoadingViewLayoutParams();

        mOneItemFamilyView.showLoadingProgressView(true);
    }

    private void initLoadingProgressView()
    {
        mLoadingProgressView = new LoadingProgressView(getContext());
        mLoadingProgressView.setVisibility(View.GONE);

        LinearLayout layout = new LinearLayout(getContext());
        layout.setGravity(Gravity.CENTER);
        layout.addView(mLoadingProgressView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.ALIGN_LEFT, mOneItemFamilyView.getId());
        params.addRule(RelativeLayout.ALIGN_TOP, mOneItemFamilyView.getId());
        params.addRule(RelativeLayout.ALIGN_RIGHT, mOneItemFamilyView.getId());
        params.addRule(RelativeLayout.ALIGN_BOTTOM, mOneItemFamilyView.getId());
        mViewContainer.addView(layout, params);
    }

    private void applayViewContainerParams()
    {
        int width = ScreenUtils.getScreenSize(getContext(), true);
        int height = ScreenUtils.getScreenSize(getContext(), false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        if (ScreenUtils.getIsTablet(getContext()) == false)
        {
            // This is a phone
            if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
            {
                params.width = width - ScreenUtils.getStatusBarHeight(getContext());
                params.height = params.width;
            } else
            {
                params.width = height - ScreenUtils.getStatusBarHeight(getContext());
                params.height = params.width;
            }
        } else
        {
            // This is a tablet
            if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
            {
                params.width = width - ScreenUtils.getStatusBarHeight(getContext()) - ScreenUtils.getNavigationBarHeight(getContext());
                params.height = params.width;
            } else
            {
                params.width = height - ScreenUtils.getStatusBarHeight(getContext()) - ScreenUtils.getNavigationBarHeight(getContext());
                params.height = params.width;
            }
        }
        mViewContainer.setLayoutParams(params);
    }

    private void applyLoadingViewLayoutParams()
    {
        int containerWidth = mViewContainer.getLayoutParams().width;
        mLoadingProgressView.setCircleWidth(containerWidth * 0.008f);
        int loadingViewSize = (int) (containerWidth * 0.15f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(loadingViewSize, loadingViewSize);
        mLoadingProgressView.setLayoutParams(params);
    }

    private void initKidozText()
    {
        mKidozLabelTextView = new TextView(getContext());
        mKidozLabelTextView.setGravity(Gravity.CENTER);
        float tabletSize = Utils.spTOpx(getContext(), 10);
        float phoneSize = Utils.spTOpx(getContext(), 4);
        float textSize = ScreenUtils.getIsTablet(getContext()) ? tabletSize : phoneSize;
        mKidozLabelTextView.setTextSize(textSize);
        int margin = Utils.dpTOpx(getContext(), 5);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.leftMargin = margin;
        params.rightMargin = margin;
        params.bottomMargin = margin;
        params.addRule(RelativeLayout.RIGHT_OF, mAboutButton.getId());
        params.addRule(RelativeLayout.LEFT_OF, mParentalLockButton.getId());
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        mRootView.addView(mKidozLabelTextView, params);

        try
        {
            mKidozLabelTextView.setText(mProperties.optString(LABEL_TEXT));
            mKidozLabelTextView.setTextColor(Color.parseColor(mProperties.optString(LABEL_COLOR).trim()));
        } catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to load label: " + ex.getMessage());
        }
    }

    private void initNextAndPreviousButtons()
    {
        mNextButton = new AssetView(getContext());
        mNextButton.setScaleType(ImageView.ScaleType.FIT_XY);
        mNextButton.setId(Utils.generateViewId());
        String clickAnimation = mProperties.optString(NEXT_BUTTON_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_LEFT) == true)
            {
                mNextButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View v)
                    {
                        mNextButton.setClickable(false);
                        GenAnimator.playPressLeftAnimation(mNextButton, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                mNextButton.setClickable(true);
                                mOneItemFamilyView.nextPagerItem();
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {

                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {

                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mNextButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mNextButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mNextButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mNextButton.setClickable(true);
                                mOneItemFamilyView.nextPagerItem();
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }

        mViewContainer.addView(mNextButton);
        mNextButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(NEXT_BUTTON)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                openDialog();
            }
        });

        mPreviousButton = new AssetView(getContext());
        mPreviousButton.setScaleType(ImageView.ScaleType.FIT_XY);
        mPreviousButton.setId(Utils.generateViewId());
        clickAnimation = mProperties.optString(PREVIOUS_BUTTON_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_RIGHT) == true)
            {
                mPreviousButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View v)
                    {
                        mPreviousButton.setClickable(false);
                        GenAnimator.playPressRightAnimation(mPreviousButton, new Animator.AnimatorListener()
                        {
                            @Override
                            public void onAnimationStart(Animator animation)
                            {
                            }

                            @Override
                            public void onAnimationEnd(Animator animation)
                            {
                                mPreviousButton.setClickable(true);
                                mOneItemFamilyView.previousItem();
                            }

                            @Override
                            public void onAnimationCancel(Animator animation)
                            {
                            }

                            @Override
                            public void onAnimationRepeat(Animator animation)
                            {
                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mPreviousButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mPreviousButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mPreviousButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mPreviousButton.setClickable(true);
                                mOneItemFamilyView.previousItem();
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }
        mViewContainer.addView(mPreviousButton);
        mPreviousButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PREVIOUS_BUTTON)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                openDialog();
            }
        });
    }

    private void initAnimation()
    {
        mAnimation = new AssetView(getContext());
        mAnimation.setScaleType(ImageView.ScaleType.FIT_XY);
        mAnimation.setId(Utils.generateViewId());
        mViewContainer.addView(mAnimation);
        mAnimation.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener()
        {
            @Override
            public void onAssetLoaded(boolean successfull)
            {
                openDialog();
            }
        });
    }

    private void initExitButton()
    {
        mExitButton = new AssetView(getContext());
        mExitButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mExitButton.setId(Utils.generateViewId());
        String clickAnimation = mProperties.optString(X_BUTTON_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mExitButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mExitButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mExitButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mExitButton.setClickable(true);
                                if (mCloseBtnClickListener != null)
                                {
                                    mCloseBtnClickListener.onClick(null);
                                }
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }
        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);
        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(X_BUTTON));
        if (imageFile.exists())
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);

            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.08f), (int) (relevantSize * 0.08f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
            params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
            mRootView.addView(mExitButton, params);
            mExitButton.loadAsset(imageFile, new AssetView.IOnAssetLoadedListener()
            {
                @Override
                public void onAssetLoaded(boolean successfull)
                {
                    openDialog();
                }
            });
        }
    }

    private void initRootView()
    {
        mRootView = new RelativeLayout(getContext());
        mRootView.setBackgroundColor(Color.parseColor(mProperties.optString(BACKGROUND_ROOT_COLOR, "#CC261304")));

        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(ViewGroup.MarginLayoutParams.MATCH_PARENT, ViewGroup.MarginLayoutParams.MATCH_PARENT);
        setContentView(mRootView, params);

        mViewContainer = new RelativeLayout(getContext());
        mRootView.addView(mViewContainer);
    }

    private void initParentalLockButton()
    {
        mParentalLockButton = new AssetView(getContext());
        mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mParentalLockButton.setId(Utils.generateViewId());
        String clickAnimation = mProperties.optString(LOCK_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mParentalLockButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mParentalLockButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mParentalLockButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mParentalLockButton.setClickable(true);
                                if (ParentalLockDialog.getIsCanShowDialog(getContext()) == true)
                                {
                                    int[] popLocation = new int[2];
                                    popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                    popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(getContext(), false, popLocation);
                                    parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener()
                                    {
                                        @Override
                                        public void onDismiss(DialogInterface dialog)
                                        {
                                            //Refresh the parental lock icon
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener()
                                    {
                                        @Override
                                        public void onPasswordEntered(boolean isPasswordCorrect)
                                        {
                                            updateLockIcon();
                                        }
                                    });
                                    parentalLockDialog.show();
                                }
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }

        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);

        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE));
        if (imageFile.exists())
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.08f), (int) (relevantSize * 0.08f));

            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            mRootView.addView(mParentalLockButton, params);

            updateLockIcon();
        }
    }

    private void updateLockIcon()
    {
        try
        {
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;
            if (isLockActive == true)
            {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener()
                {
                    @Override
                    public void onAssetLoaded(boolean successfull)
                    {
                        openDialog();
                    }
                });
            } else
            {
                mParentalLockButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener()
                {
                    @Override
                    public void onAssetLoaded(boolean successfull)
                    {
                        openDialog();
                    }
                });
            }
        } catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initAboutKidozButton()
    {
        mAboutButton = new AssetView(getContext());
        mAboutButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        mAboutButton.setId(Utils.generateViewId());

        String clickAnimation = mProperties.optString(ABOUT_KIDOZ_ANIMATION);
        if (clickAnimation != null)
        {
            if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT) == true)
            {
                mAboutButton.setOnClickListener(new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        mAboutButton.setClickable(false);
                        GenAnimator.clickItemAnimation(mAboutButton, 150, new GenAnimator.ViewAnimationListener()
                        {
                            @Override
                            public void onAnimationEnd()
                            {
                                mAboutButton.setClickable(true);
                                int[] popLocation = new int[2];
                                popLocation[0] = (int) (ScreenUtils.getScreenSize(getContext(), true) * 0.5f);
                                popLocation[1] = (int) (ScreenUtils.getScreenSize(getContext(), false) * 0.5f);
                                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(getContext(), popLocation);
                                aboutKidozDialog.openDialog();
                            }

                            @Override
                            public void onAnimationStart()
                            {

                            }
                        });
                    }
                });
            }
        }

        int width = ScreenUtils.getScreenSize(getContext(), true) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int height = ScreenUtils.getScreenSize(getContext(), false) - (ScreenUtils.getStatusBarHeight(getContext()) + ScreenUtils.getNavigationBarHeight(getContext()));
        int relevantSize = Math.max(width, height);

        File imageFile = AssetUtil.getAssetFile(getContext(), mProperties.optString(ABOUT_KIDOZ));
        if (imageFile.exists())
        {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(imageFile.getAbsolutePath(), options);

            int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 10, getContext().getResources().getDisplayMetrics());
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int) (relevantSize * 0.06f), (int) (relevantSize * 0.06f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            params.leftMargin = margin;
            params.bottomMargin = margin;
            mRootView.addView(mAboutButton, params);

            mAboutButton.loadAsset(AssetUtil.getAssetFile(getContext(), mProperties.optString(ABOUT_KIDOZ)), new AssetView.IOnAssetLoadedListener()
            {
                @Override
                public void onAssetLoaded(boolean successfull)
                {
                    openDialog();
                }
            });
        }
    }

    private void initFamilyOneItemView()
    {
        mOneItemFamilyView = new OneItemFamilyView(getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, mProperties, new OneItemFamilyView.IOnOneItemActionListener()
        {
            @Override
            public void onAction(OneItemFamilyView.OneItemAction action)
            {
                switch (action)
                {
                    case STOP_ANY_ANIMATION:
                    {
                        mAnimation.stopGifAnim();
                        break;
                    }

                    case RESTART_ANY_ANIMATION:
                    {
                        mAnimation.startGifAnim();
                        break;
                    }
                }
            }
        });

        mOneItemFamilyView.setOnRefreshDrawRequestListener(new OneItemFamilyView.IOnRefreshListener()
        {
            @Override
            public void onRefreshDrawRequest()
            {
                mViewContainer.requestFocus();
                mViewContainer.bringToFront();
            }
        });

        mOneItemFamilyView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.setMargins(0, Utils.dpTOpx(getContext(), 2), 0, Utils.dpTOpx(getContext(), -2));
        mViewContainer.addView(mOneItemFamilyView, params);

        mOneItemFamilyView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener()
        {
            @Override
            public void onClickEnd(ContentItem contentItem, int position)
            {
                if (mAllowClickHandling)
                {
                    mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener()
                    {
                        @Override
                        public void onRestoreClick()
                        {
                            mAllowClickHandling = true;
                        }
                    });
                }
            }
        });
    }

    private void applyViewPagerLayoutParams()
    {
        int horizontalMargin = Utils.dpTOpx(getContext(), 20);
        int bottomlMargin = Utils.dpTOpx(getContext(), 24);
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = containerWidth - horizontalMargin * 2;
        int viewHeight = (int) (viewWidth * 3f / 4f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.CENTER_HORIZONTAL);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.bottomMargin = bottomlMargin;
        mOneItemFamilyView.setLayoutParams(params);
    }

    private void applyAnimationLayoutParams()
    {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = containerWidth;
        int viewHeight;
        if (ScreenUtils.getIsTablet(getContext()) == false)
        {
            // On phone the ratio seems to be more accurate this way.
            viewHeight = (int) (containerWidth * 0.366f);
        } else
        {
            // On tablet the ratio seems to be more accurate this way.
            viewHeight = (int) (containerWidth * 0.357f);
        }

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        mAnimation.setLayoutParams(params);
    }

    private void applyNextButtonLayoutParams()
    {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = (int) (containerWidth * 0.17f);
        int viewHeight = (int) (containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        params.topMargin = (int) (containerWidth * 0.43f);
        mNextButton.setLayoutParams(params);
    }

    private void applyPreviousButtonLayoutParams()
    {
        int containerWidth = mViewContainer.getLayoutParams().width;
        int viewWidth = (int) (containerWidth * 0.17f);
        int viewHeight = (int) (containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
        params.topMargin = (int) (containerWidth * 0.43f);
        mPreviousButton.setLayoutParams(params);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        setOnDismissListener(new OnDismissListener()
        {
            @Override
            public void onDismiss(DialogInterface dialog)
            {
                if (mOnInterstitialViewEventListener != null)
                {
                    mOnInterstitialViewEventListener.onDismissView();
                }

                if (mOneItemFamilyView != null)
                {
                    mOneItemFamilyView.invokeWidgetClose();
                }
            }
        });
    }

    public void setContentData(ContentData contentData)
    {
        mOneItemFamilyView.setContent(contentData.getContentDataItems());
        mOneItemFamilyView.showLoadingProgressView(false);
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    public void setOnCloseButtonClickListener(View.OnClickListener clickListenr)
    {
        mCloseBtnClickListener = clickListenr;
    }

    @Override
    public Bundle onSaveInstanceState()
    {
        Bundle bundle = super.onSaveInstanceState();

        return bundle;
    }

    @Override
    public void closeDialog()
    {
        mIsWaitingToOpen = false;
        super.closeDialog();
    }

    @Override
    public synchronized void openDialog()
    {
        mIsWaitingToOpen = true;
        if (KidozSDK.isInitialised())
        {
            if (isShowing() == false && mIsWaitingToOpen == true && getIsCanOpen() == true)
            {
                super.openDialog();
                animateOpen();
                Event event = new Event();
                if (mIsAutomaticInvocation)
                {
                    event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.AUTOMATIC_OPEN);
                } else
                {
                    event.addParameterToJsonObject(EventParameters.LABEL_VIEW_OPEN_TYPE, EventParameters.MANUAL_OPEN);
                }
                EventManager.getInstance(mCallingActivity).logEvent(mCallingActivity, WidgetType.WIDGET_TYPE_FEED.getStringValue(), mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, EventParameters.FEED_VIEW);

                if (mOneItemFamilyView != null)
                {
                    mOneItemFamilyView.invokeWidgetOpen();
                }
            }
        }
    }

    private void animateOpen()
    {
        GenAnimator.playGrowAnimation(mViewContainer, 500, 0, new DecelerateInterpolator(1.5f), new Animator.AnimatorListener()
        {
            @Override
            public void onAnimationStart(Animator animation)
            {
            }

            @Override
            public void onAnimationEnd(Animator animation)
            {
            }

            @Override
            public void onAnimationCancel(Animator animation)
            {
            }

            @Override
            public void onAnimationRepeat(Animator animation)
            {
            }
        });
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener)
    {
        if (onInterstitialViewEventListener != null)
        {
            mOnInterstitialViewEventListener = onInterstitialViewEventListener;
        }
    }

    @Override
    public void onDetachedFromWindow()
    {
        getMyHandlerInstance().removeCallbacksAndMessages(null);

        super.onDetachedFromWindow();

        // Restore previous orientation
        restoreUserOriginalOrientation();

        if (mOneItemFamilyView != null)
        {
            mOneItemFamilyView.stopAnyPlaybackAction(true);
        }

        mIsWaitingToOpen = false;
    }

    /**
     * Get if feed dialog is waiting to be opened, witch means he is waiting state
     *
     * @return true or false
     */
    public boolean isWaitingToOpen()
    {
        return mIsWaitingToOpen;
    }

    @Override
    public void onAttachedToWindow()
    {
        super.onAttachedToWindow();
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean isVisible)
    {
        super.onDialogWindowVisibilityChange(isVisible);

        if (isVisible == false)
        {
            EventManager.getInstance(getContext()).startEventsSync(getContext());
        }
        mAllowClickHandling = true;

        if (mOneItemFamilyView != null)
        {
            mOneItemFamilyView.stopAnyPlaybackAction(true);
        }
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible)
    {
        super.onDialogFocusChange(isVisible);
        if (isVisible)
        {
            mAllowClickHandling = true;
        } else
        {
            mAllowClickHandling = false;
        }
    }

    @Override
    protected void onDialogOrientationChange(boolean isPortrait)
    {
        super.onDialogOrientationChange(isPortrait);
    }

    @Override
    public boolean getIsCanOpen()
    {
        boolean result = false;
        if (mParentalLockButton != null && mAboutButton != null && mExitButton != null && mAnimation != null && mNextButton != null && mPreviousButton != null)
        {
            result = mParentalLockButton.getIsAssetLoaded() && mAboutButton.getIsAssetLoaded() && mExitButton.getIsAssetLoaded() && mAnimation.getIsAssetLoaded() && mNextButton.getIsAssetLoaded() && mPreviousButton.getIsAssetLoaded();
        }
        return result;
    }

    private void showLoadingProgressView(boolean show)
    {
        if (show)
        {
            mLoadingProgressView.setVisibility(View.VISIBLE);
            mLoadingProgressView.startLoadingAnimation();
        } else
        {
            mLoadingProgressView.stopLoadingAnimation();
            mLoadingProgressView.setVisibility(View.GONE);
        }
    }

    // Parsing related.
    public static final String STYLE_ID = "style_id";
    public static final String FEED_BUTTON = "feedButton";
    public static final String FEED_BUTTON_SCALE = "feedButtonScale";
    public static final String ABOUT_KIDOZ = "aboutKidoz";
    public static final String ABOUT_KIDOZ_ANIMATION = "aboutKidozAnimation";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String BACKGROUND_IMAGE = "bgImage";
    public static final String NEXT_BUTTON = "nextBtn";
    public static final String NEXT_BUTTON_ANIMATION = "nextBtnAnimation";
    public static final String PREVIOUS_BUTTON = "previousBtn";
    public static final String PREVIOUS_BUTTON_ANIMATION = "previousBtnAnimation";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String X_BUTTON = "xBtn";
    public static final String X_BUTTON_ANIMATION = "XBtnAnimation";
    public static final String HTML_MAXIMIZE_BTN = "htmlMaximizeBtn";
    public static final String BACKGROUND_ROOT_COLOR = "bgRootColor";

    /**
     * Compare new JSON to old JSON, save the updated JSON to database, delete old assets if needed and download new assets.
     *
     * @param context
     * @param jsonObject
     */
    public static boolean parseFamilyFeed(Context context, JSONObject jsonObject)
    {

        boolean result = false;
        if (jsonObject != null)
        {
            try
            {

                jsonObject.put(FeedView.TAG, FeedFamilyViewDialog.class.getSimpleName());

                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(FeedView.TAG);

                result = AssetUtil.loadAsset(context, oldData, jsonObject, FEED_BUTTON);
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, ABOUT_KIDOZ);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BACKGROUND_IMAGE);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BUTTON);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PREVIOUS_BUTTON);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PROMOTION_ANIMATION);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, X_BUTTON);
                }
                if (result)
                {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, HTML_MAXIMIZE_BTN);
                }

                if (result == true)
                {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(FeedView.TAG, jsonObject);
                }
            } catch (Exception ex)
            {
                result = false;
                SDKLogger.printErrorLog(FeedView.TAG, "Error when trying to parse family feed properties: " + ex.getMessage());
            }
        }
        return result;
    }

    /**
     * Used for resuming any action or playback happened before pause
     */
    public void resumeAction(boolean resume)
    {
        if (mOneItemFamilyView != null)
        {
            if (resume)
            {
                mOneItemFamilyView.resumePlaybackAction();
            }
        }

        // if (mAnimation != null) mAnimation.startGifAnim();
    }

    /**
     * Used for pause/stop any action or playback
     */
    public void pauseAction(boolean withFocusOff)
    {
        if (mOneItemFamilyView != null)
        {
            mOneItemFamilyView.stopAnyPlaybackAction(withFocusOff);
        }

        if (mAnimation != null) mAnimation.stopGifAnim();
    }
}
