package com.kidoz.sdk.api.server_connect;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Created by User on 08/07/2015.
 *
 */
public class StreamToStringConverter {

    protected static final int IO_BUFFER_SIZE = 4 * 1024;

    /**
     * Convert input stream to a string
     *
     * @param is
     *            input stream
     * @return string result
     *
     * */
    public static String readStream(BufferedInputStream is,BaseAPIManager.RequestAsyncTask task,boolean checkTaskStatus)
    {
        ByteArrayOutputStream bo = null;
        boolean isCanceled = false;
        try
        {
            byte[] buffer = new byte[IO_BUFFER_SIZE];
            bo = new ByteArrayOutputStream(is.available());
            int i = is.read(buffer);
            while (i > 0)
            {
                if (checkTaskStatus && (task == null || task.isCancelled()))
                {
                    isCanceled = true;
                    break;
                }
                bo.write(buffer, 0, i);
                i = is.read(buffer);
            }
            if (isCanceled)
            {
                return null;
            }
            else
            {
                return bo.toString();
            }
        }
        catch (IOException e)
        {
            return null;
        }
        finally
        {
            try
            {
                if(is != null) {
                    is.close();
                }

                if(bo != null) {
                    bo.close();
                }
            }
            catch (IOException e)
            {}
        }
    }

}
