package com.kidoz.sdk.api.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class SdkReceiver extends BroadcastReceiver {
    private final String TAG = SdkReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent != null) {
            String action = intent.getAction();
            if (action != null) {
                if (action.equalsIgnoreCase(Intent.ACTION_PACKAGE_ADDED)) {
                    if (intent.getData() != null) {
                        String packageName = intent.getData().getSchemeSpecificPart();
                        if (packageName != null) {
                            SDKLogger.printWarningLog("--------------------+++++++  INSTALL RECEIVER LAUNCHED ++++++ ------------------");
                            updateInstallEvent(context, packageName);
                        }
                    }
                }
            }
        }
    }


    private void updateInstallEvent(Context context, String packageName) {
        final int MAX_ACCEPTABLE_INSTALL_INTERVAL = 24 * 60 * 60 * 1000;  // 24 hours

        DatabaseManager databaseManager = DatabaseManager.getInstance(context);
        if (databaseManager != null) {
            IsEventRecord record = databaseManager.getIsEventTable().getRecord(packageName);
            if (record != null) {
                long setTime = -1;
                try {
                    setTime = Long.parseLong(record.getTimeStamp());
                } catch (NumberFormatException e) {
                    setTime = -1;
                }

                if (setTime != -1 && ((System.currentTimeMillis() - setTime) < MAX_ACCEPTABLE_INSTALL_INTERVAL)) {
                    // Send event
                    EventManager.getInstance(context).logSponsoredContentInstallEvent(context, record.getWidgetType(), record.getStyleId(), record.getPackageName(), record.getAdvertiserId(), record.getPackageName(), record.getPositionIndex());
                    EventManager.getInstance(context).startEventsSync(context);

                    // Send event
                    if (ConstantDef.DGM) {
                        SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!!");
                        SDKLogger.printWarningLog("\ngetPackageName : " + record.getPackageName());
                        SDKLogger.printWarningLog("\ngetTimeStamp : " + record.getTimeStamp());
                        SDKLogger.printWarningLog("\ngetItemType : " + record.getContentType());
                        SDKLogger.printWarningLog("\ngetLocationInFeed : " + record.getPositionIndex());
                        SDKLogger.printWarningLog("\ngetApppName : " + record.getName());
                        SDKLogger.printWarningLog("\ngetAdvertiser ID : " + record.getAdvertiserId());
                        SDKLogger.printWarningLog("\ngetWidgetType : " + record.getWidgetType());
                        SDKLogger.printWarningLog("\ngetStyleId : " + record.getStyleId());
                    }
                }
                databaseManager.getIsEventTable().deleteRecord(packageName);
            }
        }
    }
}
