/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifInfoHandle;

public class GifAnimationMetaData
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 5692363926580237325L;
    private final int mLoopCount;
    private final int mDuration;
    private final int mHeight;
    private final int mWidth;
    private final int mImageCount;
    public static final Parcelable.Creator<GifAnimationMetaData> CREATOR = new Parcelable.Creator<GifAnimationMetaData>(){

        public GifAnimationMetaData createFromParcel(Parcel source) {
            return new GifAnimationMetaData(source);
        }

        public GifAnimationMetaData[] newArray(int size) {
            return new GifAnimationMetaData[size];
        }
    };

    public GifAnimationMetaData(@NonNull Resources res, @DrawableRes @RawRes int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
    }

    public GifAnimationMetaData(@NonNull AssetManager assets, @NonNull String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifAnimationMetaData(@NonNull String filePath) throws IOException {
        this(GifInfoHandle.openFile(filePath, true));
    }

    public GifAnimationMetaData(@NonNull File file) throws IOException {
        this(GifInfoHandle.openFile(file.getPath(), true));
    }

    public GifAnimationMetaData(@NonNull InputStream stream) throws IOException {
        this(GifInfoHandle.openMarkableInputStream(stream, true));
    }

    public GifAnimationMetaData(@NonNull AssetFileDescriptor afd) throws IOException {
        this(GifInfoHandle.openAssetFileDescriptor(afd, true));
    }

    public GifAnimationMetaData(@NonNull FileDescriptor fd) throws IOException {
        this(GifInfoHandle.openFd(fd, 0L, true));
    }

    public GifAnimationMetaData(@NonNull byte[] bytes) throws IOException {
        this(GifInfoHandle.openByteArray(bytes, true));
    }

    public GifAnimationMetaData(@NonNull ByteBuffer buffer) throws IOException {
        this(GifInfoHandle.openDirectByteBuffer(buffer, true));
    }

    public GifAnimationMetaData(@Nullable ContentResolver resolver, @NonNull Uri uri) throws IOException {
        this(GifInfoHandle.openUri(resolver, uri, true));
    }

    private GifAnimationMetaData(GifInfoHandle gifInfoHandle) {
        this.mLoopCount = gifInfoHandle.getLoopCount();
        this.mDuration = gifInfoHandle.getDuration();
        gifInfoHandle.recycle();
        this.mWidth = gifInfoHandle.width;
        this.mHeight = gifInfoHandle.height;
        this.mImageCount = gifInfoHandle.frameCount;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getNumberOfFrames() {
        return this.mImageCount;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public boolean isAnimated() {
        return this.mImageCount > 1 && this.mDuration > 0;
    }

    public String toString() {
        String loopCount = this.mLoopCount == 0 ? "Infinity" : Integer.toString(this.mLoopCount);
        String suffix = String.format(Locale.US, "GIF: size: %dx%d, frames: %d, loops: %s, duration: %d", this.mWidth, this.mHeight, this.mImageCount, loopCount, this.mDuration);
        return this.isAnimated() ? "Animated " + suffix : suffix;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLoopCount);
        dest.writeInt(this.mDuration);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mImageCount);
    }

    private GifAnimationMetaData(Parcel in) {
        this.mLoopCount = in.readInt();
        this.mDuration = in.readInt();
        this.mHeight = in.readInt();
        this.mWidth = in.readInt();
        this.mImageCount = in.readInt();
    }
}

