/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.imagelib;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import com.squareup.imagelib.Downloader;
import com.squareup.imagelib.NetworkPolicy;
import com.squareup.imagelib.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpDownloader
implements Downloader {
    private OkHttpClient client;

    private static OkHttpClient defaultOkHttpClient(File cacheDir, long maxSize) {
        File file;
        Cache cache = null;
        if (cacheDir != null && maxSize != -1L && (file = Environment.getDownloadCacheDirectory()) != null && (file = new File(file.getAbsolutePath() + File.separator + "SDKhttpCacheDir")) != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            int cacheSize = 0xA00000;
            cache = new Cache(file, (long)cacheSize);
        }
        OkHttpClient result = cache != null ? new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).cache(cache).build() : new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        return result;
    }

    public OkHttpDownloader(Context context) {
        this(Utils.createDefaultCacheDir(context));
    }

    public OkHttpDownloader(File cacheDir) {
        this(cacheDir, Utils.calculateDiskCacheSize(cacheDir));
    }

    public OkHttpDownloader(Context context, long maxSize) {
        this(Utils.createDefaultCacheDir(context), maxSize);
    }

    public OkHttpDownloader(File cacheDir, long maxSize) {
        this(OkHttpDownloader.defaultOkHttpClient(cacheDir, maxSize));
    }

    public OkHttpDownloader(OkHttpClient client) {
        this.client = client;
    }

    protected final OkHttpClient getClient() {
        return this.client;
    }

    @Override
    public Downloader.Response load(Uri uri, int networkPolicy) throws IOException {
        Downloader.Response result = null;
        CacheControl cacheControl = null;
        if (networkPolicy != 0) {
            if (NetworkPolicy.isOfflineOnly(networkPolicy)) {
                cacheControl = CacheControl.FORCE_CACHE;
            } else {
                CacheControl.Builder builder = new CacheControl.Builder();
                if (!NetworkPolicy.shouldReadFromDiskCache(networkPolicy)) {
                    builder.noCache();
                }
                if (!NetworkPolicy.shouldWriteToDiskCache(networkPolicy)) {
                    builder.noStore();
                }
                cacheControl = builder.build();
            }
        }
        Request request = cacheControl != null ? new Request.Builder().cacheControl(cacheControl).url(uri.toString()).build() : new Request.Builder().url(uri.toString()).build();
        Call call = this.client.newCall(request);
        boolean fromCache = false;
        if (call != null) {
            Response response = call.execute();
            int responseCode = response.code();
            if (responseCode >= 300) {
                response.body().close();
                throw new Downloader.ResponseException(responseCode + " " + response.message(), networkPolicy, responseCode);
            }
            fromCache = response.cacheResponse() != null;
            ResponseBody responseBody = response.body();
            result = new Downloader.Response(responseBody.byteStream(), fromCache, responseBody.contentLength());
        }
        return result;
    }

    @Override
    public void shutdown() {
        Cache cache = this.client.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

