/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.util.Random;

public class KenBurnsView
extends FrameLayout {
    private static final String TAG = "KenBurnsView";
    private final Handler mHandler = new Handler();
    private int[] mResourceIds;
    private ImageView[] mImageViews;
    private int mActiveImageIndex = -1;
    private final Random random = new Random();
    private int mSwapMs = 1500;
    private int mFadeInOutMs = 400;
    private float maxScaleFactor = 1.2f;
    private float minScaleFactor = 1.0f;
    float mFromScale = 1.5f;
    float mFromTranslationX;
    float mFromTranslationY;
    private Runnable mSwapImageRunnable = new Runnable(){

        @Override
        public void run() {
            KenBurnsView.this.swapImage();
            KenBurnsView.this.mHandler.postDelayed(KenBurnsView.this.mSwapImageRunnable, (long)KenBurnsView.this.mSwapMs);
        }
    };

    public KenBurnsView(Context context) {
        super(context);
        this.mImageViews = new ImageView[1];
        this.mImageViews[0] = new ImageView(this.getContext());
        this.mImageViews[0].setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mImageViews[0].setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        ViewPropertyAnimator propertyAnimator = this.mImageViews[0].animate();
        propertyAnimator.scaleX(this.mFromScale).scaleY(this.mFromScale).setDuration(0L);
        this.addView((View)this.mImageViews[0]);
    }

    public KenBurnsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public KenBurnsView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setResourceIds(int ... resourceIds) {
        this.mResourceIds = resourceIds;
        this.fillImageViews();
    }

    public void setBitmap(Bitmap bitmap) {
        this.fillImageViewsWithBitmaps(bitmap);
    }

    private void swapImage() {
        this.animate((View)this.mImageViews[0]);
    }

    private void start(View view, long duration, float fromScale, float toScale, float fromTranslationX, float fromTranslationY, float toTranslationX, float toTranslationY) {
        ViewPropertyAnimator propertyAnimator = view.animate();
        propertyAnimator.translationX(toTranslationX).translationY(toTranslationY).scaleX(toScale).scaleY(toScale).setDuration(duration);
    }

    private float pickScale() {
        return this.minScaleFactor + this.random.nextFloat() * (this.maxScaleFactor - this.minScaleFactor);
    }

    private float pickTranslation(int value, float ratio) {
        return (float)value * (ratio - 1.0f) * (this.random.nextFloat() - 0.5f);
    }

    public void animate(View view) {
        float toScale = this.pickScale();
        float toTranslationX = this.pickTranslation(view.getWidth(), toScale);
        float toTranslationY = this.pickTranslation(view.getHeight(), toScale);
        this.start(view, this.mSwapMs, this.mFromScale, toScale, this.mFromTranslationX, this.mFromTranslationY, toTranslationX, toTranslationY);
        this.mFromScale = toScale;
        this.mFromTranslationX = toTranslationX;
        this.mFromTranslationY = toTranslationY;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacks(this.mSwapImageRunnable);
    }

    public void startKenBurnsAnimation() {
        this.mHandler.post(this.mSwapImageRunnable);
    }

    private void fillImageViews() {
        for (int i = 0; i < this.mImageViews.length; ++i) {
            this.mImageViews[i].setImageResource(this.mResourceIds[i]);
        }
    }

    private void fillImageViewsWithBitmaps(Bitmap bitmap) {
        this.mImageViews[0].setImageBitmap(bitmap);
    }

    public ImageView getImageView() {
        return this.mImageViews[0];
    }
}

