/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.content.Context;
import android.content.Intent;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.KidozAdActivity;
import de.greenrobot.event.EventBus;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class IntrstWrapper {
    private static IntrstWrapper mInstance = null;
    public Context mContext;
    private HtmlViewWrapper webView;
    private ContentLogicLoader mContentLogicLoader;
    private String mStyleId;
    private boolean mIsInitialLoadFinished = false;
    private boolean mIsAutoLoadOnHtmlReady = false;
    private boolean mAutoShowOnLoad = false;
    private JSONObject mProperties;
    private Lock mLaunchLock;
    private boolean mIsInvokeEvents = false;
    private ContentItem mAdItem;
    private boolean mClearCache;

    public static IntrstWrapper initInstance(Context context) {
        if (mInstance == null) {
            mInstance = new IntrstWrapper(context);
            return mInstance;
        }
        mInstance.validateIfPrepared();
        return mInstance;
    }

    protected IntrstWrapper(Context context) {
        this.mContext = context;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mLaunchLock = new ReentrantLock();
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.initContentLogicLoader();
    }

    private void validateLayoutAndAssets() {
        SdkAPIManager.getSdkApiInstance(this.mContext).getStyle(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getValue(), new ApiResultCallback<Boolean>(){

            @Override
            public void onServerResult(ResultData<?> result) {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                    if (result.getData() != null) {
                        boolean isResultReady = (Boolean)result.getData();
                        if (isResultReady) {
                            IntrstWrapper.this.mProperties = DatabaseManager.getInstance(IntrstWrapper.this.mContext).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (IntrstWrapper.this.mProperties != null) {
                                IntrstWrapper.this.mStyleId = IntrstWrapper.this.mProperties.optString("style_id");
                            }
                            IntrstWrapper.this.prepareWebView();
                        } else {
                            this.onFailed();
                        }
                    }
                } else {
                    this.onFailed();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    private synchronized void prepareWebView() {
        this.webView = HtmlManager.getIntrstDefaultHtmlView(this.mContext);
        if (this.webView == null) {
            this.webView = HtmlManager.initIntrstDefaultHtmlView(this.mContext);
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    IntrstWrapper.this.mIsInitialLoadFinished = true;
                    if (IntrstWrapper.this.mIsAutoLoadOnHtmlReady) {
                        IntrstWrapper.this.mIsAutoLoadOnHtmlReady = false;
                        IntrstWrapper.this.mContentLogicLoader.loadContent(IntrstWrapper.this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), IntrstWrapper.this.mStyleId);
                    }
                }
            });
            PropertiesObj appConfig = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
            if (appConfig != null) {
                this.webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
            }
        } else {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            if (!this.mIsInitialLoadFinished) {
                PropertiesObj appConfig = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
                if (appConfig != null) {
                    this.webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
                }
            } else if (this.mIsAutoLoadOnHtmlReady) {
                this.mIsAutoLoadOnHtmlReady = false;
                this.mContentLogicLoader.loadContent(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId);
            }
        }
    }

    public void load(boolean invokeEvents, boolean autoShowOnLoad) {
        this.mIsInvokeEvents = invokeEvents;
        this.mAutoShowOnLoad = autoShowOnLoad;
        if (this.mIsInitialLoadFinished) {
            this.mContentLogicLoader.loadContent(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId);
        } else {
            this.mIsAutoLoadOnHtmlReady = true;
        }
    }

    public void show() {
        if (this.mAdItem != null) {
            this.openActivity(this.mAdItem);
        }
    }

    public boolean isInterstitialLoaded() {
        return this.mAdItem != null;
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                ContentItem contentItem;
                if (contentData != null && contentData.isHasContentToShow() && (contentItem = contentData.getContentDataItems().get(0)).getContentType() == ContentType.HTML) {
                    IntrstWrapper.this.mAdItem = contentItem;
                    if (IntrstWrapper.this.mIsInvokeEvents) {
                        EventBus.getDefault().post((Object)InterstitialEvents.READY);
                    }
                    if (IntrstWrapper.this.mAutoShowOnLoad) {
                        IntrstWrapper.this.show();
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                SDKLogger.printErrorLog("Failed to load content for Interstitial !!!");
            }
        });
    }

    private synchronized void openActivity(ContentItem contentItem) {
        if (this.mLaunchLock.tryLock()) {
            try {
                try {
                    if (this.mIsInvokeEvents) {
                        EventBus.getDefault().post((Object)InterstitialEvents.OPENED);
                    }
                    KidozAdActivity.itm = contentItem;
                    Intent intent = new Intent(this.mContext, KidozAdActivity.class);
                    intent.putExtra("styleId", this.mStyleId);
                    intent.addFlags(0x30020000);
                    this.mContext.startActivity(intent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.mLaunchLock.unlock();
            }
        }
    }

    public void onEvent(WidgetEventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE) {
            if (this.mIsInvokeEvents) {
                EventBus.getDefault().post((Object)InterstitialEvents.CLOSED);
            }
            CookieManager.resetStorage(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
        }
    }

    public void onEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    protected void validateIfPrepared() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (this.mIsInitialLoadFinished) {
            this.prepareWebView();
        }
    }

    public static enum InterstitialEvents {
        OPENED,
        CLOSED,
        READY;

    }
}

