/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebSettings;
import android.webkit.WebView;
import org.json.JSONObject;

public class HtmlFiveWebView
extends WebView {
    private final String TAG = HtmlFiveWebView.class.getSimpleName();

    public HtmlFiveWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    public HtmlFiveWebView(Context context) {
        super(context);
        this.initWebView(context);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    private void initWebView(Context context) {
        this.setDrawingCacheBackgroundColor(0);
        this.setBackgroundColor(0);
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        this.setAnimationCacheEnabled(true);
        this.setDrawingCacheEnabled(true);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
            this.getRootView().setBackground(null);
        } else {
            this.getRootView().setBackgroundDrawable(null);
        }
        if (Build.VERSION.SDK_INT < 19) {
            this.getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        this.getSettings().setBuiltInZoomControls(false);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        this.getSettings().setAppCachePath(context.getCacheDir().toString());
        this.getSettings().setAppCacheEnabled(false);
        this.getSettings().setDatabaseEnabled(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        this.getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 5.1; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");
        this.getSettings().setGeolocationEnabled(true);
        this.getSettings().setSupportMultipleWindows(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setBlockNetworkImage(false);
        SharedPreferences mPreferences = context.getSharedPreferences("settings", 0);
        if (Build.VERSION.SDK_INT < 19) {
            switch (mPreferences.getInt("enableflash", 0)) {
                case 0: {
                    this.getSettings().setPluginState(WebSettings.PluginState.OFF);
                    break;
                }
                case 1: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
                    break;
                }
                case 2: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON);
                    break;
                }
            }
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setSavePassword(false);
        }
        if (mPreferences.getBoolean("textreflow", false)) {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        this.applyProperties(new JSONObject());
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(true);
            this.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        this.getSettings().setSaveFormData(false);
        this.getSettings().setLoadWithOverviewMode(false);
        this.getSettings().setUseWideViewPort(false);
        this.getSettings().setCacheMode(-1);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    public synchronized void stopAndReleaseWebView() {
        this.loadUrl("");
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    public void applyProperties(JSONObject properties) {
        if (properties != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                this.getSettings().setMediaPlaybackRequiresUserGesture(properties.optBoolean("setMediaPlaybackRequiersGesture", false));
            }
            this.getSettings().setDomStorageEnabled(properties.optBoolean("setDomStorageEnabled", true));
            this.getSettings().setAllowFileAccess(properties.optBoolean("setAllowFileAccess", true));
            this.getSettings().setSupportZoom(properties.optBoolean("setZoomSupport", false));
            if (Build.VERSION.SDK_INT >= 16) {
                this.getSettings().setAllowFileAccessFromFileURLs(properties.optBoolean("setAllowFileAccessFromFileUrls", true));
                this.getSettings().setAllowUniversalAccessFromFileURLs(properties.optBoolean("setAllowUniversalAccessFromFileURLs", true));
            }
            this.getSettings().setSaveFormData(properties.optBoolean("setSaveFormData", false));
            this.getSettings().setLoadWithOverviewMode(properties.optBoolean("setLoadWithOverviewMode", false));
            this.getSettings().setUseWideViewPort(properties.optBoolean("setUseWideViewPort", false));
            this.getSettings().setCacheMode(properties.optInt("setCacheMode", -1));
            if (properties.optBoolean("setHardwareAcceleration", true)) {
                this.setLayerType(2, null);
            } else {
                this.setLayerType(1, null);
            }
        }
        if (properties.has("setBackgroundColor")) {
            try {
                this.setBackgroundColor(Color.parseColor((String)properties.optString("setBackgroundColor", "#00000000")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

