/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.feed_view;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;
import org.json.JSONObject;

public class FeedFamilyViewDialog
extends BaseDialog {
    public static final String TAG = FeedFamilyViewDialog.class.getSimpleName();
    private RelativeLayout mRootView;
    private RelativeLayout mViewContainer;
    private OneItemFamilyView mOneItemFamilyView;
    private AssetView mNextButton;
    private AssetView mPreviousButton;
    private AssetView mAnimation;
    private AssetView mParentalLockButton;
    private AssetView mAboutButton;
    private AssetView mExitButton;
    private TextView mKidozLabelTextView;
    private LoadingProgressView mLoadingProgressView;
    protected JSONObject mProperties;
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mAllowClickHandling = true;
    private boolean mIsAutomaticInvocation = false;
    private String mStyleId = null;
    public static final String STYLE_ID = "style_id";
    public static final String FEED_BUTTON = "feedButton";
    public static final String FEED_BUTTON_SCALE = "feedButtonScale";
    public static final String ABOUT_KIDOZ = "aboutKidoz";
    public static final String ABOUT_KIDOZ_ANIMATION = "aboutKidozAnimation";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String BACKGROUND_IMAGE = "bgImage";
    public static final String NEXT_BUTTON = "nextBtn";
    public static final String NEXT_BUTTON_ANIMATION = "nextBtnAnimation";
    public static final String PREVIOUS_BUTTON = "previousBtn";
    public static final String PREVIOUS_BUTTON_ANIMATION = "previousBtnAnimation";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String X_BUTTON = "xBtn";
    public static final String X_BUTTON_ANIMATION = "XBtnAnimation";
    public static final String HTML_MAXIMIZE_BTN = "htmlMaximizeBtn";
    public static final String BACKGROUND_ROOT_COLOR = "bgRootColor";

    public FeedFamilyViewDialog(Context context, IOnFeedViewEventListener listener, boolean automatic, JSONObject properties) {
        super(context, 0x1030011);
        this.mProperties = properties;
        this.mStyleId = this.mProperties.optString(STYLE_ID);
        this.mIsAutomaticInvocation = automatic;
        this.mOnInterstitialViewEventListener = listener;
        this.initDialog();
    }

    private void initDialog() {
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
        this.initRootView();
        this.initFamilyOneItemView();
        this.initLoadingProgressView();
        this.initNextAndPreviousButtons();
        this.initAnimation();
        this.initParentalLockButton();
        this.initAboutKidozButton();
        this.initExitButton();
        this.initKidozText();
        this.applayViewContainerParams();
        this.applyViewPagerLayoutParams();
        this.applyNextButtonLayoutParams();
        this.applyPreviousButtonLayoutParams();
        this.applyAnimationLayoutParams();
        this.applyLoadingViewLayoutParams();
        this.mOneItemFamilyView.showLoadingProgressView(true);
    }

    private void initLoadingProgressView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setVisibility(8);
        LinearLayout layout = new LinearLayout(this.getContext());
        layout.setGravity(17);
        layout.addView((View)this.mLoadingProgressView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(5, this.mOneItemFamilyView.getId());
        params.addRule(6, this.mOneItemFamilyView.getId());
        params.addRule(7, this.mOneItemFamilyView.getId());
        params.addRule(8, this.mOneItemFamilyView.getId());
        this.mViewContainer.addView((View)layout, (ViewGroup.LayoutParams)params);
    }

    private void applayViewContainerParams() {
        int width = ScreenUtils.getScreenSize(this.getContext(), true);
        int height = ScreenUtils.getScreenSize(this.getContext(), false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
        params.addRule(13);
        params.height = !ScreenUtils.getIsTablet(this.getContext()) ? (this.getContext().getResources().getConfiguration().orientation == 1 ? (params.width = width - ScreenUtils.getStatusBarHeight(this.getContext())) : (params.width = height - ScreenUtils.getStatusBarHeight(this.getContext()))) : (this.getContext().getResources().getConfiguration().orientation == 1 ? (params.width = width - ScreenUtils.getStatusBarHeight(this.getContext()) - ScreenUtils.getNavigationBarHeight(this.getContext())) : (params.width = height - ScreenUtils.getStatusBarHeight(this.getContext()) - ScreenUtils.getNavigationBarHeight(this.getContext())));
        this.mViewContainer.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void applyLoadingViewLayoutParams() {
        int containerWidth = this.mViewContainer.getLayoutParams().width;
        this.mLoadingProgressView.setCircleWidth((float)containerWidth * 0.008f);
        int loadingViewSize = (int)((float)containerWidth * 0.15f);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(loadingViewSize, loadingViewSize);
        this.mLoadingProgressView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void initKidozText() {
        this.mKidozLabelTextView = new TextView(this.getContext());
        this.mKidozLabelTextView.setGravity(17);
        float tabletSize = Utils.spTOpx(this.getContext(), 10.0f);
        float phoneSize = Utils.spTOpx(this.getContext(), 4.0f);
        float textSize = ScreenUtils.getIsTablet(this.getContext()) ? tabletSize : phoneSize;
        this.mKidozLabelTextView.setTextSize(textSize);
        int margin = Utils.dpTOpx(this.getContext(), 5.0f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.leftMargin = margin;
        params.rightMargin = margin;
        params.bottomMargin = margin;
        params.addRule(1, this.mAboutButton.getId());
        params.addRule(0, this.mParentalLockButton.getId());
        params.addRule(12);
        this.mRootView.addView((View)this.mKidozLabelTextView, (ViewGroup.LayoutParams)params);
        try {
            this.mKidozLabelTextView.setText((CharSequence)this.mProperties.optString(LABEL_TEXT));
            this.mKidozLabelTextView.setTextColor(Color.parseColor((String)this.mProperties.optString(LABEL_COLOR).trim()));
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load label: " + ex.getMessage());
        }
    }

    private void initNextAndPreviousButtons() {
        this.mNextButton = new AssetView(this.getContext());
        this.mNextButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mNextButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(NEXT_BUTTON_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_LEFT)) {
                this.mNextButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeedFamilyViewDialog.this.mNextButton.setClickable(false);
                        GenAnimator.playPressLeftAnimation((View)FeedFamilyViewDialog.this.mNextButton, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                FeedFamilyViewDialog.this.mNextButton.setClickable(true);
                                FeedFamilyViewDialog.this.mOneItemFamilyView.nextPagerItem();
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
                this.mNextButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FeedFamilyViewDialog.this.mNextButton.setClickable(false);
                        GenAnimator.clickItemAnimation((View)FeedFamilyViewDialog.this.mNextButton, 150, new GenAnimator.ViewAnimationListener(){

                            @Override
                            public void onAnimationEnd() {
                                FeedFamilyViewDialog.this.mNextButton.setClickable(true);
                                FeedFamilyViewDialog.this.mOneItemFamilyView.nextPagerItem();
                            }

                            @Override
                            public void onAnimationStart() {
                            }
                        });
                    }
                });
            }
        }
        this.mViewContainer.addView((View)this.mNextButton);
        this.mNextButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(NEXT_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                FeedFamilyViewDialog.this.openDialog();
            }
        });
        this.mPreviousButton = new AssetView(this.getContext());
        this.mPreviousButton.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mPreviousButton.setId(Utils.generateViewId());
        clickAnimation = this.mProperties.optString(PREVIOUS_BUTTON_ANIMATION);
        if (clickAnimation != null) {
            if (clickAnimation.equals(GenAnimator.PRESS_RIGHT)) {
                this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FeedFamilyViewDialog.this.mPreviousButton.setClickable(false);
                        GenAnimator.playPressRightAnimation((View)FeedFamilyViewDialog.this.mPreviousButton, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                FeedFamilyViewDialog.this.mPreviousButton.setClickable(true);
                                FeedFamilyViewDialog.this.mOneItemFamilyView.previousItem();
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                });
            } else if (clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
                this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FeedFamilyViewDialog.this.mPreviousButton.setClickable(false);
                        GenAnimator.clickItemAnimation((View)FeedFamilyViewDialog.this.mPreviousButton, 150, new GenAnimator.ViewAnimationListener(){

                            @Override
                            public void onAnimationEnd() {
                                FeedFamilyViewDialog.this.mPreviousButton.setClickable(true);
                                FeedFamilyViewDialog.this.mOneItemFamilyView.previousItem();
                            }

                            @Override
                            public void onAnimationStart() {
                            }
                        });
                    }
                });
            }
        }
        this.mViewContainer.addView((View)this.mPreviousButton);
        this.mPreviousButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(PREVIOUS_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                FeedFamilyViewDialog.this.openDialog();
            }
        });
    }

    private void initAnimation() {
        this.mAnimation = new AssetView(this.getContext());
        this.mAnimation.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mAnimation.setId(Utils.generateViewId());
        this.mViewContainer.addView((View)this.mAnimation);
        this.mAnimation.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                FeedFamilyViewDialog.this.openDialog();
            }
        });
    }

    private void initExitButton() {
        this.mExitButton = new AssetView(this.getContext());
        this.mExitButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mExitButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(X_BUTTON_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mExitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedFamilyViewDialog.this.mExitButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)FeedFamilyViewDialog.this.mExitButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            FeedFamilyViewDialog.this.mExitButton.setClickable(true);
                            if (FeedFamilyViewDialog.this.mCloseBtnClickListener != null) {
                                FeedFamilyViewDialog.this.mCloseBtnClickListener.onClick(null);
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int width = ScreenUtils.getScreenSize(this.getContext(), true) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int height = ScreenUtils.getScreenSize(this.getContext(), false) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int relevantSize = Math.max(width, height);
        File imageFile = AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(X_BUTTON));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int)((float)relevantSize * 0.08f), (int)((float)relevantSize * 0.08f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(9);
            params.addRule(10);
            this.mRootView.addView((View)this.mExitButton, (ViewGroup.LayoutParams)params);
            this.mExitButton.loadAsset(imageFile, new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successfull) {
                    FeedFamilyViewDialog.this.openDialog();
                }
            });
        }
    }

    private void initRootView() {
        this.mRootView = new RelativeLayout(this.getContext());
        this.mRootView.setBackgroundColor(Color.parseColor((String)this.mProperties.optString(BACKGROUND_ROOT_COLOR, "#CC261304")));
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(-1, -1);
        this.setContentView((View)this.mRootView, (ViewGroup.LayoutParams)params);
        this.mViewContainer = new RelativeLayout(this.getContext());
        this.mRootView.addView((View)this.mViewContainer);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mParentalLockButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(LOCK_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedFamilyViewDialog.this.mParentalLockButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)FeedFamilyViewDialog.this.mParentalLockButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            FeedFamilyViewDialog.this.mParentalLockButton.setClickable(true);
                            if (ParentalLockDialog.getIsCanShowDialog(FeedFamilyViewDialog.this.getContext())) {
                                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(FeedFamilyViewDialog.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(FeedFamilyViewDialog.this.getContext(), false) * 0.5f)};
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(FeedFamilyViewDialog.this.getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                    public void onDismiss(DialogInterface dialog) {
                                        FeedFamilyViewDialog.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect) {
                                        FeedFamilyViewDialog.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.show();
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int width = ScreenUtils.getScreenSize(this.getContext(), true) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int height = ScreenUtils.getScreenSize(this.getContext(), false) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int relevantSize = Math.max(width, height);
        File imageFile = AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_ACTIVE));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int)((float)relevantSize * 0.08f), (int)((float)relevantSize * 0.08f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(11);
            params.addRule(12);
            this.mRootView.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
            this.updateLockIcon();
        }
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        FeedFamilyViewDialog.this.openDialog();
                    }
                });
            } else {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        FeedFamilyViewDialog.this.openDialog();
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initAboutKidozButton() {
        this.mAboutButton = new AssetView(this.getContext());
        this.mAboutButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mAboutButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(ABOUT_KIDOZ_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mAboutButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedFamilyViewDialog.this.mAboutButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)FeedFamilyViewDialog.this.mAboutButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            FeedFamilyViewDialog.this.mAboutButton.setClickable(true);
                            int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(FeedFamilyViewDialog.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(FeedFamilyViewDialog.this.getContext(), false) * 0.5f)};
                            AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(FeedFamilyViewDialog.this.getContext(), popLocation);
                            aboutKidozDialog.openDialog();
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int width = ScreenUtils.getScreenSize(this.getContext(), true) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int height = ScreenUtils.getScreenSize(this.getContext(), false) - (ScreenUtils.getStatusBarHeight(this.getContext()) + ScreenUtils.getNavigationBarHeight(this.getContext()));
        int relevantSize = Math.max(width, height);
        File imageFile = AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(ABOUT_KIDOZ));
        if (imageFile.exists()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
            int[] imageDimensions = ScreenUtils.getScaledDimension(options.outWidth, options.outHeight, (int)((float)relevantSize * 0.06f), (int)((float)relevantSize * 0.06f));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(imageDimensions[0], imageDimensions[1]);
            params.addRule(9);
            params.addRule(12);
            params.leftMargin = margin;
            params.bottomMargin = margin;
            this.mRootView.addView((View)this.mAboutButton, (ViewGroup.LayoutParams)params);
            this.mAboutButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(ABOUT_KIDOZ)), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successfull) {
                    FeedFamilyViewDialog.this.openDialog();
                }
            });
        }
    }

    private void initFamilyOneItemView() {
        this.mOneItemFamilyView = new OneItemFamilyView(this.getContext(), WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mStyleId, this.mProperties, new OneItemFamilyView.IOnOneItemActionListener(){

            @Override
            public void onAction(OneItemFamilyView.OneItemAction action) {
                switch (action) {
                    case STOP_ANY_ANIMATION: {
                        FeedFamilyViewDialog.this.mAnimation.stopGifAnim();
                        break;
                    }
                    case RESTART_ANY_ANIMATION: {
                        FeedFamilyViewDialog.this.mAnimation.startGifAnim();
                    }
                }
            }
        });
        this.mOneItemFamilyView.setOnRefreshDrawRequestListener(new OneItemFamilyView.IOnRefreshListener(){

            @Override
            public void onRefreshDrawRequest() {
                FeedFamilyViewDialog.this.mViewContainer.requestFocus();
                FeedFamilyViewDialog.this.mViewContainer.bringToFront();
            }
        });
        this.mOneItemFamilyView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.setMargins(0, Utils.dpTOpx(this.getContext(), 2.0f), 0, Utils.dpTOpx(this.getContext(), -2.0f));
        this.mViewContainer.addView((View)this.mOneItemFamilyView, (ViewGroup.LayoutParams)params);
        this.mOneItemFamilyView.setViewPagerItemClickListener(new ItemViewPagerAdapter.ViewPagerItemClickListener(){

            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                if (FeedFamilyViewDialog.this.mAllowClickHandling) {
                    FeedFamilyViewDialog.this.mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(FeedFamilyViewDialog.this.getContext(), contentItem, WidgetType.WIDGET_TYPE_FEED.getStringValue(), FeedFamilyViewDialog.this.mStyleId, position, true, new ContentExecutionHandler.IOnHandleClickListener(){

                        @Override
                        public void onRestoreClick() {
                            FeedFamilyViewDialog.this.mAllowClickHandling = true;
                        }
                    });
                }
            }
        });
    }

    private void applyViewPagerLayoutParams() {
        int horizontalMargin = Utils.dpTOpx(this.getContext(), 20.0f);
        int bottomlMargin = Utils.dpTOpx(this.getContext(), 24.0f);
        int containerWidth = this.mViewContainer.getLayoutParams().width;
        int viewWidth = containerWidth - horizontalMargin * 2;
        int viewHeight = (int)((float)viewWidth * 3.0f / 4.0f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(14);
        params.addRule(12);
        params.bottomMargin = bottomlMargin;
        this.mOneItemFamilyView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void applyAnimationLayoutParams() {
        int containerWidth;
        int viewWidth = containerWidth = this.mViewContainer.getLayoutParams().width;
        int viewHeight = !ScreenUtils.getIsTablet(this.getContext()) ? (int)((float)containerWidth * 0.366f) : (int)((float)containerWidth * 0.357f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(10);
        this.mAnimation.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void applyNextButtonLayoutParams() {
        int containerWidth = this.mViewContainer.getLayoutParams().width;
        int viewWidth = (int)((float)containerWidth * 0.17f);
        int viewHeight = (int)((float)containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(11);
        params.topMargin = (int)((float)containerWidth * 0.43f);
        this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void applyPreviousButtonLayoutParams() {
        int containerWidth = this.mViewContainer.getLayoutParams().width;
        int viewWidth = (int)((float)containerWidth * 0.17f);
        int viewHeight = (int)((float)containerWidth * 0.25f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(viewWidth, viewHeight);
        params.addRule(9);
        params.topMargin = (int)((float)containerWidth * 0.43f);
        this.mPreviousButton.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (FeedFamilyViewDialog.this.mOnInterstitialViewEventListener != null) {
                    FeedFamilyViewDialog.this.mOnInterstitialViewEventListener.onDismissView();
                }
                if (FeedFamilyViewDialog.this.mOneItemFamilyView != null) {
                    FeedFamilyViewDialog.this.mOneItemFamilyView.invokeWidgetClose();
                }
            }
        });
    }

    public void setContentData(ContentData contentData) {
        this.mOneItemFamilyView.setContent(contentData.getContentDataItems());
        this.mOneItemFamilyView.showLoadingProgressView(false);
    }

    public void setOnCloseButtonClickListener(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        return bundle;
    }

    @Override
    public void closeDialog() {
        this.mIsWaitingToOpen = false;
        super.closeDialog();
    }

    @Override
    public synchronized void openDialog() {
        this.mIsWaitingToOpen = true;
        if (KidozSDK.isInitialised() && !this.isShowing() && this.mIsWaitingToOpen && this.getIsCanOpen()) {
            super.openDialog();
            this.animateOpen();
            Event event = new Event();
            if (this.mIsAutomaticInvocation) {
                event.addParameterToJsonObject("Open Type", "0");
            } else {
                event.addParameterToJsonObject("Open Type", "1");
            }
            EventManager.getInstance((Context)this.mCallingActivity).logEvent((Context)this.mCallingActivity, WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Widget View", "Feed View");
            if (this.mOneItemFamilyView != null) {
                this.mOneItemFamilyView.invokeWidgetOpen();
            }
        }
    }

    private void animateOpen() {
        GenAnimator.playGrowAnimation((View)this.mViewContainer, 500L, 0L, (Interpolator)new DecelerateInterpolator(1.5f), new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener) {
        if (onInterstitialViewEventListener != null) {
            this.mOnInterstitialViewEventListener = onInterstitialViewEventListener;
        }
    }

    public void onDetachedFromWindow() {
        this.getMyHandlerInstance().removeCallbacksAndMessages(null);
        super.onDetachedFromWindow();
        this.restoreUserOriginalOrientation();
        if (this.mOneItemFamilyView != null) {
            this.mOneItemFamilyView.stopAnyPlaybackAction(true);
        }
        this.mIsWaitingToOpen = false;
    }

    public boolean isWaitingToOpen() {
        return this.mIsWaitingToOpen;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean isVisible) {
        super.onDialogWindowVisibilityChange(isVisible);
        if (!isVisible) {
            EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
        }
        this.mAllowClickHandling = true;
        if (this.mOneItemFamilyView != null) {
            this.mOneItemFamilyView.stopAnyPlaybackAction(true);
        }
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible) {
        super.onDialogFocusChange(isVisible);
        this.mAllowClickHandling = isVisible;
    }

    @Override
    protected void onDialogOrientationChange(boolean isPortrait) {
        super.onDialogOrientationChange(isPortrait);
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (this.mParentalLockButton != null && this.mAboutButton != null && this.mExitButton != null && this.mAnimation != null && this.mNextButton != null && this.mPreviousButton != null) {
            result = this.mParentalLockButton.getIsAssetLoaded() && this.mAboutButton.getIsAssetLoaded() && this.mExitButton.getIsAssetLoaded() && this.mAnimation.getIsAssetLoaded() && this.mNextButton.getIsAssetLoaded() && this.mPreviousButton.getIsAssetLoaded();
        }
        return result;
    }

    private void showLoadingProgressView(boolean show) {
        if (show) {
            this.mLoadingProgressView.setVisibility(0);
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mLoadingProgressView.stopLoadingAnimation();
            this.mLoadingProgressView.setVisibility(8);
        }
    }

    public static boolean parseFamilyFeed(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(FeedView.TAG, (Object)FeedFamilyViewDialog.class.getSimpleName());
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(FeedView.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, FEED_BUTTON);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, ABOUT_KIDOZ);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BACKGROUND_IMAGE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PREVIOUS_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PROMOTION_ANIMATION);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, X_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, HTML_MAXIMIZE_BTN);
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(FeedView.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(FeedView.TAG, "Error when trying to parse family feed properties: " + ex.getMessage());
            }
        }
        return result;
    }

    public void resumeAction(boolean resume) {
        if (this.mOneItemFamilyView != null && resume) {
            this.mOneItemFamilyView.resumePlaybackAction();
        }
    }

    public void pauseAction(boolean withFocusOff) {
        if (this.mOneItemFamilyView != null) {
            this.mOneItemFamilyView.stopAnyPlaybackAction(withFocusOff);
        }
        if (this.mAnimation != null) {
            this.mAnimation.stopGifAnim();
        }
    }
}

