/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemVerticalRecycleViewAdapter;
import com.kidoz.sdk.api.ui_views.RecycleEndlessScrollListener;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import java.util.ArrayList;

public class ContentPanelView
extends AbstractContentPanel {
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.25f;
    private RecyclerView mCustomRecyclerView;
    private RecycleEndlessScrollListener endlesScollPaginghandler;
    private ItemVerticalRecycleViewAdapter mAdapter;
    private StaggeredGridLayoutManager mStaggaredLayoutManager;
    private GridLayoutManager mCustomGridLayoutManager;
    private LoadingProgressView mLoadingProgressView;
    private LayoutViewType mLayoutViewType = LayoutViewType.STAGGERED;
    private ArrayList<ContentItem> mItemsList = new ArrayList();
    private int[] fPos = new int[3];
    private int[] lPos = new int[3];
    private int mCurrentVisiblePosition = 0;

    public ContentPanelView(Context context, LayoutViewType layoutViewType) {
        super(context);
        this.mLayoutViewType = layoutViewType;
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPanelView(context);
    }

    public void initPanelView(Context context) {
        this.initRecyclerView(context);
        this.initAdapter();
        this.initLayoutManager();
        this.initProgressBar();
    }

    private void initProgressBar() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setVisibility(8);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.25f);
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
        prParams.addRule(13);
        this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
    }

    private void initRecyclerView(Context context) {
        this.mCustomRecyclerView = new RecyclerView(context);
        this.mCustomRecyclerView.setClipToPadding(false);
        this.addView((View)this.mCustomRecyclerView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    public RecyclerView getInnerRecyclerView() {
        return this.mCustomRecyclerView;
    }

    private void initLayoutManager() {
        this.setLayoutManagerView(this.mLayoutViewType);
    }

    private void initAdapter() {
        this.mAdapter = new ItemVerticalRecycleViewAdapter(this.getContext(), this.mItemsList, this.getCurrentSpanCount());
        this.endlesScollPaginghandler = new RecycleEndlessScrollListener(4){

            @Override
            public void onLoadMore(int page, int totalItemsCount) {
                if (totalItemsCount > 0) {
                    // empty if block
                }
            }
        };
        this.mCustomRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                ContentPanelView.this.mAdapter.setIsRegularAnimation(true);
                try {
                    if (ContentPanelView.this.mLayoutViewType == LayoutViewType.GRID || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_HORIZONTAL || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_VERTICAL) {
                        ((ContentPanelView)ContentPanelView.this).fPos[0] = ContentPanelView.this.mCustomGridLayoutManager.findFirstVisibleItemPosition();
                        ((ContentPanelView)ContentPanelView.this).lPos[0] = ContentPanelView.this.mCustomGridLayoutManager.findLastVisibleItemPosition();
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    } else if (ContentPanelView.this.mLayoutViewType == LayoutViewType.STAGGERED) {
                        ContentPanelView.this.mStaggaredLayoutManager.findFirstVisibleItemPositions(ContentPanelView.this.fPos);
                        ContentPanelView.this.mStaggaredLayoutManager.findLastVisibleItemPositions(ContentPanelView.this.lPos);
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ContentPanelView.this.mCurrentVisiblePosition = ContentPanelView.this.fPos[0];
            }

            public void onScrollStateChanged(RecyclerView customRecyclerView, int newState) {
                super.onScrollStateChanged(customRecyclerView, newState);
            }
        });
        this.mCustomRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (this.mCurrentVisiblePosition != 0) {
            this.mCustomRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
        }
    }

    private int getCurrentSpanCount() {
        return this.getNumberOfColumns(this.getContext());
    }

    public void setLayoutManagerView(LayoutViewType viewType) {
        this.mLayoutViewType = viewType;
        switch (viewType) {
            case STAGGERED: {
                this.mStaggaredLayoutManager = new StaggeredGridLayoutManager(this.getCurrentSpanCount(), 1);
                this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mStaggaredLayoutManager);
                break;
            }
            case GRID: {
                this.mCustomGridLayoutManager = new GridLayoutManager(this.getContext(), this.getCurrentSpanCount());
                this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mCustomGridLayoutManager);
                break;
            }
            case LINEAR_HORIZONTAL: {
                LinearLayoutManager mLinearLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
                this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)mLinearLayoutManager);
                break;
            }
            case LINEAR_VERTICAL: {
                LinearLayoutManager mLinearLayoutManager = new LinearLayoutManager(this.getContext(), 1, false);
                this.mCustomRecyclerView.setLayoutManager((RecyclerView.LayoutManager)mLinearLayoutManager);
            }
        }
    }

    private int getNumberOfColumns(Context context) {
        int result = 2;
        result = context.getResources().getConfiguration().orientation == 2 ? (Utils.getIsDeviceTablet(context) ? 3 : 3) : (Utils.getIsDeviceTablet(context) ? 2 : 2);
        return result;
    }

    public void setRoundingCorenrsValue(int rounding) {
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        if (this.mAdapter != null) {
            this.mAdapter.setOnItemClickListener(listener);
        }
    }

    public void clearDataFromView() {
        this.mItemsList.clear();
        this.mAdapter.clearContentDataWithNotify();
    }

    public void addDataAndRefreshView(ContentData contentData) {
        if (contentData != null && contentData.getContentDataItems() != null) {
            this.mAdapter.setWidgetTypeAndStyleID(contentData.getSourceWidgetType(), contentData.getStyleID());
            this.mItemsList.clear();
            this.mItemsList.addAll(contentData.getContentDataItems());
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int spanCount = this.getCurrentSpanCount();
        this.mAdapter.setSpanCount(spanCount, newConfig.orientation);
        this.setLayoutManagerView(this.mLayoutViewType);
        this.mCustomRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
    }

    public void showLoadingProgressView(boolean show) {
        if (show) {
            this.mLoadingProgressView.setVisibility(0);
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mLoadingProgressView.stopLoadingAnimation();
            this.mLoadingProgressView.setVisibility(8);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public static enum LayoutViewType {
        STAGGERED,
        GRID,
        LINEAR_VERTICAL,
        LINEAR_HORIZONTAL;

    }
}

