/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.VideoJavaScriptInterface;
import com.kidoz.sdk.api.players.video_player.VideoManager;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import de.greenrobot.event.EventBus;
import java.io.Serializable;

public class FullScreenViewDialog
extends BaseDialog {
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY_FS";
    private static final String ORIENTATION_MODIFY_SAVE_STATE_KEY = "ORIENTATION_MODIFY_SAVE_STATE_KEY_FS";
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY_FS";
    private static final String TOP_BAR_HIDDEN_SAVE_STATE_KEY = "TOP_BAR_HIDDEN_SAVE_STATE_KEY_FS";
    private final String TAG = FullScreenViewDialog.class.getSimpleName();
    private final int BLACK_CURTAIN_HIDE_DELAY = 50;
    private final int TOP_BAR_ANIMATION_DURATION = 500;
    private final int TOP_BAR_ANIMATION_DELAY = 3000;
    private FrameLayout mContentView;
    private FrameLayout mCustomViewContainer;
    private KidozTopBar mKidozTopBar;
    private LoadingProgressView mLoadingProgressView;
    private View mBlackCurtain;
    private VideoEnabledWebView mVideoEnabledWebView;
    private VideoJavaScriptInterface mVideoJavaScriptInterface;
    private RelativeLayout mVideoLayer;
    private View mTransparentView;
    private ContentItem mContentItem;
    private Utils.StaticHandler mStaticHandler;
    private boolean mIsTopBarHidden;
    private boolean mIsAnimationRunning;
    private boolean mAllowOrientationModify = false;
    private String mWidgetType;
    private String mStyleId;

    public FullScreenViewDialog(Context context, String widgetType, String StyleId, boolean allowModifyOrientation) {
        super(context, 16973834, allowModifyOrientation);
        this.mAllowOrientationModify = allowModifyOrientation;
        this.mWidgetType = widgetType;
        this.mStyleId = StyleId;
        this.setCancelable(true);
        this.getWindow().setFlags(0x1000000, 0x1000000);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mAllowOrientationModify) {
            if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
                this.mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
            } else if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
                this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
                this.mCallingActivity.setRequestedOrientation(4);
            }
        }
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)((Object)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY));
            }
            this.mIsTopBarHidden = savedInstanceState.getBoolean(TOP_BAR_HIDDEN_SAVE_STATE_KEY);
        }
        this.initDialog();
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (FullScreenViewDialog.this.mContentView != null) {
                    FullScreenViewDialog.this.mContentView.removeAllViews();
                }
                FullScreenViewDialog.this.mStaticHandler.removeCallbacksAndMessages(null);
            }
        });
        this.setContentView((View)this.mCustomViewContainer);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAllowOrientationModify) {
            this.restoreUserOriginalOrientation();
        }
        EventManager.getInstance(this.getContext()).logEventWithDurationEnd(this.getContext(), this.mWidgetType, this.mStyleId, 1, false);
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, (Serializable)Integer.valueOf(this.mCurrentOrientationState));
            bundle.putBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY, this.mAllowOrientationModify);
            bundle.putBoolean(TOP_BAR_HIDDEN_SAVE_STATE_KEY, this.mIsTopBarHidden);
        }
        return bundle;
    }

    private void initDialog() {
        this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        this.initRootView();
        this.initVideoWebView();
        this.initBlackCurtain();
        this.initTopBar();
        this.initLoadingView();
    }

    private void initBlackCurtain() {
        this.mBlackCurtain = new View(this.getContext());
        this.mBlackCurtain.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mCustomViewContainer.addView(this.mBlackCurtain, (ViewGroup.LayoutParams)params);
    }

    private void initLoadingView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setCircleColor(Color.parseColor((String)"#ffffff"));
        this.mLoadingProgressView.stopLoadingAnimation();
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((double)Math.min(point.x, point.y) * 0.25);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(size, size);
        params.gravity = 17;
        this.mCustomViewContainer.addView((View)this.mLoadingProgressView, (ViewGroup.LayoutParams)params);
    }

    private void initRootView() {
        this.mCustomViewContainer = new FrameLayout(this.getContext());
        this.mCustomViewContainer.setId(Utils.generateViewId());
        this.mCustomViewContainer.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -1));
        this.mContentView = new FrameLayout(this.getContext());
        this.mContentView.setId(Utils.generateViewId());
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mCustomViewContainer.addView((View)this.mContentView);
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                FullScreenViewDialog.this.closeDialog();
            }
        });
        this.mKidozTopBar.setTitle("Video Player");
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mCustomViewContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)params);
    }

    private void initVideoWebView() {
        this.mVideoLayer = new RelativeLayout(this.getContext());
        this.mVideoLayer.setId(Utils.generateViewId());
        this.mVideoLayer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mCustomViewContainer.addView((View)this.mVideoLayer);
        this.mVideoEnabledWebView = VideoManager.getInstance(this.getContext()).getIFrameVideo();
        if (this.getContext().getResources().getConfiguration().orientation == 2) {
            this.mVideoEnabledWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        } else {
            this.mVideoEnabledWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.mVideoJavaScriptInterface = VideoManager.getInstance(this.getContext()).getVideoJavaScriptInterface();
        this.mVideoJavaScriptInterface.setJavascriptListener(new VideoJavaScriptInterface.JavascriptListener(){

            @Override
            public void onVideoReady() {
            }

            @Override
            public void onError(final int errorCode) {
                FullScreenViewDialog.this.mStaticHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FullScreenViewDialog.this.mLoadingProgressView.stopLoadingAnimation();
                        SDKLogger.printDebbugLog(FullScreenViewDialog.this.TAG, ">>>>Error loading video, errorCode = " + String.valueOf(errorCode));
                    }
                });
            }

            @Override
            public void onStateChange(int state) {
                SDKLogger.printDebbugLog(FullScreenViewDialog.this.TAG, ">>>State = " + state);
                switch (state) {
                    case 1: {
                        FullScreenViewDialog.this.mStaticHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                FullScreenViewDialog.this.mLoadingProgressView.stopLoadingAnimation();
                                FullScreenViewDialog.this.mBlackCurtain.setVisibility(8);
                            }
                        }, 50L);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        FullScreenViewDialog.this.mStaticHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                FullScreenViewDialog.this.mBlackCurtain.setVisibility(0);
                            }
                        });
                    }
                }
            }

            @Override
            public void onViewReady() {
                if (VideoManager.getInstance(FullScreenViewDialog.this.getContext()).isLoaded()) {
                    FullScreenViewDialog.this.mStaticHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            FullScreenViewDialog.this.loadVideo();
                        }
                    }, 1200L);
                }
            }
        });
        this.mVideoEnabledWebView.setOnConfigurationChangeListener(new VideoEnabledWebView.ConfigurationChangeListener(){

            @Override
            public void onConfigChange() {
            }
        });
        if (this.mContentView.getChildCount() > 0) {
            this.mContentView.removeAllViews();
        }
        this.mContentView.addView((View)this.mVideoEnabledWebView);
        this.mTransparentView = new View(this.getContext());
        this.mTransparentView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mTransparentView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    FullScreenViewDialog.this.animateTopBarEnter();
                }
                return false;
            }
        });
        this.mCustomViewContainer.addView(this.mTransparentView);
    }

    protected void onStop() {
        super.onStop();
        if (this.mVideoEnabledWebView != null) {
            this.mVideoEnabledWebView.pauseVideo();
        }
    }

    public void openDialog(ContentItem contentItem) {
        super.openDialog();
        this.mContentItem = contentItem;
        this.loadVideo();
        this.mKidozTopBar.setTitle(contentItem.getName());
        EventManager.getInstance(this.getContext()).logEventWithDuration(this.getContext(), this.mWidgetType, this.mStyleId, EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Video Player", "Video Player View", contentItem.getName(), contentItem.getId(), false);
        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)eventMessage);
    }

    private void loadVideo() {
        this.mLoadingProgressView.startLoadingAnimation();
        if (this.mVideoEnabledWebView != null) {
            String videoType = "0";
            if (this.mContentItem.getContentType() == ContentType.YOUTUBE_VIDEO) {
                videoType = "0";
            } else if (this.mContentItem.getContentType() == ContentType.STREAMING_VIDEO) {
                videoType = "5";
            }
            SDKLogger.printDebbugLog(this.TAG, ">>>>loadVideo: Domain = " + this.mContentItem.getContentType().name() + "\nURL = " + this.mContentItem.getData() + "\nType = " + videoType);
            String videoURL = this.mContentItem.getData();
            if (!VideoManager.getInstance(this.getContext()).isLoaded()) {
                VideoManager.getInstance(this.getContext()).reloadHtml();
            } else {
                this.mVideoEnabledWebView.loadVideo(videoType, videoURL);
            }
        }
        this.mStaticHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FullScreenViewDialog.this.animateTopBarExit();
            }
        }, 3000L);
    }

    private void animateTopBarEnter() {
        if (!this.mIsAnimationRunning && this.mIsTopBarHidden && this.getContext().getResources().getConfiguration().orientation == 2) {
            this.mIsAnimationRunning = true;
            this.mStaticHandler.removeCallbacks(null);
            GenAnimator.showTopBar((View)this.mKidozTopBar, this.mKidozTopBar.getHeight(), 500, (TimeInterpolator)new DecelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FullScreenViewDialog.this.mIsAnimationRunning = false;
                    FullScreenViewDialog.this.mIsTopBarHidden = false;
                    FullScreenViewDialog.this.mStaticHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            FullScreenViewDialog.this.animateTopBarExit();
                        }
                    }, 3000L);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    private void animateTopBarExit() {
        if (!this.mIsAnimationRunning && !this.mIsTopBarHidden && this.getContext().getResources().getConfiguration().orientation == 2) {
            this.mIsAnimationRunning = true;
            this.mStaticHandler.removeCallbacks(null);
            GenAnimator.hideTopBar((View)this.mKidozTopBar, -this.mKidozTopBar.getHeight(), 500, (TimeInterpolator)new AccelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FullScreenViewDialog.this.mIsAnimationRunning = false;
                    FullScreenViewDialog.this.mIsTopBarHidden = true;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    private void resetTopBarAnimation() {
        if (this.mIsTopBarHidden) {
            this.mStaticHandler.removeCallbacks(null);
            GenAnimator.showTopBar((View)this.mKidozTopBar, this.mKidozTopBar.getHeight(), 0, (TimeInterpolator)new DecelerateInterpolator(), new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FullScreenViewDialog.this.mIsTopBarHidden = false;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    @Override
    protected void onDialogOrientationChange(boolean isPortrait) {
        if (isPortrait) {
            this.mVideoEnabledWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.resetTopBarAnimation();
        } else {
            this.mVideoEnabledWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            this.mStaticHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FullScreenViewDialog.this.animateTopBarExit();
                }
            }, 3000L);
        }
        this.mVideoEnabledWebView.invalidate();
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible) {
        if (isVisible) {
            this.mVideoEnabledWebView.resumeVideo();
        } else {
            this.mVideoEnabledWebView.pauseVideo();
        }
    }

    public void dismiss() {
        super.dismiss();
        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)eventMessage);
    }
}

