/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BaseBanner;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner1;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner2;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBanner3;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;
import de.greenrobot.event.EventBus;
import org.json.JSONObject;

public class KidozBanner
extends RelativeLayout {
    public static final String TAG = KidozBanner.class.getSimpleName();
    private KidozBannerListener mKidozBannerListener;
    private BaseBanner mBaseBanner;
    protected boolean mIsWaitingToOpen = false;
    private boolean mIsViewShown = false;
    private boolean mIsSmartBanner;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private KidozPlayerListener mKidozPlayerListener;

    public KidozBanner(Context context) {
        super(context);
        this.initView();
    }

    public KidozBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public KidozBanner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    public void setIsSmartBanner(boolean isSmartBanner) {
        this.mIsSmartBanner = isSmartBanner;
        if (this.mBaseBanner != null) {
            this.mBaseBanner.setIsSmartBanner(this.mIsSmartBanner);
        }
    }

    private void initView() {
        this.subscribeToSDK();
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen(boolean isMaximizedPlayer) {
                if (KidozBanner.this.mKidozPlayerListener != null) {
                    KidozBanner.this.mKidozPlayerListener.onPlayerOpen();
                }
            }

            @Override
            public void onClose(boolean isMaximizedPlayer) {
                if (KidozBanner.this.mKidozPlayerListener != null) {
                    KidozBanner.this.mKidozPlayerListener.onPlayerClose();
                }
            }
        }, WidgetType.WIDGET_TYPE_BANNER);
        this.mKidozPlayerEventHelper.register();
        if (KidozSDK.isInitialised()) {
            this.validateAssets();
        }
    }

    private void subscribeToSDK() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    private void validateAssets() {
        SdkAPIManager.getSdkApiInstance(this.getContext()).getStyle(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getValue(), new ApiResultCallback<Boolean>(){

            @Override
            public void onServerResult(ResultData<?> result) {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                    if (result.getData() != null) {
                        boolean isAssetsReady = (Boolean)result.getData();
                        if (isAssetsReady) {
                            KidozBanner.this.buildBanner();
                        } else {
                            this.onFailed();
                        }
                    }
                } else {
                    this.onFailed();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    private void buildBanner() {
        String bannerType;
        JSONObject jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(TAG);
        if (jsonObject != null && (bannerType = jsonObject.optString(TAG)) != null) {
            if (bannerType.equals(KidozBanner1.class.getSimpleName())) {
                this.mBaseBanner = new KidozBanner1(this.getContext());
                this.mBaseBanner.setProperties(jsonObject);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                this.removeAllViews();
                this.addView((View)this.mBaseBanner, (ViewGroup.LayoutParams)params);
            } else if (bannerType.equals(KidozBanner2.class.getSimpleName())) {
                this.mBaseBanner = new KidozBanner2(this.getContext());
                this.mBaseBanner.setProperties(jsonObject);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                this.removeAllViews();
                this.addView((View)this.mBaseBanner, (ViewGroup.LayoutParams)params);
            } else if (bannerType.equals(KidozBanner3.class.getSimpleName())) {
                this.mBaseBanner = new KidozBanner3(this.getContext());
                this.mBaseBanner.setProperties(jsonObject);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                this.removeAllViews();
                this.addView((View)this.mBaseBanner, (ViewGroup.LayoutParams)params);
            }
            if (this.mKidozBannerListener != null) {
                this.mBaseBanner.setKidozBannerListener(this.mKidozBannerListener);
                this.mKidozBannerListener.onBannerReady();
                this.mBaseBanner.requestFocus();
                this.mBaseBanner.bringToFront();
            }
            if (this.mBaseBanner != null) {
                this.mBaseBanner.setIsSmartBanner(this.mIsSmartBanner);
            }
            if (this.mIsWaitingToOpen) {
                this.showBanner();
            }
        }
    }

    public synchronized void showBanner() {
        if (!this.mIsViewShown) {
            this.mIsWaitingToOpen = true;
            if (this.mBaseBanner != null) {
                this.mIsViewShown = true;
                this.mBaseBanner.setKidozBannerListener(this.mKidozBannerListener);
                this.mBaseBanner.loadContent();
                this.mBaseBanner.showBanner();
            }
        }
    }

    public void hideBanner() {
        this.mIsWaitingToOpen = false;
        if (this.mBaseBanner != null) {
            this.mBaseBanner.setKidozBannerListener(this.mKidozBannerListener);
            this.mBaseBanner.hideBanner();
            this.mIsViewShown = false;
        }
    }

    public void setKidozBannerListener(KidozBannerListener kidozBannerListener) {
        this.mKidozBannerListener = kidozBannerListener;
        if (this.mBaseBanner != null) {
            this.mBaseBanner.setKidozBannerListener(this.mKidozBannerListener);
            if (this.mKidozBannerListener != null) {
                this.mKidozBannerListener.onBannerReady();
            }
        }
    }

    protected void onDetachedFromWindow() {
        try {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.unRegister();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void onEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateAssets();
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
    }
}

