/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.content.Context;
import android.os.AsyncTask;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;

public class EventSyncAsyncTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = EventSyncAsyncTask.class.getSimpleName();
    private static final int MAX_ITERATION_TIMES_IN_SINGLE_SYNC = 3;
    private Context mContext;

    public EventSyncAsyncTask(Context context) {
        this.mContext = context;
    }

    protected Void doInBackground(Void ... params) {
        block7: {
            SDKLogger.printWarningLog(" ----------------------  ********************* ----------------------");
            SDKLogger.printWarningLog(" -----------------    START EVENTS SYNCING THREAD ---------------------");
            SDKLogger.printWarningLog(" ----------------------  ******************** ----------------------");
            try {
                if (this.mContext == null) break block7;
                for (int iterCount = 3; EventManager.getInstance(this.mContext).getIsNeedEventsSync(this.mContext) && iterCount > 0; --iterCount) {
                    EventBulk bulk = EventManager.getInstance(this.mContext).getNextBulk(this.mContext);
                    if (bulk != null) {
                        String json = bulk.toString();
                        SDKLogger.printInfoLog("Log Events Sync info : bulk value:" + json);
                        if (json != null) {
                            ResultData<Boolean> resultCallback = SdkAPIManager.getSdkApiInstance(this.mContext).sendKidozEventsToServerNotAsync(json);
                            if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful()) {
                                EventManager.getInstance(this.mContext).removeBulkFromDB(this.mContext, bulk);
                                continue;
                            }
                            SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
                            continue;
                        }
                        SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldn't create JSON representation of an Events BULK !");
                    } else {
                        SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

