package com.kidoz.sdk.api.general;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by Eugine on 7/15/15.
 */

public class BaseDialog extends Dialog
{
    private final String TAG = BaseDialog.class.getSimpleName();
    protected Activity mCallingActivity;
    private long mDisplayDuration;

    // This parameter flag that a dialog is wanting to be open. if all assets are loaded and this flag is true the dialog can be opened.
    protected boolean mIsWaitingToOpen;
    protected int mCurrentOrientationState = -1;
    private boolean mIsAllowedToChangeOrientation;

    private Utils.StaticHandler mStaticHandler;

    public BaseDialog(Context context)
    {
        super(context);
        if (context != null)
        {
            if (context instanceof Activity)
            {
                mCallingActivity = (Activity) context;
            }
            else if (context instanceof ContextWrapper)
            {
                mCallingActivity = (Activity) (((ContextWrapper) context).getBaseContext());
            }
        }
    }

    public BaseDialog(Context context, int theme)
    {
        super(context, theme);
        try
        {
            if (context != null)
            {
                if (context instanceof Activity)
                {
                    mCallingActivity = (Activity) context;
                }
                else if (context instanceof ContextWrapper)
                {
                    mCallingActivity = (Activity) (((ContextWrapper) context).getBaseContext());
                }
            }
        }
        catch (Exception ex)
        {

        }

    }

    public BaseDialog(Context context, int theme, boolean isAllowedToChangeOrientation)
    {
        super(context, theme);
        try
        {
            if (context != null)
            {
                if (context instanceof Activity)
                {
                    mCallingActivity = (Activity) context;
                }
                else if (context instanceof ContextWrapper)
                {
                    mCallingActivity = (Activity) (((ContextWrapper) context).getBaseContext());
                }
            }
        }
        catch (Exception ex)
        {

        }
        mIsAllowedToChangeOrientation = isAllowedToChangeOrientation;

    }

    public void openDialog()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            if(isShowing() == false) {
                getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
                getWindow().getDecorView().setSystemUiVisibility(mCallingActivity.getWindow().getDecorView().getSystemUiVisibility());

                mDisplayDuration = System.currentTimeMillis();
                super.show();
                getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
                WindowManager wm = (WindowManager) mCallingActivity.getSystemService(Context.WINDOW_SERVICE);
                wm.updateViewLayout(getWindow().getDecorView(), getWindow().getAttributes());

                if (mIsAllowedToChangeOrientation == true)
                {
                    saveUserOriginalOrientation();
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                }

            }
        }
    }

    public void closeDialog()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            if (mIsAllowedToChangeOrientation == true)
            {
                restoreUserOriginalOrientation();
            }
            dismiss();
        }
    }

    @Override
    public void show()
    {
        try
        {
            throw new DialogException();
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open dialog: " + ex.getMessage());
        }
    }

    private class DialogException extends Exception
    {
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage()
        {
            return "Don't use the show() method\nUse openDialog() instead!";
        }
    }

    /**
     * Return the time the dialog was visible in seconds
     *
     * @return
     */
    public int getTotalDisplayDuration()
    {
        int totalTimeInSeconds = (int) ((System.currentTimeMillis() - mDisplayDuration) / 1000);
        return totalTimeInSeconds;
    }

    @Override
    public void setContentView(View view)
    {
        super.setContentView(view);
        initConfigurationHelperView(view);
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params)
    {
        super.setContentView(view, params);
        initConfigurationHelperView(view);
    }

    private void initConfigurationHelperView(View view)
    {
        if (view instanceof ViewGroup)
        {
            ViewGroup viewGroup = (ViewGroup) view;
            ConfigurationHelperView configurationHelperView = new ConfigurationHelperView(getContext());
            viewGroup.addView(configurationHelperView);
        }
    }

    protected void onDialogOrientationChange(boolean isPortrait)
    {
    }

    protected void onDialogFocusChange(boolean isVisible)
    {
    }

    protected void onDialogVisibilityChange(int isVisible)
    {
    }

    protected void onDialogWindowVisibilityChange(boolean visible)
    {
    }

    public class ConfigurationHelperView extends View
    {
        public ConfigurationHelperView(Context context)
        {
            super(context);
        }

        @Override
        protected void onConfigurationChanged(Configuration newConfig)
        {
            super.onConfigurationChanged(newConfig);
            if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE)
            {
                onDialogOrientationChange(false);
            }
            else
            {
                onDialogOrientationChange(true);
            }
        }

        @Override
        public void onWindowFocusChanged(boolean hasWindowFocus)
        {
            super.onWindowFocusChanged(hasWindowFocus);
            onDialogFocusChange(hasWindowFocus);
        }

        @Override
        protected void onVisibilityChanged(View changedView, int visibility)
        {
            super.onVisibilityChanged(changedView, visibility);
            onDialogVisibilityChange(visibility);
        }

        @Override
        protected void onWindowVisibilityChanged(int visibility)
        {
            super.onWindowVisibilityChanged(visibility);

            if (visibility == View.VISIBLE)
            {
                onDialogWindowVisibilityChange(true);
            }
            else if (visibility == View.GONE || visibility == View.INVISIBLE)
            {
                onDialogWindowVisibilityChange(false);
            }
        }
    }


    /**
     * Restore user original orientation
     */
    public void restoreUserOriginalOrientation()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            switch (mCurrentOrientationState)
            {
                case Configuration.ORIENTATION_LANDSCAPE:
                {
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                    break;
                }

                case Configuration.ORIENTATION_PORTRAIT:
                {
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                    break;
                }
                case Configuration.ORIENTATION_UNDEFINED:
                {
                    mCallingActivity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                    break;
                }
            }
        }
    }

    public void saveUserOriginalOrientation()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            mCurrentOrientationState = mCallingActivity.getResources().getConfiguration().orientation;
        }
    }

    public boolean getIsCanOpen()
    {
        return false;
    }


    protected Utils.StaticHandler getMyHandlerInstance() {
        if (mStaticHandler == null) {
            mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message message) {
                    // This is where you do your work in the UI thread.
                    // Your worker tells you in the message what to do.
                }
            };
        }
        return mStaticHandler;
    }
}
