/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;

public abstract class InputSource {
    private boolean mIsOpaque;

    InputSource() {
    }

    abstract GifInfoHandle open() throws IOException;

    final GifDrawable build(GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor, boolean isRenderingAlwaysEnabled) throws IOException {
        return new GifDrawable(this.open(), oldDrawable, executor, isRenderingAlwaysEnabled);
    }

    final boolean isOpaque() {
        return this.mIsOpaque;
    }

    final InputSource setOpaque(boolean isOpaque) {
        this.mIsOpaque = isOpaque;
        return this;
    }

    public static class AssetFileDescriptorSource
    extends InputSource {
        private final AssetFileDescriptor mAssetFileDescriptor;

        public AssetFileDescriptorSource(@NonNull AssetFileDescriptor assetFileDescriptor) {
            this.mAssetFileDescriptor = assetFileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openAssetFileDescriptor(this.mAssetFileDescriptor, false);
        }
    }

    public static class ResourcesSource
    extends InputSource {
        private final Resources mResources;
        private final int mResourceId;

        public ResourcesSource(@NonNull Resources resources, @DrawableRes @RawRes int resourceId) {
            this.mResources = resources;
            this.mResourceId = resourceId;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openAssetFileDescriptor(this.mResources.openRawResourceFd(this.mResourceId), false);
        }
    }

    public static final class InputStreamSource
    extends InputSource {
        private final InputStream inputStream;

        public InputStreamSource(@NonNull InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openMarkableInputStream(this.inputStream, false);
        }
    }

    public static final class FileDescriptorSource
    extends InputSource {
        private final FileDescriptor mFd;

        public FileDescriptorSource(@NonNull FileDescriptor fileDescriptor) {
            this.mFd = fileDescriptor;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openFd(this.mFd, 0L, false);
        }
    }

    public static final class AssetSource
    extends InputSource {
        private final AssetManager mAssetManager;
        private final String mAssetName;

        public AssetSource(@NonNull AssetManager assetManager, @NonNull String assetName) {
            this.mAssetManager = assetManager;
            this.mAssetName = assetName;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openAssetFileDescriptor(this.mAssetManager.openFd(this.mAssetName), false);
        }
    }

    public static final class UriSource
    extends InputSource {
        private final ContentResolver mContentResolver;
        private final Uri mUri;

        public UriSource(@Nullable ContentResolver contentResolver, @NonNull Uri uri) {
            this.mContentResolver = contentResolver;
            this.mUri = uri;
        }

        @Override
        GifInfoHandle open() throws IOException {
            return GifInfoHandle.openUri(this.mContentResolver, this.mUri, false);
        }
    }

    public static final class FileSource
    extends InputSource {
        private final String mPath;

        public FileSource(@NonNull File file) {
            this.mPath = file.getPath();
        }

        public FileSource(@NonNull String filePath) {
            this.mPath = filePath;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return GifInfoHandle.openFile(this.mPath, false);
        }
    }

    public static final class ByteArraySource
    extends InputSource {
        private final byte[] bytes;

        public ByteArraySource(@NonNull byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return GifInfoHandle.openByteArray(this.bytes, false);
        }
    }

    public static final class DirectByteBufferSource
    extends InputSource {
        private final ByteBuffer byteBuffer;

        public DirectByteBufferSource(@NonNull ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        GifInfoHandle open() throws GifIOException {
            return GifInfoHandle.openDirectByteBuffer(this.byteBuffer, false);
        }
    }
}

