/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.parental_lock;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.squareup.imagelib.Callback;
import com.squareup.imagelib.Transformation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import pl.droidsonroids.gif.GifDrawable;

public class AssetView
extends FrameLayout {
    private boolean mIsAssetLoaded;
    private ArrayList<Transformation> mTransformations = new ArrayList();
    private GifDrawable mAnimatedGifDrawable = null;
    private ImageView mImageView;
    private MyWebView mWebPwebView;

    public AssetView(Context context) {
        super(context);
        this.initView();
    }

    public AssetView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AssetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setDrawingCacheBackgroundColor(0);
        this.setId(Utils.generateViewId());
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setLayerType(1, null);
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void loadAsset(File file, IOnAssetLoadedListener loadedListener) {
        this.loadAsset(file, null, loadedListener);
    }

    public void loadAsset(String path, IOnAssetLoadedListener loadedListener) {
        this.loadAsset(new File(path), null, loadedListener);
    }

    public void loadAsset(String path, Drawable defaultImage, IOnAssetLoadedListener loadedListener) {
        this.loadAsset(new File(path), defaultImage, loadedListener);
    }

    public void loadAsset(File file, Drawable defaultImage, final IOnAssetLoadedListener loadedListener) {
        block25: {
            this.mIsAssetLoaded = false;
            if (defaultImage != null) {
                this.setAssetBackgroundDrawable(defaultImage);
            }
            if (file != null) {
                if (file.exists()) {
                    String path = file.getPath();
                    if (path.contains(".png") || path.contains(".PNG") || path.contains(".jpg") || path.contains(".JPG")) {
                        PicassoOk.getPicasso(this.getContext()).load(file).transform(this.mTransformations).into(this.mImageView, new Callback(){

                            @Override
                            public void onSuccess() {
                                AssetView.this.setAssetBackgroundDrawable(null);
                                AssetView.this.mIsAssetLoaded = true;
                                if (loadedListener != null) {
                                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                                }
                            }

                            @Override
                            public void onError() {
                                AssetView.this.mIsAssetLoaded = false;
                                if (loadedListener != null) {
                                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                                }
                            }
                        });
                    } else {
                        if (path.contains(".gif") || path.contains(".GIF")) {
                            try {
                                if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled()) {
                                    this.mAnimatedGifDrawable.stop();
                                    this.mAnimatedGifDrawable.recycle();
                                    this.mAnimatedGifDrawable = null;
                                }
                                this.mAnimatedGifDrawable = new GifDrawable(file.getAbsolutePath());
                                if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled()) {
                                    this.mImageView.setImageDrawable((Drawable)this.mAnimatedGifDrawable);
                                    this.setAssetBackgroundDrawable(null);
                                    this.mAnimatedGifDrawable.start();
                                }
                                this.mIsAssetLoaded = true;
                                if (loadedListener != null) {
                                    loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                                }
                                break block25;
                            }
                            catch (IOException e) {
                                if (e != null) {
                                    SDKLogger.printErrorLog(e.getMessage() + "   path: " + path);
                                }
                                this.mIsAssetLoaded = false;
                                if (defaultImage != null) {
                                    this.setAssetBackgroundDrawable(defaultImage);
                                }
                                if (loadedListener != null) {
                                    loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                                }
                                break block25;
                            }
                        }
                        if (path.contains(".webp") || path.contains(".WEBP") || path.contains(".webP")) {
                            if (Build.VERSION.SDK_INT >= 17) {
                                if (Utils.isWebViewSupportWebP()) {
                                    this.mWebPwebView = this.generateWebPAnimatableWebView();
                                    this.addView((View)this.mWebPwebView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                                    this.loadImageToWebPwebView("file://" + path);
                                    this.mIsAssetLoaded = true;
                                }
                                if (!this.mIsAssetLoaded) {
                                    this.setAssetBackgroundDrawable(defaultImage);
                                }
                                if (loadedListener != null) {
                                    loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                                }
                            }
                        } else {
                            this.mIsAssetLoaded = false;
                            this.setAssetBackgroundDrawable(defaultImage);
                            if (loadedListener != null) {
                                loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                            }
                        }
                    }
                } else {
                    this.mIsAssetLoaded = false;
                    this.setAssetBackgroundDrawable(defaultImage);
                    if (loadedListener != null) {
                        loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                    }
                }
            } else {
                this.mIsAssetLoaded = false;
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                }
            }
        }
    }

    public void setAssetBackgroundDrawable(Drawable defaultImage) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mImageView.setBackground(defaultImage);
        } else {
            this.mImageView.setBackgroundDrawable(defaultImage);
        }
    }

    public boolean getIsAssetLoaded() {
        return this.mIsAssetLoaded;
    }

    private MyWebView generateWebPAnimatableWebView() {
        MyWebView kidozWebView = new MyWebView(this.getContext());
        kidozWebView.setBackgroundColor(0);
        kidozWebView.setClipToPadding(false);
        kidozWebView.setDrawingCacheBackgroundColor(0);
        kidozWebView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        kidozWebView.setScrollBarStyle(0);
        kidozWebView.setScrollbarFadingEnabled(true);
        kidozWebView.getSettings().setAppCacheEnabled(false);
        kidozWebView.getSettings().setCacheMode(2);
        kidozWebView.getSettings().setDisplayZoomControls(false);
        kidozWebView.getSettings().setAllowContentAccess(true);
        kidozWebView.getSettings().setAllowFileAccess(true);
        kidozWebView.getSettings().setSupportZoom(false);
        kidozWebView.getSettings().setSupportMultipleWindows(false);
        kidozWebView.setVerticalScrollBarEnabled(false);
        kidozWebView.setHorizontalScrollBarEnabled(false);
        kidozWebView.setScrollContainer(false);
        kidozWebView.setPadding(0, 0, 0, 0);
        kidozWebView.setLayerType(2, null);
        return kidozWebView;
    }

    private void loadImageToWebPwebView(String path) {
        if (this.mWebPwebView != null) {
            String s = "<html><head><style type='text/css'> img {max-width: 100%;height:initial;} margin: 0; padding: 0 </style></head><body style='margin:0;padding:0;' ><img src=\"" + path + "\"/></body>" + "</html>";
            this.mWebPwebView.loadDataWithBaseURL("", s, "text/html", "utf-8", null);
        }
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled() && this.mAnimatedGifDrawable.isVisible() && !this.mAnimatedGifDrawable.isPlaying()) {
            this.mAnimatedGifDrawable.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled()) {
            this.mAnimatedGifDrawable.stop();
            this.mAnimatedGifDrawable.recycle();
            this.mAnimatedGifDrawable = null;
            if (this.mWebPwebView != null) {
                this.mWebPwebView.clearHistory();
                this.mWebPwebView.clearCache(true);
                this.mWebPwebView.loadUrl("about:blank");
                this.mWebPwebView.freeMemory();
                this.mWebPwebView.pauseTimers();
                this.mWebPwebView = null;
            }
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled()) {
            if (visibility == 0) {
                if (!this.mAnimatedGifDrawable.isPlaying()) {
                    this.mAnimatedGifDrawable.start();
                }
            } else {
                this.mAnimatedGifDrawable.stop();
            }
        }
    }

    private void addTrasnformation(Transformation transformation) {
        this.mTransformations.add(transformation);
    }

    private void clearTrasnformations() {
        this.mTransformations.clear();
    }

    public void startGifAnim() {
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isPlaying()) {
            this.mAnimatedGifDrawable.start();
        }
    }

    public void stopGifAnim() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.stop();
        }
    }

    public void pauseGifAnim() {
        if (this.mAnimatedGifDrawable != null && this.mAnimatedGifDrawable.isPlaying()) {
            this.mAnimatedGifDrawable.pause();
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mImageView.setScaleType(scaleType);
    }

    class MyWebView
    extends WebView {
        public MyWebView(Context context) {
            super(context);
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return false;
        }
    }

    public static interface IOnAssetLoadedListener {
        public void onAssetLoaded(boolean var1);
    }
}

