/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.AbstractPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelSliderView;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;
import org.json.JSONObject;

public class StandardPanelView
extends AbstractPanelView {
    public static final String TAG = StandardPanelView.class.getSimpleName();
    private PanelSliderView mPanelSliderView;

    public StandardPanelView(Context context, JSONObject jsonObject) {
        super(context, jsonObject);
    }

    @Override
    protected void initInnerPanelView() {
        this.mPanelSliderView = new PanelSliderView(this.getContext());
        this.mPanelSliderView.setId(Utils.generateViewId());
        this.mPanelSliderView.setBackgroundColor(this.mPanelBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mInnerContainer.addView((View)this.mPanelSliderView, (ViewGroup.LayoutParams)params);
        PanelViewListener mPanelViewListener = new PanelViewListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int position) {
                if (StandardPanelView.this.mAllowClickHandling) {
                    StandardPanelView.this.mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick(StandardPanelView.this.getContext(), contentItem, WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StandardPanelView.this.mStyleId, position, true, false, new ContentExecutionHandler.IOnHandleClickListener(){

                        @Override
                        public void onRestoreClick() {
                            StandardPanelView.this.mAllowClickHandling = true;
                        }
                    });
                }
            }
        };
        this.mPanelSliderView.setPanelViewListener(mPanelViewListener);
    }

    @Override
    protected void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                StandardPanelView.this.mPanelSliderView.showLoadingProgressView(false);
                if (contentData != null) {
                    CookieManager.resetStorage(StandardPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StorageLife.WIDGET);
                    StandardPanelView.this.mPanelSliderView.setContentData(contentData);
                }
            }

            @Override
            public void onLoadContentFailed() {
            }
        });
    }

    protected void createShadowLineBg() {
        int[] colors = new int[]{Color.parseColor((String)"#dd000000"), 0};
        GradientDrawable shadow = null;
        switch (this.mPanelType) {
            case BOTTOM: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, colors);
                break;
            }
            case TOP: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colors);
                break;
            }
            case LEFT: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, colors);
                break;
            }
            case RIGHT: {
                shadow = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, colors);
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.mShadowLine.setBackground((Drawable)shadow);
        } else {
            this.mShadowLine.setBackgroundDrawable((Drawable)shadow);
        }
    }

    @Override
    protected void initShadowView() {
        this.mShadowLine = new LinearLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, Utils.dpTOpx(this.getContext(), 3.0f));
        this.mContainer.addView((View)this.mShadowLine, (ViewGroup.LayoutParams)params);
        this.mShadowLine.setAlpha(0.2f);
        this.mShadowLine.setVisibility(4);
    }

    @Override
    public void setPanelColor(int color) {
        super.setPanelColor(color);
        if (this.mPanelSliderView != null) {
            this.mPanelSliderView.setBackgroundColor(this.mPanelBgColor);
        }
    }

    @Override
    protected void onCollapsePanelAnimationEnded() {
        super.onCollapsePanelAnimationEnded();
        this.mShadowLine.setVisibility(4);
        this.mPanelSliderView.clearContent();
    }

    @Override
    protected void onExpandPanelAnimationStarted() {
        super.onExpandPanelAnimationStarted();
        this.mShadowLine.setVisibility(0);
        this.mPanelSliderView.showLoadingProgressView(true);
        this.mContentLogicLoader.loadContent(this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), this.mStyleId);
    }

    @Override
    protected void initPanelViewsRules() {
        this.createShadowLineBg();
        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(-2, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        RelativeLayout.LayoutParams innerContainerParams = new RelativeLayout.LayoutParams(-1, -2);
        this.mInnerContainer.setLayoutParams((ViewGroup.LayoutParams)innerContainerParams);
        RelativeLayout.LayoutParams sliderParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mPanelSliderView.setLayoutParams((ViewGroup.LayoutParams)sliderParams);
        RelativeLayout.LayoutParams bottomBarParams = new RelativeLayout.LayoutParams(-1, -2);
        this.mBottomBarContainer.setLayoutParams((ViewGroup.LayoutParams)bottomBarParams);
        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mPanelHandle.setLayoutParams((ViewGroup.LayoutParams)handleParams);
        RelativeLayout.LayoutParams shadowParams = new RelativeLayout.LayoutParams(-1, Utils.dpTOpx(this.getContext(), 3.0f));
        this.mShadowLine.setLayoutParams((ViewGroup.LayoutParams)shadowParams);
        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)parentalLockParams);
        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mAboutKidozButton.setLayoutParams((ViewGroup.LayoutParams)aboutKidozParams);
        int margin = Utils.dpTOpx(this.getContext(), 6.0f);
        switch (this.mPanelType) {
            case LEFT: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.LEFT);
                innerContainerParams.addRule(9);
                innerContainerParams.width = -2;
                innerContainerParams.height = -1;
                handleParams.addRule(1, this.mInnerContainer.getId());
                aboutKidozParams.addRule(12);
                parentalLockParams.addRule(12);
                parentalLockParams.addRule(7, this.mPanelSliderView.getId());
                bottomBarParams.width = -2;
                bottomBarParams.height = -2;
                bottomBarParams.addRule(12);
                bottomBarParams.addRule(1, this.mAboutKidozButton.getId());
                bottomBarParams.addRule(0, this.mParentalLockButton.getId());
                sliderParams.addRule(2, this.mBottomBarContainer.getId());
                shadowParams.addRule(1, this.mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(this.getContext(), 3.0f);
                shadowParams.height = -1;
                this.mPoweredByTextView.setVisibility(4);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(10);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(15);
                        break;
                    }
                    case END: {
                        handleParams.addRule(8, this.mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                    }
                }
                containerParams.addRule(9);
                break;
            }
            case TOP: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.TOP);
                innerContainerParams.addRule(10);
                innerContainerParams.width = -1;
                innerContainerParams.height = -2;
                bottomBarParams.addRule(3, this.mPanelSliderView.getId());
                aboutKidozParams.addRule(8, this.mBottomBarContainer.getId());
                parentalLockParams.addRule(8, this.mBottomBarContainer.getId());
                parentalLockParams.addRule(11, this.mBottomBarContainer.getId());
                bottomBarParams.addRule(1, this.mAboutKidozButton.getId());
                bottomBarParams.addRule(0, this.mParentalLockButton.getId());
                handleParams.addRule(3, this.mInnerContainer.getId());
                shadowParams.addRule(3, this.mInnerContainer.getId());
                shadowParams.width = -1;
                shadowParams.height = Utils.dpTOpx(this.getContext(), 3.0f);
                this.mPoweredByTextView.setVisibility(0);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(9);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(14);
                        break;
                    }
                    case END: {
                        handleParams.addRule(7, this.mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                    }
                }
                containerParams.addRule(10);
                break;
            }
            case RIGHT: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.RIGHT);
                innerContainerParams.addRule(11);
                innerContainerParams.width = -2;
                innerContainerParams.height = -1;
                aboutKidozParams.addRule(12);
                parentalLockParams.addRule(12);
                parentalLockParams.addRule(7, this.mPanelSliderView.getId());
                bottomBarParams.width = -2;
                bottomBarParams.height = -2;
                bottomBarParams.addRule(12);
                bottomBarParams.addRule(1, this.mAboutKidozButton.getId());
                bottomBarParams.addRule(0, this.mParentalLockButton.getId());
                sliderParams.addRule(2, this.mBottomBarContainer.getId());
                shadowParams.addRule(0, this.mInnerContainer.getId());
                shadowParams.width = Utils.dpTOpx(this.getContext(), 3.0f);
                shadowParams.height = -1;
                handleParams.addRule(0, this.mInnerContainer.getId());
                this.mPoweredByTextView.setVisibility(4);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(10);
                        handleParams.topMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(15);
                        break;
                    }
                    case END: {
                        handleParams.addRule(8, this.mInnerContainer.getId());
                        handleParams.bottomMargin = margin;
                    }
                }
                containerParams.addRule(11);
                break;
            }
            case BOTTOM: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.BOTTOM);
                innerContainerParams.addRule(3, this.mPanelHandle.getId());
                innerContainerParams.width = -1;
                innerContainerParams.height = -2;
                shadowParams.addRule(2, this.mInnerContainer.getId());
                shadowParams.width = -1;
                shadowParams.height = Utils.dpTOpx(this.getContext(), 3.0f);
                bottomBarParams.addRule(3, this.mPanelSliderView.getId());
                bottomBarParams.addRule(1, this.mAboutKidozButton.getId());
                bottomBarParams.addRule(0, this.mParentalLockButton.getId());
                aboutKidozParams.addRule(8, this.mBottomBarContainer.getId());
                parentalLockParams.addRule(8, this.mBottomBarContainer.getId());
                parentalLockParams.addRule(11);
                this.mPoweredByTextView.setVisibility(0);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(9);
                        handleParams.leftMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(14);
                        break;
                    }
                    case END: {
                        handleParams.addRule(7, this.mInnerContainer.getId());
                        handleParams.rightMargin = margin;
                    }
                }
                containerParams.addRule(12);
            }
        }
    }

    public static boolean parsePanelData(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(PanelView.TAG, (Object)TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(PanelView.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, "btnOpenedUrl");
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, "btnClosedUrl");
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(PanelView.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(PanelView.TAG, "Error when trying to parse kidoz PanelView properties" + ex.getMessage());
            }
        }
        return result;
    }
}

