/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PanelAdapter
extends RecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private PANEL_TYPE mPanelType;
    private PanelViewListener mPanelViewListener;
    private ArrayList<ContentItem> mContent;
    private File mSoundFile;
    private Handler mHandler;
    private boolean mIsCanClick;
    private int mLastPosition;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();
    private String mWidgetType;
    private String mStyleID;
    private int mWidth;
    private int mHeight;

    public PanelAdapter(Context context, PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        this.mSoundFile = SoundAssetsUtils.getSoundAssetFile(context, SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK);
        this.mLastPosition = -1;
        this.mContent = new ArrayList();
        this.mHandler = new Handler();
        this.mIsCanClick = true;
    }

    public void setSizePropertiesAndUpdate(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        this.notifyItemRangeChanged(0, this.mContent.size());
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(ContentData contentData) {
        PanelAdapter panelAdapter = this;
        synchronized (panelAdapter) {
            if (contentData != null && contentData.getContentDataItems() != null) {
                this.mWidgetType = contentData.getSourceWidgetType();
                this.mStyleID = contentData.getStyleID();
            }
            this.mSponsoredContentDisplayed.clear();
            if (this.mContent.isEmpty()) {
                this.mContent.clear();
                this.mContent.addAll(contentData.getContentDataItems());
                this.notifyItemRangeInserted(0, this.getItemCount());
                this.notifyItemRangeChanged(0, this.getItemCount());
            } else {
                this.mContent.clear();
                this.mContent.addAll(contentData.getContentDataItems());
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContent() {
        PanelAdapter panelAdapter = this;
        synchronized (panelAdapter) {
            if (this.mContent != null) {
                this.mLastPosition = -1;
                if (this.mContent.isEmpty()) {
                    this.notifyItemRangeRemoved(0, this.getItemCount());
                    this.notifyItemRangeChanged(0, this.getItemCount());
                    this.mContent.clear();
                } else {
                    this.mContent.clear();
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    public int getItemCount() {
        int result = 0;
        if (this.mContent != null) {
            result = this.mContent.size();
        }
        return result;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        OneContentItemView panelContentItem = new OneContentItemView(parent.getContext(), this.mWidth, this.mHeight);
        KidozCardView mCardContainerView = new KidozCardView(parent.getContext());
        mCardContainerView.setId(Utils.generateViewId());
        int val = Utils.dpTOpx(parent.getContext(), 5.0f);
        mCardContainerView.setRadius(val);
        mCardContainerView.setCardBackgroundColor(Color.parseColor((String)"#ccffffff"));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(panelContentItem.mWidth, -1);
        mCardContainerView.setClipToPadding(false);
        params.setMargins(val, val, val, val);
        mCardContainerView.setContentPadding(val, val, val, val);
        mCardContainerView.addView((View)panelContentItem, (ViewGroup.LayoutParams)params);
        mCardContainerView.setUseCompatPadding(true);
        ViewHolder viewHolder = new ViewHolder(mCardContainerView, panelContentItem);
        viewHolder.mParentContainer.setOnClickListener(this);
        viewHolder.mParentContainer.setTag((Object)viewHolder);
        return viewHolder;
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        ContentItem contentItem = this.mContent.get(position);
        this.sendImpressionLog(holder, contentItem, position);
        holder.mPanelContentItem.applyViewSettingsByContentType(contentItem.getContentType());
        holder.setData(contentItem);
        if (position > this.mLastPosition) {
            holder.mPanelContentItem.setVisibility(4);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GenAnimator.recycleItemAnimation((View)holder.mPanelContentItem, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                        }

                        @Override
                        public void onAnimationStart() {
                            holder.mPanelContentItem.setVisibility(0);
                        }
                    });
                }
            }, 0L);
            this.mLastPosition = position;
        } else {
            holder.mPanelContentItem.clearAnimation();
            holder.mPanelContentItem.setVisibility(0);
        }
    }

    public void onClick(final View view) {
        if (this.mIsCanClick) {
            SdkSoundManager.playSound(view.getContext(), this.mSoundFile.getAbsolutePath());
            this.mIsCanClick = false;
            SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    ViewHolder viewHolder = (ViewHolder)((Object)view.getTag());
                    int position = viewHolder.getAdapterPosition();
                    ContentItem contentItem = (ContentItem)PanelAdapter.this.mContent.get(position);
                    if (position != -1 && PanelAdapter.this.mPanelViewListener != null) {
                        PanelAdapter.this.mPanelViewListener.onItemClick(contentItem, position);
                    }
                    PanelAdapter.this.mIsCanClick = true;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }, 50, 100);
        }
    }

    public void setPanelViewListener(PanelViewListener panelViewListener) {
        this.mPanelViewListener = panelViewListener;
    }

    private void sendImpressionLog(ViewHolder viewHolder, ContentItem contentItem, int position) {
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !contentItem.getIsAvoidAutoImpression() && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId())) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), position);
            EventManager.getInstance(viewHolder.mPanelContentItem.getContext()).logSponsoredContentImpressionEvent(viewHolder.mPanelContentItem.getContext(), this.mWidgetType, this.mStyleID, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
        }
    }

    public void toggleClick(boolean isCanClick) {
        this.mIsCanClick = isCanClick;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private OneContentItemView mPanelContentItem;
        private KidozCardView mParentContainer;

        public ViewHolder(KidozCardView parent, OneContentItemView view) {
            super((View)parent);
            this.mParentContainer = parent;
            this.mPanelContentItem = view;
            parent.setSoundEffectsEnabled(false);
        }

        public void setData(ContentItem contentItem) {
            this.mPanelContentItem.setData(contentItem);
        }
    }
}

