/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import java.io.File;

public class OneContentItemView
extends LinearLayout {
    private RelativeLayout mContainer;
    private TextView mItemName;
    private ImageView mItemThumbnail;
    private ImageView mItemTypeIcon;
    private ImageView mPromotedIndication;
    private LinearLayout mNameContainerLay;
    private RelativeLayout.LayoutParams mPromotedIndicationParams;
    private File mImageFile;
    public int mWidth = 0;
    public int mHeight = 0;
    private ContentItem mContentItem;
    private FrameLayout mWebViewContainerLayout;

    public OneContentItemView(Context context, int w, int h) {
        super(context);
        this.mWidth = w;
        this.mHeight = h;
        this.initView();
    }

    private void initView() {
        this.initContainer();
        this.initItemThumbnail();
        this.initItemName();
        this.initItemTypeIcon();
        this.initPromotedIndication();
        this.mWebViewContainerLayout = new FrameLayout(this.getContext());
        this.mContainer.addView((View)this.mWebViewContainerLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    private void initContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    private void initItemThumbnail() {
        this.mItemThumbnail = new ImageView(this.getContext());
        this.mItemThumbnail.setId(Utils.generateViewId());
        this.mItemThumbnail.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)this.mItemThumbnail, (ViewGroup.LayoutParams)params);
    }

    private void initPromotedIndication() {
        this.mPromotedIndication = new ImageView(this.getContext());
        this.mPromotedIndication.setId(Utils.generateViewId());
        this.mPromotedIndication.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mPromotedIndicationParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mPromotedIndicationParams.width = (int)((float)this.mWidth * 0.2f);
        this.mPromotedIndicationParams.height = this.mPromotedIndicationParams.width / 4;
        this.mPromotedIndicationParams.addRule(5, this.mItemThumbnail.getId());
        this.mPromotedIndicationParams.addRule(6, this.mItemThumbnail.getId());
        this.mContainer.addView((View)this.mPromotedIndication, (ViewGroup.LayoutParams)this.mPromotedIndicationParams);
        this.mImageFile = ImageAssetsUtils.getAssetFile(this.getContext(), ImageAssetsUtils.APP_ASSET_TYPE.PROMOTED_INDICATION);
    }

    private void initItemTypeIcon() {
        RelativeLayout.LayoutParams anchorParams = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout anchor = new RelativeLayout(this.getContext());
        anchorParams.addRule(2, this.mNameContainerLay.getId());
        this.mContainer.addView((View)anchor, (ViewGroup.LayoutParams)anchorParams);
        this.mItemTypeIcon = new ImageView(this.getContext());
        this.mItemTypeIcon.setId(Utils.generateViewId());
        this.mItemTypeIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.width = (int)((float)this.mWidth * 0.4f);
        params.height = (int)((float)this.mHeight * 0.4f);
        params.addRule(13);
        anchor.addView((View)this.mItemTypeIcon, (ViewGroup.LayoutParams)params);
    }

    private void initItemName() {
        this.mItemName = new TextView(this.getContext());
        this.mItemName.setMaxLines(1);
        this.mItemName.setEllipsize(TextUtils.TruncateAt.END);
        this.mItemName.setTextColor(Color.parseColor((String)"#d7dee0"));
        this.mItemName.setGravity(16);
        this.mNameContainerLay = new LinearLayout(this.getContext());
        this.mNameContainerLay.setId(Utils.generateViewId());
        this.mNameContainerLay.setBackgroundColor(Color.parseColor((String)"#cb3b3a37"));
        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(-1, -1);
        this.mNameContainerLay.addView((View)this.mItemName, (ViewGroup.LayoutParams)linParams);
        int textSize = (int)((float)this.mWidth * 0.048f);
        int margin = (int)((float)this.mWidth * 0.025f);
        this.mItemName.setTextSize(0, (float)textSize);
        linParams.setMargins(Utils.dpTOpx(this.getContext(), 5.0f), margin, Utils.dpTOpx(this.getContext(), 5.0f), margin);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        this.mContainer.addView((View)this.mNameContainerLay, (ViewGroup.LayoutParams)params);
    }

    private void loadBackgroundColor() {
        this.setBackgroundColor(-1);
        if (this.mContentItem != null) {
            this.setBackgroundColor(this.mContentItem.getPaliteBgColor());
        }
    }

    private void loadThumbnail() {
        this.mItemThumbnail.setImageBitmap(null);
        if (this.mContentItem != null && this.mContentItem.getThumb() != null && !this.mContentItem.getThumb().equals("")) {
            PicassoOk.getPicasso(this.getContext()).load(this.mContentItem.getThumb()).resize(this.mWidth, this.mHeight).centerCrop().into(this.mItemThumbnail);
        }
    }

    private void loadItemTypeIcon() {
        this.mItemTypeIcon.setImageBitmap(null);
        if (this.mContentItem != null && this.mItemTypeIcon != null && this.mContentItem.getSecThumb() != null && !this.mContentItem.getSecThumb().equals("")) {
            PicassoOk.getPicasso(this.getContext()).load(this.mContentItem.getSecThumb()).into(this.mItemTypeIcon);
        }
    }

    private void loadIteNameAndSetTextColor() {
        if (this.mContentItem != null) {
            this.mItemName.setText((CharSequence)this.mContentItem.getName());
        }
    }

    private void setPromotedIndication() {
        this.mPromotedIndication.setImageBitmap(null);
        if (this.mContentItem != null && this.mContentItem.isPromoted() && this.mImageFile.exists() && this.mImageFile != null) {
            PicassoOk.getPicasso(this.getContext()).load(this.mImageFile).resize(this.mPromotedIndicationParams.width, this.mPromotedIndicationParams.height).centerInside().into(this.mPromotedIndication);
        }
    }

    public void setData(ContentItem contentItem) {
        this.mContentItem = contentItem;
        this.loadBackgroundColor();
        this.loadThumbnail();
        this.loadItemTypeIcon();
        this.loadIteNameAndSetTextColor();
        this.setPromotedIndication();
    }

    public void setActiveWebView(HtmlViewWrapper webview) {
        this.mWebViewContainerLayout.removeAllViews();
        ViewGroup group = (ViewGroup)webview.getParent();
        if (group != null) {
            group.removeAllViews();
        }
        this.mWebViewContainerLayout.addView((View)webview, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void clearActiveWebView() {
        this.mWebViewContainerLayout.removeAllViews();
    }

    public void applyViewSettingsByContentType(ContentType contentType) {
        if (contentType != null && contentType == ContentType.HTML) {
            this.mNameContainerLay.setVisibility(4);
            this.mItemTypeIcon.setVisibility(4);
        } else {
            this.mNameContainerLay.setVisibility(0);
            this.mItemTypeIcon.setVisibility(0);
        }
    }
}

