/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.one_item_view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ConfigurationView;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.html_view.MaximizedViewDialog;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.InfinitePagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import de.greenrobot.event.EventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class OneItemFamilyView
extends RelativeLayout {
    private Lock mLock;
    protected static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.13f;
    protected static final int ITEM_CONTAINER_STROKE_WIDTH = 4;
    protected int AUTO_SCROLL_DELAY = 12000;
    protected AutoScrollViewPager mViewPager;
    protected LoadingProgressView mLoadingProgressView;
    protected AssetView mMaximizeBtn;
    protected HtmlViewWrapper mHtmlDefaultView;
    protected HtmlViewWrapper mHtmlSpecialView;
    protected KidozCardView mViewPagerCardContainerView;
    protected ItemViewPagerAdapter mAdapter;
    ArrayList<ContentItem> mContent = new ArrayList();
    protected HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();
    protected ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    protected String mMaximizeBtnUrl;
    protected int mThumbContainerBgColor;
    protected JSONObject mProperties;
    protected String mWidgetType;
    protected String mStyleId;
    protected ContentItem mCurrentItemInView;
    protected int mCurrentItemInViewPosition;
    protected int mLastHtmlItemInFocus = -1;
    protected MaximizedViewDialog mMaximizedViewDialog;
    protected IOnOneItemActionListener mOneItemActionListener;
    protected int mWidth;
    protected int mHeight;
    private IOnRefreshListener mRefreshListener;
    private ConfigurationView mConfigurationView;

    public OneItemFamilyView(Context context, String widgetType, String styleId, JSONObject properties, IOnOneItemActionListener listener) {
        super(context);
        this.mLock = new ReentrantLock();
        this.mProperties = properties;
        this.mWidgetType = widgetType;
        this.mStyleId = styleId;
        this.mOneItemActionListener = listener;
        this.applyStyleProperties();
        this.initView();
        Utils.setOnGlobalLayoutFinishListener((View)this, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                int size;
                OneItemFamilyView.this.mWidth = OneItemFamilyView.this.getMeasuredWidth();
                OneItemFamilyView.this.mHeight = OneItemFamilyView.this.getMeasuredHeight();
                if (OneItemFamilyView.this.mContent != null && !OneItemFamilyView.this.mContent.isEmpty()) {
                    OneItemFamilyView.this.showContent();
                }
                OneItemFamilyView.this.mMaximizeBtn.getLayoutParams().width = size = (int)((float)OneItemFamilyView.this.mWidth * 0.22f);
                OneItemFamilyView.this.mMaximizeBtn.getLayoutParams().height = size;
            }
        });
    }

    protected void applyStyleProperties() {
        if (this.mProperties != null) {
            this.mMaximizeBtnUrl = this.mProperties.optString("htmlMaximizeBtn", null);
            this.AUTO_SCROLL_DELAY = this.mProperties.optInt("swapContentRefreshRateSec", 12) * 1000;
            this.mThumbContainerBgColor = Color.parseColor((String)this.mProperties.optString("thumbBgColor", "#ccffffff"));
        }
    }

    protected void initView() {
        this.initPagerContainerCard();
        this.initViewPager();
        this.initHtmlDefaultWebView();
        this.initHtmlSpecialWebView();
        this.initLoadingProgressView();
        this.initMaximizeButton();
        this.initConfigurationView();
    }

    private void initConfigurationView() {
        this.mConfigurationView = new ConfigurationView(this.getContext(), new ConfigurationView.ConfigurationViewListener(){

            @Override
            public void onIsViewCompletelyInvisible(boolean isViewCompletelyInvisible) {
                if (isViewCompletelyInvisible) {
                    OneItemFamilyView.this.mHtmlDefaultView.requestPause();
                }
            }
        });
        this.addView(this.mConfigurationView);
    }

    private void initPagerContainerCard() {
        this.mViewPagerCardContainerView = new KidozCardView(this.getContext());
        this.mViewPagerCardContainerView.setId(Utils.generateViewId());
        this.mViewPagerCardContainerView.setRadius(Utils.dpTOpx(this.getContext(), 4.0f));
        this.mViewPagerCardContainerView.setCardBackgroundColor(this.mThumbContainerBgColor);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mViewPagerCardContainerView, (ViewGroup.LayoutParams)params);
    }

    private void initHtmlDefaultWebView() {
        this.mHtmlDefaultView = HtmlManager.getDefaultHtmlView(this.getContext());
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.setWidgetType(this.mWidgetType);
            this.mHtmlDefaultView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onOpenMaximized() {
                    OneItemFamilyView.this.openMaximizedVew(OneItemFamilyView.this.mCurrentItemInView);
                }

                @Override
                public void onDonePlayBack() {
                    OneItemFamilyView.this.startAutoScroll();
                }
            });
        }
    }

    private void initHtmlSpecialWebView() {
        this.mHtmlSpecialView = new HtmlViewWrapper(this.getContext());
        this.mHtmlSpecialView.setWidgetType(this.mWidgetType);
        this.mHtmlSpecialView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

            @Override
            public void onHtmlStartLoading() {
                OneItemFamilyView.this.mHtmlSpecialView.showLoadingProgressView();
                OneItemFamilyView.this.mMaximizeBtn.setVisibility(4);
            }

            @Override
            public void onHtmlFinishedLoading() {
                OneItemFamilyView.this.mHtmlSpecialView.hideLoadingProgressView();
                if (OneItemFamilyView.this.mCurrentItemInView != null) {
                    if (OneItemFamilyView.this.mCurrentItemInView.getShouldDisplayMaximizeButton()) {
                        OneItemFamilyView.this.mMaximizeBtn.setVisibility(0);
                    } else {
                        OneItemFamilyView.this.mMaximizeBtn.setVisibility(4);
                    }
                }
            }

            @Override
            public void onOpenMaximized() {
                OneItemFamilyView.this.openMaximizedVew(OneItemFamilyView.this.mCurrentItemInView);
            }

            @Override
            public void onDonePlayBack() {
                OneItemFamilyView.this.startAutoScroll();
            }
        });
        this.mHtmlSpecialView.setVisibility(8);
    }

    private void initMaximizeButton() {
        this.mMaximizeBtn = new AssetView(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(7, this.mViewPagerCardContainerView.getId());
        params.addRule(8, this.mViewPagerCardContainerView.getId());
        params.setMargins(0, 0, Utils.dpTOpx(this.getContext(), 5.0f), Utils.dpTOpx(this.getContext(), 5.0f));
        this.addView((View)this.mMaximizeBtn, (ViewGroup.LayoutParams)params);
        this.mMaximizeBtn.setVisibility(4);
        this.mMaximizeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 70, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        OneItemFamilyView.this.openMaximizedVew(OneItemFamilyView.this.mCurrentItemInView);
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        this.mMaximizeBtn.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mMaximizeBtnUrl), null);
    }

    private void refreshKidozWebView(int currentItemPosition) {
        OneContentItemView panelContentItem;
        this.sendImpressionLog(currentItemPosition);
        this.startAutoScroll();
        this.mCurrentItemInView = this.mAdapter.getContentItem(currentItemPosition);
        this.mCurrentItemInViewPosition = currentItemPosition;
        if (this.mLastHtmlItemInFocus != -1) {
            this.mHtmlDefaultView.requestFocusOff();
            if (this.mHtmlSpecialView != null) {
                this.mHtmlSpecialView.clearHtmlView();
            }
            if ((panelContentItem = (OneContentItemView)this.mViewPager.findViewWithTag(currentItemPosition)) != null) {
                panelContentItem.clearActiveWebView();
            }
            this.mLastHtmlItemInFocus = -1;
        }
        if (this.mCurrentItemInView != null && this.mCurrentItemInView.getContentType() == ContentType.HTML) {
            this.stopAutoScroll();
            panelContentItem = (OneContentItemView)this.mViewPager.findViewWithTag(currentItemPosition);
            if (this.mCurrentItemInView.getIsNonDefaultHtml()) {
                if (panelContentItem != null) {
                    panelContentItem.setActiveWebView(this.mHtmlSpecialView);
                }
                this.mHtmlDefaultView.setVisibility(4);
                this.mHtmlSpecialView.setVisibility(0);
                this.mHtmlSpecialView.clearHtmlView();
                this.mHtmlSpecialView.setData(this.mCurrentItemInView);
                this.mHtmlSpecialView.loadHtml();
                if (this.mOneItemActionListener != null) {
                    this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
                }
            } else {
                if (this.mHtmlDefaultView != null) {
                    if (panelContentItem != null) {
                        panelContentItem.setActiveWebView(this.mHtmlDefaultView);
                    }
                    this.mHtmlDefaultView.setData(this.mCurrentItemInView);
                    this.mHtmlDefaultView.setVisibility(0);
                    this.mHtmlDefaultView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            OneItemFamilyView.this.mHtmlDefaultView.requestFocusOn(false);
                        }
                    }, 300L);
                }
                this.mHtmlSpecialView.setVisibility(4);
                if (this.mOneItemActionListener != null) {
                    this.mOneItemActionListener.onAction(OneItemAction.STOP_ANY_ANIMATION);
                }
            }
            if (this.mRefreshListener != null) {
                this.mRefreshListener.onRefreshDrawRequest();
            }
            if (this.mCurrentItemInView.getShouldDisplayMaximizeButton()) {
                this.mMaximizeBtn.setVisibility(0);
            } else {
                this.mMaximizeBtn.setVisibility(4);
            }
            this.mLastHtmlItemInFocus = currentItemPosition;
        } else {
            if (this.mHtmlDefaultView != null) {
                this.mHtmlDefaultView.requestFocusOff();
                this.mHtmlDefaultView.setVisibility(4);
            }
            this.mHtmlSpecialView.clearHtmlView();
            this.mHtmlSpecialView.setVisibility(4);
            this.mMaximizeBtn.setVisibility(4);
            if (this.mOneItemActionListener != null) {
                this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
            }
        }
    }

    protected void openMaximizedVew(ContentItem contentItem) {
        this.stopAutoScroll();
        if (contentItem.getIsNonDefaultHtml()) {
            this.mMaximizedViewDialog = new MaximizedViewDialog(this.getContext(), this.mWidgetType, this.mHtmlSpecialView);
        } else {
            this.mMaximizedViewDialog = new MaximizedViewDialog(this.getContext(), this.mWidgetType, this.mHtmlDefaultView);
            this.mHtmlDefaultView.requestMaximize();
        }
        this.mMaximizedViewDialog.openDialog();
        this.mMaximizedViewDialog.loadHtmlView(contentItem);
        if (this.mOneItemActionListener != null) {
            this.mOneItemActionListener.onAction(OneItemAction.STOP_ANY_ANIMATION);
        }
    }

    private void initLoadingProgressView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        this.mLoadingProgressView.setVisibility(8);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.13f);
        LinearLayout layout = new LinearLayout(this.getContext());
        layout.setGravity(17);
        layout.addView((View)this.mLoadingProgressView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(size, size));
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(-1, -1);
        prParams.addRule(5, this.mViewPagerCardContainerView.getId());
        prParams.addRule(7, this.mViewPagerCardContainerView.getId());
        this.addView((View)layout, (ViewGroup.LayoutParams)prParams);
    }

    private void initViewPager() {
        this.mViewPager = new AutoScrollViewPager(this.getContext());
        this.mViewPager.setInterval(this.AUTO_SCROLL_DELAY);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (OneItemFamilyView.this.mRefreshListener != null && (double)positionOffset >= 0.4 && (double)positionOffset <= 0.6) {
                    OneItemFamilyView.this.mRefreshListener.onRefreshDrawRequest();
                }
            }

            public void onPageSelected(int position) {
                OneItemFamilyView.this.refreshKidozWebView(position % OneItemFamilyView.this.mAdapter.getCount());
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setId(Utils.generateViewId());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mViewPager.setPageMargin(Utils.dpTOpx(this.getContext(), 3.0f));
        this.mViewPager.setClipToPadding(false);
        int margin = Utils.dpTOpx(this.getContext(), 4.0f);
        this.mViewPagerCardContainerView.setContentPadding(margin, margin, margin, margin);
        this.mViewPagerCardContainerView.addView((View)this.mViewPager, (ViewGroup.LayoutParams)params);
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = this.mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId()) && !contentItem.getIsAvoidAutoImpression()) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), position);
            EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), this.mWidgetType, this.mStyleId, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
        }
    }

    public void showLoadingProgressView(boolean show) {
        if (show) {
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
        this.mHtmlDefaultView.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
        this.mHtmlSpecialView.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
    }

    public void setContent(ArrayList<ContentItem> content) {
        this.mContent = content;
        if (this.mWidth != 0 && this.mHeight != 0) {
            this.showContent();
        }
    }

    public void clearContent() {
        if (this.mContent != null) {
            this.mSponsoredContentDisplayed.clear();
            this.mContent.clear();
            this.mAdapter = new ItemViewPagerAdapter(this.mWidth, this.mHeight);
            InfinitePagerAdapter wrappedAdapter = new InfinitePagerAdapter(this.mAdapter);
            this.mViewPager.setAdapter(wrappedAdapter);
        }
    }

    private void showContent() {
        if (this.mLock.tryLock()) {
            try {
                this.mSponsoredContentDisplayed.clear();
                this.mAdapter = new ItemViewPagerAdapter(this.mWidth, this.mHeight);
                this.mAdapter.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
                InfinitePagerAdapter wrappedAdapter = new InfinitePagerAdapter(this.mAdapter);
                this.mViewPager.setAdapter(wrappedAdapter);
                wrappedAdapter.setOnFirstItemListener(new InfinitePagerAdapter.IOnFistItemInstaniateListener(){

                    @Override
                    public void onFirstItemReady() {
                        OneItemFamilyView.this.refreshKidozWebView(0);
                    }
                });
                if (this.mContent != null && !this.mContent.isEmpty()) {
                    this.mAdapter.setContent(this.mContent);
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    public void startAutoScroll() {
        this.mViewPager.startAutoScroll(this.AUTO_SCROLL_DELAY);
    }

    public void stopAutoScroll() {
        this.mViewPager.stopAutoScroll();
    }

    public boolean isEmpty() {
        if (this.mAdapter == null) {
            return true;
        }
        return this.mAdapter.isAdapterEmpty();
    }

    public void onEvent(EventMessage event) {
        if (event != null && event.getMessageType() == EventMessage.MessageType.HTML_FULL_VIEW_CLOSE && event.getAdditionalParam() != null && event.getAdditionalParam().equals(this.mWidgetType)) {
            this.onFullScreenPlayerViewClosed();
        }
    }

    protected void onFullScreenPlayerViewClosed() {
        if (this.mCurrentItemInView.getIsNonDefaultHtml()) {
            this.mHtmlSpecialView.loadHtml();
        } else if (this.mCurrentItemInViewPosition != -1) {
            OneContentItemView panelContentItem = (OneContentItemView)this.mViewPager.findViewWithTag(this.mCurrentItemInViewPosition);
            panelContentItem.setActiveWebView(this.mHtmlDefaultView);
            this.mHtmlDefaultView.requestFocusOn(false);
        }
        if (this.mOneItemActionListener != null) {
            this.mOneItemActionListener.onAction(OneItemAction.RESTART_ANY_ANIMATION);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.requestFocusOff();
        }
        if (this.mHtmlSpecialView != null) {
            this.mHtmlSpecialView.stopAndReleaseWebView();
        }
    }

    public void nextPagerItem() {
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.resumePlaybackAction();
        }
    }

    public void previousItem() {
        this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1);
    }

    public void stopAnyPlaybackAction() {
        this.mHtmlSpecialView.clearHtmlView();
        this.mHtmlDefaultView.requestFocusOff();
        this.stopAutoScroll();
    }

    public void resumePlaybackAction() {
        if (this.getVisibility() == 0 && this.mCurrentItemInViewPosition != -1 && this.mAdapter != null) {
            this.refreshKidozWebView(this.mCurrentItemInViewPosition % this.mAdapter.getCount());
        }
    }

    public void setOnRefreshDrawRequestListener(IOnRefreshListener requestListener) {
        this.mRefreshListener = requestListener;
    }

    public void invokeWidgetOpen() {
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.requestWidgetOpen(this.mWidgetType);
        }
    }

    public void invokeWidgetClose() {
        if (this.mHtmlDefaultView != null) {
            this.mHtmlDefaultView.requestWidgetClose(this.mWidgetType);
        }
    }

    public static interface IOnRefreshListener {
        public void onRefreshDrawRequest();
    }

    public static interface IOnOneItemActionListener {
        public void onAction(OneItemAction var1);
    }

    public static enum OneItemAction {
        STOP_ANY_ANIMATION,
        RESTART_ANY_ANIMATION,
        ON_RESET_AUTO_LAUNCH;

    }
}

