/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;
import java.util.ArrayList;

public class ItemViewPagerAdapter
extends PagerAdapter {
    private ArrayList<ContentItem> mContent = new ArrayList();
    private ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick = true;
    protected int mWidth;
    protected int mHeight;

    public ItemViewPagerAdapter(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setViewPagerItemClickListener(ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public int getCount() {
        int result = 0;
        if (this.mContent != null) {
            result = this.mContent.size();
        }
        return result;
    }

    public void setContent(ArrayList<ContentItem> content) {
        this.mContent = content;
        this.notifyDataSetChanged();
    }

    public void clearContent() {
        this.mContent.clear();
        this.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup container, final int position) {
        final ContentItem contentItem = this.mContent.get(position);
        OneContentItemView panelContentItem = new OneContentItemView(container.getContext(), this.mWidth, this.mHeight);
        panelContentItem.setTag(position);
        panelContentItem.applyViewSettingsByContentType(contentItem.getContentType());
        panelContentItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ItemViewPagerAdapter.this.mIsCanClick) {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    ItemViewPagerAdapter.this.mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            ItemViewPagerAdapter.this.mViewPagerItemClickListener.onClickEnd(contentItem, position);
                            ItemViewPagerAdapter.this.mIsCanClick = true;
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null) {
            panelContentItem.setData(contentItem);
        }
        container.addView((View)panelContentItem);
        return panelContentItem;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)((OneContentItemView)((Object)object)));
    }

    public ContentItem getContentItem(int position) {
        ContentItem result = null;
        if (this.mContent != null && this.mContent.size() > position) {
            result = this.mContent.get(position);
        }
        return result;
    }

    public boolean isAdapterEmpty() {
        if (this.mContent == null) {
            return true;
        }
        return this.mContent.isEmpty();
    }

    public static interface ViewPagerItemClickListener {
        public void onClickEnd(ContentItem var1, int var2);
    }
}

