/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.loading_progress_view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.loading_progress_view.CircularProgressDrawable;

public class LoadingProgressView
extends View {
    private CircularProgressDrawable mDrawable;
    private static final float LINE_WIDTH = 0.018518519f;

    public LoadingProgressView(Context context) {
        this(context, null);
        this.setVisibility(8);
    }

    public LoadingProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int screenWidth = Utils.getScreenSize(context, true);
        this.mDrawable = new CircularProgressDrawable(Color.parseColor((String)"#f57900"), (float)screenWidth * 0.018518519f);
        this.mDrawable.setCallback((Drawable.Callback)this);
    }

    public void setCircleColor(int color) {
        this.mDrawable.setPaintColor(color);
    }

    public void setCircleWidth(float width) {
        this.mDrawable.setStrokeWidth(width);
    }

    public void setCircleWidthRelativeToSize(float size) {
        this.mDrawable.setStrokeWidth(size * 0.018518519f);
    }

    public void startLoadingAnimation() {
        if (!this.mDrawable.isRunning()) {
            this.setVisibility(0);
            this.mDrawable.start();
        }
    }

    public void stopLoadingAnimation() {
        this.mDrawable.stop();
        this.setVisibility(8);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mDrawable.setBounds(0, 0, w, h);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mDrawable.draw(canvas);
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mDrawable || super.verifyDrawable(who);
    }
}

