/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozBanner;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BannerViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BaseBanner;
import com.kidoz.sdk.api.ui_views.one_item_view.AutoScrollViewPager;
import com.kidoz.sdk.api.ui_views.one_item_view.InfinitePagerAdapter;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.json.JSONObject;

public class KidozBanner2
extends BaseBanner {
    private final String TAG = KidozBanner2.class.getSimpleName();
    private int AUTO_SCROLL_DELAY = 10000;
    private RelativeLayout mContainer;
    private RelativeLayout mKidozRelatedContainer;
    private RelativeLayout mActualyBannerRelatedContainer;
    private AssetView mParentalLockButton;
    private AssetView mAboutButton;
    private AssetView mNextButton;
    private AssetView mPreviousButton;
    private AssetView mGifView;
    private AutoScrollViewPager mViewPager;
    private BannerViewPagerAdapter mAdapter;
    private TextView mKidozLabelTextView;
    private TextView mAppNameTextView;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();
    private ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    private ContentLogicLoader mContentLogicLoader;
    private Utils.StaticHandler mStaticHandler;
    private AnimationHandler mAnimationHandler;
    private WalkAndPushAnimationHandler mWalkAndPushAnimationHandler;
    private String mStyleID;
    public static final String BACKGROUND_GRADIENT_COLOR_1 = "bgGradientColor1";
    public static final String BACKGROUND_GRADIENT_COLOR_2 = "bgGradientColor2";
    public static final String BACKGROUND_COLOR = "bgColor";
    public static final String LOCK_ACTIVE = "parentalLockActive";
    public static final String LOCK_NOT_ACTIVE = "parentalLockNotActive";
    public static final String LOCK_ANIMATION = "parentalLockAnimation";
    public static final String ABOUT_KIDOZ = "aboutKidoz";
    public static final String ABOUT_KIDOZ_ANIMATION = "aboutKidozAnimation";
    public static final String NEXT_BUTTON = "nextBtn";
    public static final String NEXT_BUTTON_ANIMATION = "nextBtnAnimation";
    public static final String PREVIOUS_BUTTON = "previousBtn";
    public static final String PREVIOUS_BUTTON_ANIMATION = "previousBtnAnimation";
    public static final String PROMOTION_ANIMATION = "animationUrl";
    public static final String PROMOTION_ANIMATION_RATIO = "animationRatio_WH";
    public static final String CONTENT_BACKGROUND_1 = "contentBackground1";
    public static final String CONTENT_BACKGROUND_2 = "contentBackground2";
    public static final String CONTENT_BACKGROUND_STROKE_COLOR = "contentBackgroundStrokeColor";
    public static final String LABEL_TEXT = "labelText";
    public static final String LABEL_COLOR = "labelColor";
    public static final String APP_NAME_COLOR = "appNameColor";
    public static final String IS_SMART_BANNER = "isSmartBanner";
    public static final String POP_SOUND = "banner2PopSound";

    public KidozBanner2(Context context) {
        super(context);
    }

    @Override
    public void setProperties(JSONObject properties) {
        this.mProperties = properties;
        this.initView();
    }

    @Override
    public void initView() {
        super.initView();
        this.initSoundManager();
        this.mStyleID = this.mProperties.optString("style_id");
        this.AUTO_SCROLL_DELAY = this.mProperties.optInt("swapContentRefreshRateSec", 10) * 1000;
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER, false);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        if (this.mProperties != null) {
            this.initContainer();
            this.initKidozContainer();
            this.initActualyBannerRelatedContainer();
            this.initAboutKidozButton();
            this.initParentalLockButton();
            this.initKidozText();
            this.initViewPager();
            this.initAnimation();
            this.initContentLogicLoader();
            this.initAppNameTextView();
            this.initWalkAndPushAnimationHandler();
            this.hideBanner();
            this.applyContainerParams();
            this.applyParentalLockParams();
            this.applyKidozLabelParams();
            this.applyAboutButtonParams();
            this.applyActualBannerContainerParams();
            this.applyAnimationParams();
            this.applyViewPagerParams();
            this.applyAppNameParams();
        }
    }

    private void initSoundManager() {
        File soundFile = AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(POP_SOUND));
        if (soundFile != null) {
            SdkSoundManager.preloadSound(soundFile.getAbsolutePath());
        }
    }

    private void initThumbnailAnimation() {
        if (this.mAnimationHandler == null) {
            this.mAnimationHandler = new AnimationHandler((View)this.mActualyBannerRelatedContainer);
        }
    }

    private void initWalkAndPushAnimationHandler() {
        this.mWalkAndPushAnimationHandler = new WalkAndPushAnimationHandler(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(POP_SOUND)), (View)this.mGifView, (View)this.mViewPager);
    }

    @Override
    public void loadContent() {
        super.loadContent();
        if (this.mContentLogicLoader != null) {
            this.mContentLogicLoader.loadContent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleID);
        }
    }

    private void initKidozContainer() {
        this.mKidozRelatedContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(9);
        params.topMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mContainer.addView((View)this.mKidozRelatedContainer, (ViewGroup.LayoutParams)params);
    }

    private void initActualyBannerRelatedContainer() {
        this.mActualyBannerRelatedContainer = new RelativeLayout(this.getContext());
        this.mActualyBannerRelatedContainer.setId(Utils.generateViewId());
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
        gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
        if (Build.VERSION.SDK_INT >= 16) {
            this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
        } else {
            this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
        }
        float width = TypedValue.applyDimension((int)1, (float)200.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(13);
        this.mContainer.addView((View)this.mActualyBannerRelatedContainer, (ViewGroup.LayoutParams)params);
        this.mActualyBannerRelatedContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View v) {
                v.setClickable(false);
                GenAnimator.animateLongDurationClick(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        int pos;
                        v.setClickable(true);
                        if (KidozBanner2.this.mViewPager != null && KidozBanner2.this.mAdapter != null && !KidozBanner2.this.mAdapter.isAdapterEmpty() && (pos = KidozBanner2.this.mViewPager.getCurrentItem() % KidozBanner2.this.mAdapter.getCount()) < KidozBanner2.this.mAdapter.getCount()) {
                            KidozBanner2.this.handleClick(KidozBanner2.this.mAdapter.getContentItem(pos), pos);
                        }
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    private void initAboutKidozButton() {
        this.mAboutButton = new AssetView(this.getContext());
        this.mAboutButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mAboutButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(ABOUT_KIDOZ_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mAboutButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    KidozBanner2.this.mAboutButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)KidozBanner2.this.mAboutButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            KidozBanner2.this.mAboutButton.setClickable(true);
                            int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozBanner2.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(KidozBanner2.this.getContext(), false) * 0.5f)};
                            AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(KidozBanner2.this.getContext(), popLocation);
                            aboutKidozDialog.openDialog();
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mAboutButton.setPadding(padding, padding, padding, 0);
        float width = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(14);
        params.addRule(12);
        this.mKidozRelatedContainer.addView((View)this.mAboutButton, (ViewGroup.LayoutParams)params);
        this.mAboutButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(ABOUT_KIDOZ)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner2.this.autoOpen();
            }
        });
    }

    private void initAnimation() {
        this.mGifView = new AssetView(this.getContext());
        this.mGifView.setScaleType(ImageView.ScaleType.FIT_END);
        float width = TypedValue.applyDimension((int)1, (float)135.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(9);
        params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mActualyBannerRelatedContainer.addView((View)this.mGifView, (ViewGroup.LayoutParams)params);
        this.mGifView.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(PROMOTION_ANIMATION)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner2.this.autoOpen();
            }
        });
    }

    private void initNextButton() {
        this.mNextButton = new AssetView(this.getContext());
        this.mNextButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mNextButton.setId(Utils.generateViewId());
        float width = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(11);
        params.rightMargin = (int)margin;
        this.mActualyBannerRelatedContainer.addView((View)this.mNextButton, (ViewGroup.LayoutParams)params);
        String clickAnimation = this.mProperties.optString(NEXT_BUTTON_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mNextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    KidozBanner2.this.mNextButton.setClickable(false);
                    SdkAnimationsUtils.animateClick((View)KidozBanner2.this.mNextButton, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozBanner2.this.mNextButton.setClickable(true);
                            KidozBanner2.this.mViewPager.setCurrentItem(KidozBanner2.this.mViewPager.getCurrentItem() + 1);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        }
        this.mNextButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(NEXT_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner2.this.autoOpen();
            }
        });
        this.mPreviousButton = new AssetView(this.getContext());
        this.mPreviousButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mPreviousButton.setId(Utils.generateViewId());
        params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(9);
        params.leftMargin = (int)margin;
        this.mActualyBannerRelatedContainer.addView((View)this.mPreviousButton, (ViewGroup.LayoutParams)params);
        clickAnimation = this.mProperties.optString(PREVIOUS_BUTTON_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    KidozBanner2.this.mPreviousButton.setClickable(false);
                    SdkAnimationsUtils.animateClick((View)KidozBanner2.this.mPreviousButton, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozBanner2.this.mPreviousButton.setClickable(true);
                            KidozBanner2.this.mViewPager.setCurrentItem(KidozBanner2.this.mViewPager.getCurrentItem() - 1);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        }
        this.mPreviousButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(PREVIOUS_BUTTON)), new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                KidozBanner2.this.autoOpen();
            }
        });
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    KidozBanner2.this.setContent(contentData.getContentDataItems());
                    KidozBanner2.this.initThumbnailAnimation();
                    KidozBanner2.this.startHandlers();
                    if (KidozBanner2.this.mKidozBannerListener != null) {
                        KidozBanner2.this.mKidozBannerListener.onBannerContentLoaded();
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                if (KidozBanner2.this.mKidozBannerListener != null) {
                    KidozBanner2.this.mKidozBannerListener.onBannerContentLoadFailed();
                }
            }
        });
    }

    private void initContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        try {
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(BACKGROUND_GRADIENT_COLOR_1, "#ffffff").trim()), Color.parseColor((String)this.mProperties.optString(BACKGROUND_GRADIENT_COLOR_2, "#ffffff").trim())});
            if (Build.VERSION.SDK_INT >= 16) {
                this.mContainer.setBackground((Drawable)gradientDrawable);
            } else {
                this.mContainer.setBackgroundDrawable((Drawable)gradientDrawable);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to initContainer: " + ex.getMessage());
        }
        this.mContainer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        float width = TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mParentalLockButton.setId(Utils.generateViewId());
        String clickAnimation = this.mProperties.optString(LOCK_ANIMATION);
        if (clickAnimation != null && clickAnimation.equals(GenAnimator.PRESS_IN_OUT)) {
            this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    KidozBanner2.this.mParentalLockButton.setClickable(false);
                    GenAnimator.clickItemAnimation((View)KidozBanner2.this.mParentalLockButton, 150, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            KidozBanner2.this.mParentalLockButton.setClickable(true);
                            if (ParentalLockDialog.getIsCanShowDialog(KidozBanner2.this.getContext())) {
                                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(KidozBanner2.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(KidozBanner2.this.getContext(), false) * 0.5f)};
                                ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozBanner2.this.getContext(), false, popLocation);
                                parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                    public void onDismiss(DialogInterface dialog) {
                                        KidozBanner2.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                    @Override
                                    public void onPasswordEntered(boolean isPasswordCorrect) {
                                        KidozBanner2.this.updateLockIcon();
                                    }
                                });
                                parentalLockDialog.show();
                            }
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            });
        }
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mParentalLockButton.setPadding(padding, padding, padding, padding);
        float width = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(11);
        this.mContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        this.updateLockIcon();
    }

    private void updateLockIcon() {
        try {
            boolean isLockActive;
            boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            if (isLockActive) {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner2.this.autoOpen();
                    }
                });
            } else {
                this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mProperties.optString(LOCK_NOT_ACTIVE)), new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        KidozBanner2.this.autoOpen();
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    private void initKidozText() {
        this.mKidozLabelTextView = new TextView(this.getContext());
        this.mKidozLabelTextView.setTextColor(Color.parseColor((String)this.mProperties.optString(LABEL_COLOR).trim()));
        this.mKidozLabelTextView.setShadowLayer(20.0f, 0.0f, 0.0f, Color.parseColor((String)"#80000000"));
        this.mKidozLabelTextView.setText((CharSequence)this.mProperties.optString(LABEL_TEXT));
        this.mKidozLabelTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mKidozLabelTextView.setGravity(17);
        this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.2f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mKidozLabelTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                KidozBanner2.this.mAboutButton.performClick();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(14);
        params.addRule(10);
        this.mKidozRelatedContainer.addView((View)this.mKidozLabelTextView, (ViewGroup.LayoutParams)params);
    }

    private void initAppNameTextView() {
        this.mAppNameTextView = new TextView(this.getContext());
        this.mAppNameTextView.setTextColor(Color.parseColor((String)this.mProperties.optString(APP_NAME_COLOR, "#ffffff").trim()));
        this.mAppNameTextView.setShadowLayer(20.0f, 0.0f, 0.0f, Color.parseColor((String)"#80000000"));
        this.mAppNameTextView.setGravity(17);
        this.mAppNameTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mAppNameTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.2f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(14);
        params.addRule(10);
        this.mContainer.addView((View)this.mAppNameTextView, (ViewGroup.LayoutParams)params);
    }

    private void initViewPager() {
        this.mViewPager = new AutoScrollViewPager(this.getContext());
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
        gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
        if (Build.VERSION.SDK_INT >= 16) {
            this.mViewPager.setBackground((Drawable)gradientDrawable);
        } else {
            this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
        }
        this.mViewPager.setInterval(this.AUTO_SCROLL_DELAY);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                KidozBanner2.this.sendImpressionLog(position % KidozBanner2.this.mAdapter.getCount());
                KidozBanner2.this.setAppName(KidozBanner2.this.mAdapter.getContentItem(position % KidozBanner2.this.mAdapter.getCount()));
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setId(Utils.generateViewId());
        int margin = Utils.dpTOpx(this.getContext(), 1.0f);
        this.mViewPager.setPadding(margin, margin, margin, margin);
        margin = Utils.dpTOpx(this.getContext(), 6.0f);
        this.mViewPager.setPageMargin(margin);
        float width = TypedValue.applyDimension((int)1, (float)44.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        float height = TypedValue.applyDimension((int)1, (float)44.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
        params.addRule(13);
        this.mActualyBannerRelatedContainer.addView((View)this.mViewPager, (ViewGroup.LayoutParams)params);
        this.mViewPagerItemClickListener = new ItemViewPagerAdapter.ViewPagerItemClickListener(){

            @Override
            public void onClickEnd(ContentItem contentItem, int position) {
                KidozBanner2.this.handleClick(contentItem, position);
            }
        };
    }

    private void handleClick(ContentItem contentItem, int position) {
        if (contentItem != null && this.mAllowClickHandling) {
            this.mAllowClickHandling = false;
            ContentExecutionHandler.handleContentItemClick(this.getContext(), contentItem, WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleID, position, true, false, new ContentExecutionHandler.IOnHandleClickListener(){

                @Override
                public void onRestoreClick() {
                    KidozBanner2.this.mAllowClickHandling = true;
                }
            });
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mViewPager != null) {
            if (visibility == 0) {
                this.startHandlers();
            } else {
                this.stopHandlers();
            }
        }
    }

    private void sendImpressionLog(int position) {
        ContentItem contentItem = this.mAdapter.getContentItem(position);
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !contentItem.getIsAvoidAutoImpression() && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId())) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), position);
            EventManager.getInstance(this.getContext()).logSponsoredContentImpressionEvent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleID, "Impression", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
        }
    }

    private void setContent(ArrayList<ContentItem> content) {
        this.mSponsoredContentDisplayed.clear();
        this.mAdapter = new BannerViewPagerAdapter(this.getContext(), true);
        this.mAdapter.setViewPagerItemClickListener(this.mViewPagerItemClickListener);
        this.mAdapter.setContent(content);
        InfinitePagerAdapter wrappedAdapter = new InfinitePagerAdapter(this.mAdapter);
        this.mViewPager.setAdapter(wrappedAdapter);
        this.mViewPager.startAutoScroll(this.AUTO_SCROLL_DELAY);
        if (content != null && !content.isEmpty()) {
            this.mViewPager.setCurrentItem(0);
            this.sendImpressionLog(0);
            this.setAppName(content.get(0));
        }
    }

    @Override
    public boolean getIsCanOpen() {
        boolean result = false;
        if (this.mParentalLockButton != null && this.mAboutButton != null && this.mGifView != null) {
            result = this.mParentalLockButton.getIsAssetLoaded() && this.mAboutButton.getIsAssetLoaded() && this.mGifView.getIsAssetLoaded();
        }
        return result;
    }

    @Override
    protected void showInner() {
        super.showInner();
        GenAnimator.fade(true, (View)this, 400, null);
        this.setVisibility(0);
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerShow();
        }
        if (this.mViewPager != null) {
            if (this.mAdapter != null && !this.mAdapter.isAdapterEmpty()) {
                this.startHandlers();
            } else {
                this.stopHandlers();
            }
        }
        this.sendActionWidgetViewImpression();
    }

    @Override
    public void hideBanner() {
        super.hideBanner();
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerHide();
        }
        this.stopHandlers();
    }

    @Override
    protected void autoOpen() {
        if (this.mIsWaitingToOpen && this.getIsCanOpen()) {
            this.showBanner();
        }
    }

    public static boolean parseKidozBanner(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(KidozBanner.TAG, (Object)KidozBanner2.class.getSimpleName());
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(KidozBanner.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE);
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, ABOUT_KIDOZ);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, NEXT_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PREVIOUS_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, PROMOTION_ANIMATION);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, POP_SOUND);
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(KidozBanner.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(KidozBanner.TAG, "Error when trying to parse kidoz banner2 properties: " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.stopHandlers();
        super.onDetachedFromWindow();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.applyContainerParams();
        this.applyParentalLockParams();
        this.applyKidozLabelParams();
        this.applyAboutButtonParams();
        this.applyActualBannerContainerParams();
        this.applyAnimationParams();
        this.applyViewPagerParams();
        this.applyAppNameParams();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
        this.stopHandlers();
        this.startHandlers();
    }

    @Override
    public void setIsSmartBanner(boolean isSmartBanner) {
        super.setIsSmartBanner(isSmartBanner);
        try {
            if (this.mIsOverrideUser) {
                this.mIsSmartBanner = this.mProperties.optBoolean(IS_SMART_BANNER);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to load is smart flag: " + ex.getMessage());
        }
        this.applyContainerParams();
        this.applyParentalLockParams();
        this.applyKidozLabelParams();
        this.applyAboutButtonParams();
        this.applyActualBannerContainerParams();
        this.applyAnimationParams();
        this.applyViewPagerParams();
        this.applyAppNameParams();
    }

    private void applyContainerParams() {
        if (this.mIsSmartBanner) {
            this.mContainer.getLayoutParams().width = -1;
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            int height = screenHeightDP <= 400 ? (int)TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) : (screenHeightDP > 400 && screenHeightDP <= 720 ? (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) : (int)TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            this.mContainer.getLayoutParams().height = height;
        } else {
            this.mContainer.getLayoutParams().width = (int)TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mContainer.getLayoutParams().height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
    }

    private void applyParentalLockParams() {
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(15);
                    params.addRule(11);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    this.mParentalLockButton.setPadding(0, 0, 0, 0);
                    this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(15);
                    params.addRule(11);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    this.mParentalLockButton.setPadding(0, 0, 0, 0);
                    this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
                } else {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(15);
                    params.addRule(11);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.rightMargin = margin;
                    this.mParentalLockButton.setPadding(0, 0, 0, 0);
                    this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(15);
                params.addRule(11);
                params.width = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = margin;
                this.mParentalLockButton.setPadding(0, 0, 0, 0);
                this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(15);
            params.addRule(11);
            params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.rightMargin = margin;
            this.mParentalLockButton.setPadding(0, 0, 0, 0);
            this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(15);
            params.addRule(11);
            params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.rightMargin = margin;
            this.mParentalLockButton.setPadding(0, 0, 0, 0);
            this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyKidozLabelParams() {
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                    params.addRule(1, this.mAboutButton.getId());
                    params.addRule(15);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)3.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                    this.mKidozLabelTextView.setSingleLine(false);
                    this.mKidozLabelTextView.setMinLines(2);
                    this.mKidozLabelTextView.setMaxLines(2);
                    this.mKidozLabelTextView.setGravity(19);
                    this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    int width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                    params.width = width;
                    params.addRule(3, this.mAboutButton.getId());
                    params.addRule(14);
                    params.addRule(12);
                    params.topMargin = -margin;
                    this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                    this.mKidozLabelTextView.setSingleLine(false);
                    this.mKidozLabelTextView.setMinLines(1);
                    this.mKidozLabelTextView.setMaxLines(2);
                    this.mKidozLabelTextView.setGravity(49);
                    this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                } else {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                    params.addRule(1, this.mAboutButton.getId());
                    params.addRule(15);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)120.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                    this.mKidozLabelTextView.setSingleLine(false);
                    this.mKidozLabelTextView.setMinLines(1);
                    this.mKidozLabelTextView.setMaxLines(2);
                    this.mKidozLabelTextView.setGravity(51);
                    this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                int width = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                params.width = width;
                params.addRule(3, this.mAboutButton.getId());
                params.addRule(14);
                params.addRule(12);
                params.topMargin = -margin;
                this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)7.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                this.mKidozLabelTextView.setSingleLine(false);
                this.mKidozLabelTextView.setMinLines(1);
                this.mKidozLabelTextView.setMaxLines(2);
                this.mKidozLabelTextView.setGravity(49);
                this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            int margin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.width = width;
            params.addRule(3, this.mAboutButton.getId());
            params.addRule(14);
            params.addRule(12);
            params.topMargin = -margin;
            this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)2.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            this.mKidozLabelTextView.setSingleLine(false);
            this.mKidozLabelTextView.setMinLines(1);
            this.mKidozLabelTextView.setMaxLines(2);
            this.mKidozLabelTextView.setGravity(49);
            this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            int margin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.width = width;
            params.addRule(3, this.mAboutButton.getId());
            params.addRule(14);
            params.addRule(12);
            params.topMargin = -margin;
            this.mKidozLabelTextView.setTextSize(TypedValue.applyDimension((int)2, (float)3.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
            this.mKidozLabelTextView.setSingleLine(false);
            this.mKidozLabelTextView.setMinLines(1);
            this.mKidozLabelTextView.setMaxLines(2);
            this.mKidozLabelTextView.setGravity(49);
            this.mKidozLabelTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyAboutButtonParams() {
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    this.mAboutButton.setPadding(0, 0, 0, 0);
                    params.addRule(15);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    this.mAboutButton.setPadding(0, 0, 0, 0);
                    params.addRule(10);
                    params.addRule(14);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
                } else {
                    int margin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.width = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.leftMargin = margin;
                    params.addRule(15);
                    this.mAboutButton.setPadding(0, 0, 0, 0);
                    this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.width = (int)TypedValue.applyDimension((int)1, (float)70.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.height = (int)TypedValue.applyDimension((int)1, (float)70.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.addRule(14);
                params.addRule(10);
                params.topMargin = -padding;
                this.mAboutButton.setPadding(padding, 0, padding, 0);
                this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            this.mAboutButton.setPadding(0, 0, 0, 0);
            params.addRule(10);
            params.addRule(14);
            params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            this.mAboutButton.setPadding(0, 0, 0, 0);
            params.addRule(10);
            params.addRule(14);
            params.width = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mAboutButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyActualBannerContainerParams() {
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)TypedValue.applyDimension((int)1, (float)280.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.addRule(13);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                    this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)TypedValue.applyDimension((int)1, (float)200.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.addRule(13);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                    this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                } else {
                    int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)TypedValue.applyDimension((int)1, (float)430.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.addRule(13);
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                    gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                    this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.height = (int)TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.width = (int)TypedValue.applyDimension((int)1, (float)310.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.addRule(13);
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
                gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
                gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
                } else {
                    this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
                }
                this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.width = (int)TypedValue.applyDimension((int)1, (float)170.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.addRule(13);
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
            gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
            gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
            if (Build.VERSION.SDK_INT >= 16) {
                this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
            } else {
                this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
            }
            this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
        } else {
            int strokeSize = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.width = (int)TypedValue.applyDimension((int)1, (float)180.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.addRule(13);
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_1, "#39b0c5")), Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_2, "#39b0c5"))});
            gradientDrawable.setStroke(strokeSize, Color.parseColor((String)this.mProperties.optString(CONTENT_BACKGROUND_STROKE_COLOR, "#ffffff")));
            gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
            if (Build.VERSION.SDK_INT >= 16) {
                this.mActualyBannerRelatedContainer.setBackground((Drawable)gradientDrawable);
            } else {
                this.mActualyBannerRelatedContainer.setBackgroundDrawable((Drawable)gradientDrawable);
            }
            this.mActualyBannerRelatedContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mActualyBannerRelatedContainer.setPadding(strokeSize, strokeSize, strokeSize, strokeSize);
        }
    }

    private void applyAnimationParams() {
        float animationRatio = (float)this.mProperties.optDouble(PROMOTION_ANIMATION_RATIO, (double)0.6f);
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(9);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)(animationRatio * (float)params.height);
                    this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(9);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)(animationRatio * (float)params.height);
                    this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
                } else {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                    params.addRule(9);
                    params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.width = (int)(animationRatio * (float)params.height);
                    this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
                params.addRule(9);
                params.height = (int)TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.width = (int)(animationRatio * (float)params.height);
                this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(9);
            params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.width = (int)(animationRatio * (float)params.height);
            this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
        } else {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(9);
            params.height = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            params.width = (int)(animationRatio * (float)params.height);
            this.mGifView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mWalkAndPushAnimationHandler.setDistance(params.width, this.mActualyBannerRelatedContainer.getLayoutParams().width);
        }
    }

    private void applyNextButtonsParams() {
        if (this.mIsSmartBanner) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(11);
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                float width = TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                float width = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            } else {
                float width = TypedValue.applyDimension((int)1, (float)70.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.rightMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            }
            this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyPreviousButtonsParams() {
        if (this.mIsSmartBanner) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(0, 0);
            params.addRule(9);
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                float width = TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)32.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.leftMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                float width = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.leftMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            } else {
                float width = TypedValue.applyDimension((int)1, (float)70.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)90.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float margin = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                params.leftMargin = (int)margin;
                params.width = (int)width;
                params.height = (int)height;
            }
            this.mPreviousButton.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void applyViewPagerParams() {
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    float width = TypedValue.applyDimension((int)1, (float)28.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension((int)1, (float)28.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
                    params.addRule(15);
                    params.addRule(9);
                    this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (this.mAdapter != null) {
                        this.mAdapter.setContainerHeight((int)height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mViewPager.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    float width = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
                    params.addRule(15);
                    params.addRule(9);
                    this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (this.mAdapter != null) {
                        this.mAdapter.setContainerHeight((int)height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mViewPager.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                } else {
                    float width = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    float height = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
                    params.addRule(15);
                    params.addRule(9);
                    this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (this.mAdapter != null) {
                        this.mAdapter.setContainerHeight((int)height);
                    }
                    GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                    gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.mViewPager.setBackground((Drawable)gradientDrawable);
                    } else {
                        this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
                    }
                }
            } else if (ScreenUtils.getIsTablet(this.getContext())) {
                float width = TypedValue.applyDimension((int)1, (float)86.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                float height = TypedValue.applyDimension((int)1, (float)86.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
                params.addRule(15);
                params.addRule(9);
                this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
                if (this.mAdapter != null) {
                    this.mAdapter.setContainerHeight((int)height);
                }
                GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
                gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mViewPager.setBackground((Drawable)gradientDrawable);
                } else {
                    this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
                }
            }
        } else if (!ScreenUtils.getIsTablet(this.getContext())) {
            float width = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            float height = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
            params.addRule(15);
            params.addRule(9);
            this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mAdapter != null) {
                this.mAdapter.setContainerHeight((int)height);
            }
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
            gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
            if (Build.VERSION.SDK_INT >= 16) {
                this.mViewPager.setBackground((Drawable)gradientDrawable);
            } else {
                this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
            }
        } else {
            float width = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            float height = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)width, (int)height);
            params.addRule(15);
            params.addRule(9);
            this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mAdapter != null) {
                this.mAdapter.setContainerHeight((int)height);
            }
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-1, -1});
            gradientDrawable.setCornerRadius((float)((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
            if (Build.VERSION.SDK_INT >= 16) {
                this.mViewPager.setBackground((Drawable)gradientDrawable);
            } else {
                this.mViewPager.setBackgroundDrawable((Drawable)gradientDrawable);
            }
        }
    }

    private void applyAppNameParams() {
        this.mAppNameTextView.setVisibility(8);
        if (this.mIsSmartBanner) {
            int screenHeightDP = this.getContext().getResources().getConfiguration().screenHeightDp;
            if (screenHeightDP <= 400) {
                if (!ScreenUtils.getIsTablet(this.getContext())) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
                    params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.rightMargin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.addRule(1, this.mActualyBannerRelatedContainer.getId());
                    params.addRule(0, this.mParentalLockButton.getId());
                    params.addRule(15);
                    this.mAppNameTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mAppNameTextView.setPadding(0, 0, 0, 0);
                    this.mAppNameTextView.setTextSize(TypedValue.applyDimension((int)2, (float)3.5f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                    this.mAppNameTextView.setSingleLine(false);
                    this.mAppNameTextView.setGravity(17);
                    this.mAppNameTextView.setMinLines(1);
                    this.mAppNameTextView.setMaxLines(2);
                    this.mAppNameTextView.setVisibility(0);
                }
            } else if (screenHeightDP > 400 && screenHeightDP <= 720) {
                if (ScreenUtils.getIsTablet(this.getContext())) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
                    params.leftMargin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.rightMargin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
                    params.addRule(1, this.mActualyBannerRelatedContainer.getId());
                    params.addRule(0, this.mParentalLockButton.getId());
                    params.addRule(15);
                    this.mAppNameTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mAppNameTextView.setPadding(0, 0, 0, 0);
                    this.mAppNameTextView.setTextSize(TypedValue.applyDimension((int)2, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
                    this.mAppNameTextView.setSingleLine(false);
                    this.mAppNameTextView.setGravity(17);
                    this.mAppNameTextView.setMinLines(1);
                    this.mAppNameTextView.setMaxLines(2);
                    this.mAppNameTextView.setVisibility(0);
                }
            } else if (!ScreenUtils.getIsTablet(this.getContext())) {
                // empty if block
            }
        }
    }

    private void setAppName(final ContentItem contentItem) {
        this.mAppNameTextView.setText(null);
        if (contentItem != null && contentItem.getName() != null) {
            GenAnimator.fade(false, (View)this.mAppNameTextView, 150, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    KidozBanner2.this.mAppNameTextView.setText((CharSequence)contentItem.getName());
                    GenAnimator.fade(true, (View)KidozBanner2.this.mAppNameTextView, 200, null);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    private void startHandlers() {
        this.stopHandlers();
        if (this.mViewPager != null && this.mGifView != null) {
            this.mGifView.setVisibility(4);
            this.mViewPager.setVisibility(4);
        }
        this.getMyHandlerInstance().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (KidozBanner2.this.mViewPager != null) {
                    KidozBanner2.this.mViewPager.startAutoScroll();
                }
                if (KidozBanner2.this.mAnimationHandler != null) {
                    KidozBanner2.this.mAnimationHandler.sendEmptyMessageDelayed(0, KidozBanner2.this.mAnimationHandler.getDelay());
                }
                if (KidozBanner2.this.mWalkAndPushAnimationHandler != null) {
                    KidozBanner2.this.mWalkAndPushAnimationHandler.sendEmptyMessage(0);
                }
                if (KidozBanner2.this.mViewPager != null && KidozBanner2.this.mGifView != null) {
                    KidozBanner2.this.mGifView.setVisibility(0);
                    KidozBanner2.this.mViewPager.setVisibility(0);
                }
            }
        }, 300L);
    }

    private void stopHandlers() {
        if (this.mViewPager != null && this.mGifView != null) {
            this.mGifView.setVisibility(4);
            this.mViewPager.setVisibility(4);
        }
        this.getMyHandlerInstance().removeMessages(0);
        this.getMyHandlerInstance().removeCallbacks(null);
        if (this.mViewPager != null) {
            this.mViewPager.stopAutoScroll();
        }
        if (this.mAnimationHandler != null) {
            this.mAnimationHandler.cancel();
        }
        if (this.mWalkAndPushAnimationHandler != null) {
            this.mWalkAndPushAnimationHandler.cancel();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mViewPager != null) {
            if (hasWindowFocus) {
                this.startHandlers();
            } else {
                this.stopHandlers();
            }
        }
    }

    private static class WalkAndPushAnimationHandler
    extends Handler {
        private final WeakReference<View> mAnimateableViewReference;
        private final WeakReference<View> mAnimateableViewReference2;
        private File mPopSoundFile;
        private boolean mIsIgnoringMessages;
        private int mDistance;
        private int mStartDistance;
        private AnimatorSet mAnimatorSet;

        public WalkAndPushAnimationHandler(File popSoundFile, View animateableView, View animateableView2) {
            this.mAnimateableViewReference = new WeakReference<View>(animateableView);
            this.mAnimateableViewReference2 = new WeakReference<View>(animateableView2);
            this.mIsIgnoringMessages = false;
            this.mPopSoundFile = popSoundFile;
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            this.mIsIgnoringMessages = false;
            GenAnimator.animateWalking((View)this.mAnimateableViewReference2.get(), (int)((float)(this.mDistance * this.mDistance) * 0.035f), 0.0f, this.mDistance + this.mStartDistance, null);
            this.mAnimatorSet = GenAnimator.animateWalking((View)this.mAnimateableViewReference.get(), (int)((float)(this.mDistance * this.mDistance) * 0.035f), -this.mStartDistance, this.mDistance, new GenAnimator.ViewAnimationListener(){

                @Override
                public void onAnimationEnd() {
                    if (!WalkAndPushAnimationHandler.this.mIsIgnoringMessages) {
                        View view;
                        if (WalkAndPushAnimationHandler.this.mAnimateableViewReference2 != null && (view = (View)WalkAndPushAnimationHandler.this.mAnimateableViewReference2.get()) != null) {
                            view.setTranslationX(0.0f);
                            GenAnimator.playGrowAnimation(view, 300L, 0L, (Interpolator)new DecelerateInterpolator(), null);
                            if (WalkAndPushAnimationHandler.this.mPopSoundFile != null) {
                                SdkSoundManager.playSound(view.getContext(), WalkAndPushAnimationHandler.this.mPopSoundFile.getAbsolutePath());
                            }
                        }
                        WalkAndPushAnimationHandler.this.sendEmptyMessageDelayed(0, 4000L);
                    }
                }

                @Override
                public void onAnimationStart() {
                }
            });
        }

        public void cancel() {
            this.mIsIgnoringMessages = true;
            if (this.mAnimatorSet != null) {
                this.mAnimatorSet.cancel();
            }
            this.removeMessages(0);
            this.removeCallbacks(null);
        }

        public void setDistance(int startDistance, int distance) {
            this.mStartDistance = startDistance;
            this.mDistance = distance;
        }
    }

    private static class AnimationHandler
    extends Handler {
        private final WeakReference<View> mAnimateableViewReference;
        private boolean mIsIgnoringMessages;
        private Random mRandom;
        private AnimatorSet mAnimatorSet;

        public AnimationHandler(View animateableView) {
            this.mAnimateableViewReference = new WeakReference<View>(animateableView);
            this.mRandom = new Random();
            this.mIsIgnoringMessages = false;
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            this.mIsIgnoringMessages = false;
            this.mAnimatorSet = GenAnimator.animateLongDurationClick((View)this.mAnimateableViewReference.get(), 150, new GenAnimator.ViewAnimationListener(){

                @Override
                public void onAnimationEnd() {
                    if (!AnimationHandler.this.mIsIgnoringMessages) {
                        AnimationHandler.this.sendEmptyMessageDelayed(0, AnimationHandler.this.getDelay());
                    }
                }

                @Override
                public void onAnimationStart() {
                }
            });
        }

        public void cancel() {
            this.mIsIgnoringMessages = true;
            if (this.mAnimatorSet != null) {
                this.mAnimatorSet.cancel();
            }
            this.removeMessages(0);
            this.removeCallbacks(null);
        }

        public long getDelay() {
            return this.mRandom.nextInt(2000) + 2000;
        }
    }
}

