/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.kidoz_banner;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.kidoz_banner.BannerViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;
import org.json.JSONObject;

public class BaseBanner
extends RelativeLayout {
    public static final String STYLE_ID = "style_id";
    public static final String SWAP_CONTENT_REFESH_RATE_SECONDS = "swapContentRefreshRateSec";
    public static final String LOUNCH_INTERSTITIAL_ON_OPEN = "lounchInterstitialOnOpen";
    protected KidozBannerListener mKidozBannerListener;
    protected JSONObject mProperties;
    protected boolean mIsWaitingToOpen = false;
    protected boolean mIsSmartBanner;
    protected boolean mIsOverrideUser;
    protected BannerViewPagerAdapter mAdapter;
    protected String mStyleId;
    private Utils.StaticHandler mStaticHandler;
    protected boolean mAllowClickHandling = true;

    public BaseBanner(Context context) {
        super(context);
    }

    public void setKidozBannerListener(KidozBannerListener kidozBannerListener) {
        this.mKidozBannerListener = kidozBannerListener;
    }

    public void setProperties(JSONObject properties) {
        this.mProperties = properties;
        if (this.mProperties != null) {
            this.mStyleId = this.mProperties.optString(STYLE_ID, null);
        }
        this.initView();
    }

    protected void initView() {
    }

    public void loadContent() {
    }

    protected boolean getIsCanOpen() {
        return false;
    }

    public void showBanner() {
        this.mIsWaitingToOpen = true;
        if (this.getVisibility() != 0 && this.getIsCanOpen()) {
            this.showInner();
        }
    }

    protected void showInner() {
    }

    protected void sendActionWidgetViewImpression() {
        EventManager.getInstance(this.getContext()).logEvent(this.getContext(), WidgetType.WIDGET_TYPE_BANNER.getStringValue(), this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, null, "Sponsored Content", "Widget View", "Banner View", false);
    }

    public void hideBanner() {
        this.setVisibility(8);
    }

    protected void autoOpen() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (KidozSDK.isInitialised() && !this.isInEditMode() && (visibility == 8 || visibility == 4)) {
            EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
        }
        this.mAllowClickHandling = true;
    }

    public void setIsSmartBanner(boolean isSmartBanner) {
        this.mIsSmartBanner = isSmartBanner;
        this.mIsOverrideUser = !this.mIsSmartBanner;
    }

    protected void onDetachedFromWindow() {
        this.getMyHandlerInstance().removeCallbacksAndMessages(null);
        super.onDetachedFromWindow();
    }

    protected Utils.StaticHandler getMyHandlerInstance() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return this.mStaticHandler;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.mAllowClickHandling = hasWindowFocus;
    }
}

