/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.content.Context;
import android.content.Intent;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.KidozAdActivity;
import de.greenrobot.event.EventBus;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class IntrstWrapper {
    private static IntrstWrapper mInstance = null;
    public Context mContext;
    private HtmlViewWrapper webView;
    private ContentLogicLoader mContentLogicLoader;
    private String mStyleId;
    private boolean mIsInitialLoadFinished = false;
    private boolean mIsAutoShowOnReady = false;
    private JSONObject mProperties;
    private Lock mLounchLock;
    private boolean mIsShowInProgress = false;
    private boolean mIsInvokeEvents = false;

    public static IntrstWrapper initInstance(Context context) {
        if (mInstance == null) {
            mInstance = new IntrstWrapper(context);
            return mInstance;
        }
        mInstance.validateIfPrepared();
        return mInstance;
    }

    protected IntrstWrapper(Context context) {
        this.mContext = context;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mLounchLock = new ReentrantLock();
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.initContentLogicLoader();
    }

    private void validateLayoutAndAssets() {
        SdkAPIManager.getSdkApiInstance(this.mContext).getStyle(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getValue(), new ApiResultCallback<Boolean>(){

            @Override
            public void onServerResult(ResultData<?> result) {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                    if (result.getData() != null) {
                        boolean isAssetsReady = (Boolean)result.getData();
                        if (isAssetsReady) {
                            IntrstWrapper.this.mProperties = DatabaseManager.getInstance(IntrstWrapper.this.mContext).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (IntrstWrapper.this.mProperties != null) {
                                IntrstWrapper.this.mStyleId = IntrstWrapper.this.mProperties.optString("style_id");
                            }
                            IntrstWrapper.this.prepareWebView();
                        } else {
                            this.onFailed();
                        }
                    }
                } else {
                    this.onFailed();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    private synchronized void prepareWebView() {
        this.webView = HtmlManager.getIntrstDefaultHtmlView(this.mContext);
        if (this.webView == null) {
            this.webView = HtmlManager.initIntrstDefaultHtmlView(this.mContext);
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    IntrstWrapper.this.mIsInitialLoadFinished = true;
                    if (IntrstWrapper.this.mIsAutoShowOnReady) {
                        IntrstWrapper.this.mIsAutoShowOnReady = false;
                        IntrstWrapper.this.mContentLogicLoader.loadContent(IntrstWrapper.this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), IntrstWrapper.this.mStyleId);
                    }
                }
            });
            PropertiesObj appConfig = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
            if (appConfig != null) {
                this.webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
            }
        } else {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            if (!this.mIsInitialLoadFinished) {
                PropertiesObj appConfig = DatabaseManager.getInstance(this.mContext).getConfigTable().loadAppProperties();
                if (appConfig != null) {
                    this.webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
                }
            } else if (this.mIsAutoShowOnReady) {
                this.mIsAutoShowOnReady = false;
                this.mContentLogicLoader.loadContent(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId);
            }
        }
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null && contentData.isHasContentToShow()) {
                    ContentItem contentItem = contentData.getContentDataItems().get(0);
                    if (contentItem.getContentType() == ContentType.HTML) {
                        IntrstWrapper.this.openAdActivity(contentItem);
                    } else {
                        IntrstWrapper.this.mIsShowInProgress = false;
                    }
                } else {
                    IntrstWrapper.this.mIsShowInProgress = false;
                }
                CookieManager.resetStorage(IntrstWrapper.this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
            }

            @Override
            public void onLoadContentFailed() {
                IntrstWrapper.this.mIsShowInProgress = false;
            }
        });
    }

    public synchronized void show(boolean invokeEvents) {
        if (!this.mIsShowInProgress) {
            this.mIsInvokeEvents = invokeEvents;
            if (this.mIsInitialLoadFinished) {
                this.mContentLogicLoader.loadContent(this.mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId);
            } else {
                this.mIsAutoShowOnReady = true;
            }
        }
    }

    private synchronized void openAdActivity(ContentItem contentItem) {
        if (contentItem.getIsNonDefaultHtml()) {
            this.openActivity(contentItem);
        } else {
            this.openActivity(contentItem);
        }
    }

    private void openActivity(ContentItem contentItem) {
        if (this.mLounchLock.tryLock()) {
            try {
                try {
                    if (this.mIsInvokeEvents) {
                        EventBus.getDefault().post((Object)InterstitialEvents.OPENED);
                    }
                    KidozAdActivity.itm = contentItem;
                    Intent intent = new Intent(this.mContext, KidozAdActivity.class);
                    intent.putExtra("styleId", this.mStyleId);
                    intent.addFlags(0x30020000);
                    this.mContext.startActivity(intent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.mLounchLock.unlock();
            }
        }
    }

    public void onEvent(WidgetEventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE) {
            this.mIsShowInProgress = false;
            if (this.mIsInvokeEvents) {
                EventBus.getDefault().post((Object)InterstitialEvents.CLOSED);
            }
        }
    }

    public void onEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    protected void validateIfPrepared() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (this.mIsInitialLoadFinished) {
            this.prepareWebView();
        }
    }

    public static enum InterstitialEvents {
        OPENED,
        CLOSED;

    }
}

