/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.html_view.BaseInterstitialDialog;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import de.greenrobot.event.EventBus;

public class MaximizedViewDialog
extends BaseInterstitialDialog {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private KidozTopBar mKidozTopBar;

    public MaximizedViewDialog(Context context, String widgetType, HtmlViewWrapper htmlViewWrapper) {
        super(context, widgetType, htmlViewWrapper);
        this.initTopBar();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mInnerContainer.setBackgroundColor(Color.parseColor((String)"#77000000"));
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                MaximizedViewDialog.this.closeDialog();
            }
        });
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mWebView.getLayoutParams();
        params.addRule(3, this.mKidozTopBar.getId());
        params.setMargins(0, -Utils.dpTOpx(this.getContext(), 7.0f), 0, 0);
    }

    @Override
    public void openDialog() {
        super.openDialog();
        WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)eventMessage);
        EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Open Dialog", "Web", false);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventMessage eventMsg = new EventMessage(EventMessage.MessageType.HTML_FULL_VIEW_CLOSE);
        eventMsg.setAdditionalParam(this.mWidgetType);
        EventBus.getDefault().post((Object)eventMsg);
        WidgetEventMessage widgetEventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
        EventBus.getDefault().post((Object)widgetEventMessage);
        EventManager.getInstance(this.getContext()).logEvent(this.getContext(), this.mWidgetType, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Close Dialog", "Web", false);
    }

    public void loadHtmlView(ContentItem contentItem) {
        this.mKidozTopBar.setTitle(contentItem.getName());
        this.mWebView.setData(contentItem);
        if (contentItem.getIsNonDefaultHtml()) {
            this.mWebView.loadHtml();
        } else {
            this.mWebView.requestFocusOn(true);
        }
    }

    public HtmlViewWrapper getInnerWebView() {
        return this.mWebView;
    }
}

