/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.feed_view;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.FeedFullView;
import java.io.Serializable;
import org.json.JSONObject;

public class FeedViewDialog
extends BaseDialog {
    public static final String TAG = FeedViewDialog.class.getSimpleName();
    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY_FV";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY_FV";
    private FeedFullView mFeedFullVeiw;
    private ContentData mContentData = null;
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mAllowClickHandling = true;
    private boolean mIsAutomaticInvocation = false;
    private JSONObject mPropertiesObject;
    public static final String EXIT_BUTTON = "exitButton";
    public static final String LOCK_ACTIVE_BUTTON = "lockActiveButton";
    public static final String LOCK_NOT_ACTIVE_BUTTON = "lockNotActiveButton";
    public static final String BOTTOM_BAR_BACKGROUND = "bottomBarBackground";
    public static final String BOTTOM_BAR_TITLE = "bottomBarTitle";
    public static final String TOP_BAR_BACKGROUND = "topBarBackground";
    public static final String TOP_BAR_TITLE = "topBarTitle";
    public static final String TOP_BAR_TITLE_COLOR = "topBarTitleColor";
    public static final String TOP_BAR_BACKGROUND_COLOR = "topBarBgColor";
    public static final String CONTENT_MAIN_BACKGROUND_COLOR_START = "mainBgColorStart";
    public static final String CONTENT_MAIN_BACKGROUND_COLOR_CENTER = "mainBgColorCenter";
    public static final String CONTENT_MAIN_BACKGROUND_COLOR_END = "mainBgColorEnd";

    public FeedViewDialog(Context context, IOnFeedViewEventListener listener, boolean automatic, JSONObject propertiesObject) {
        super(context, 16973834);
        this.mPropertiesObject = propertiesObject;
        this.mIsAutomaticInvocation = automatic;
        this.mOnInterstitialViewEventListener = listener;
        this.setCancelable(false);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                boolean result = true;
                if (event.getAction() == 0 && keyCode == 4) {
                    if (FeedViewDialog.this.mFeedFullVeiw != null && FeedViewDialog.this.mFeedFullVeiw.getViewBottomBar().isAboutViewVisible()) {
                        FeedViewDialog.this.mFeedFullVeiw.getViewBottomBar().hideAboutView();
                    } else {
                        if (FeedViewDialog.this.mOnInterstitialViewEventListener != null) {
                            FeedViewDialog.this.mOnInterstitialViewEventListener.onDismissView();
                        }
                        FeedViewDialog.this.closeDialog();
                    }
                }
                return result;
            }
        });
        if (savedInstanceState != null && savedInstanceState.containsKey(SAVE_ORIGINAL_ORIENTATION_KEY)) {
            this.mCurrentOrientationState = savedInstanceState.getInt(SAVE_ORIGINAL_ORIENTATION_KEY);
        } else {
            this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
            this.mCallingActivity.setRequestedOrientation(4);
        }
        if (this.mContentData == null && savedInstanceState != null && savedInstanceState.containsKey(SAVE_DATA_INSTANCE_KEY)) {
            this.mContentData = (ContentData)savedInstanceState.get(SAVE_DATA_INSTANCE_KEY);
        }
        this.mFeedFullVeiw = new FeedFullView((Context)this.mCallingActivity, this.mPropertiesObject);
        this.mFeedFullVeiw.setOnContentItemClickListener(new AbstractContentPanel.IOnContentItemClickListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int position) {
                JSONObject jsonObject;
                if (contentItem != null && contentItem.getContentType() != null && contentItem.getContentType() != ContentType.NONE && (jsonObject = DatabaseManager.getInstance(FeedViewDialog.this.getContext()).getConfigTable().loadProperties(FeedView.TAG)) != null && FeedViewDialog.this.mAllowClickHandling) {
                    FeedViewDialog.this.mAllowClickHandling = false;
                    ContentExecutionHandler.handleContentItemClick((Context)FeedViewDialog.this.mCallingActivity, contentItem, WidgetType.WIDGET_TYPE_FEED.getStringValue(), jsonObject.optString("style_id"), position, false, false, new ContentExecutionHandler.IOnHandleClickListener(){

                        @Override
                        public void onRestoreClick() {
                            FeedViewDialog.this.mAllowClickHandling = true;
                        }
                    });
                }
            }
        });
        this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        this.mFeedFullVeiw.setContentDataAndRefresh(this.mContentData);
        this.setContentView((View)this.mFeedFullVeiw);
        this.mFeedFullVeiw.showLoadingProgressView(true);
    }

    public void setContentData(ContentData contentData) {
        this.mContentData = contentData;
        if (this.mFeedFullVeiw != null) {
            this.mFeedFullVeiw.showLoadingProgressView(false);
            this.mFeedFullVeiw.setContentDataAndRefresh(this.mContentData);
        }
    }

    public void setOnCloseButtonClickListener(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
        if (this.mFeedFullVeiw != null) {
            this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (this.mContentData != null && bundle != null) {
            bundle.putSerializable(SAVE_DATA_INSTANCE_KEY, (Serializable)this.mContentData);
            bundle.putInt(SAVE_ORIGINAL_ORIENTATION_KEY, this.mCurrentOrientationState);
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        this.mContentData = null;
        super.closeDialog();
    }

    @Override
    public void openDialog() {
        if (KidozSDK.isInitialised()) {
            super.openDialog();
            Event event = new Event();
            if (this.mIsAutomaticInvocation) {
                event.addParameterToJsonObject("Open Type", "0");
            } else {
                event.addParameterToJsonObject("Open Type", "1");
            }
            JSONObject jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(FeedView.TAG);
            if (jsonObject != null) {
                EventManager.getInstance((Context)this.mCallingActivity).logEvent((Context)this.mCallingActivity, WidgetType.WIDGET_TYPE_FEED.getStringValue(), jsonObject.optString("style_id"), EventManager.LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Widget View", "Feed View", false);
            }
        }
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener) {
        if (onInterstitialViewEventListener != null) {
            this.mOnInterstitialViewEventListener = onInterstitialViewEventListener;
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.restoreUserOriginalOrientation();
    }

    @Override
    protected void onDialogWindowVisibilityChange(boolean isVisible) {
        super.onDialogWindowVisibilityChange(isVisible);
        if (!isVisible) {
            EventManager.getInstance(this.getContext()).startEventsSync(this.getContext());
        }
        this.mAllowClickHandling = true;
    }

    @Override
    protected void onDialogFocusChange(boolean isVisible) {
        super.onDialogFocusChange(isVisible);
        this.mAllowClickHandling = isVisible;
    }

    public static boolean parseFeedData(Context context, JSONObject jsonObject) {
        boolean result = false;
        if (jsonObject != null) {
            try {
                jsonObject.put(FeedView.TAG, (Object)TAG);
                JSONObject oldData = DatabaseManager.getInstance(context).getConfigTable().loadProperties(FeedView.TAG);
                result = AssetUtil.loadAsset(context, oldData, jsonObject, "feedButton");
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, EXIT_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_ACTIVE_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, LOCK_NOT_ACTIVE_BUTTON);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, BOTTOM_BAR_BACKGROUND);
                }
                if (result) {
                    result = AssetUtil.loadAsset(context, oldData, jsonObject, TOP_BAR_BACKGROUND);
                }
                if (result) {
                    DatabaseManager.getInstance(context).getConfigTable().insertProperties(FeedView.TAG, jsonObject);
                }
            }
            catch (Exception ex) {
                result = false;
                SDKLogger.printErrorLog(FeedView.TAG, "Error when trying to parse kidoz PanelView properties" + ex.getMessage());
            }
        }
        return result;
    }
}

