/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

public class DefaultPanelDrawable
extends Drawable {
    private static final float SIZE_RATIO = 0.54f;
    private static final float LINE_WIDTH = 0.258f;
    private Paint mXPaint;
    private Paint mBgPaint;
    private int mWidth;
    private int mHeight;
    private RectF mWhiteBackgroundRoundedRectF;
    private RectF mWhiteBackgroundRectF;
    private int mBaseColor;
    private int mXcolor;
    private PANEL_TYPE mPanelType;
    private PanelDrawableType mDrawableType;
    private Path mPath = new Path();

    public DefaultPanelDrawable(Context context, PANEL_TYPE panel_type, PanelDrawableType panelDrawableType) {
        float scaleFactor = ScreenUtils.getScaleFactor(context);
        this.mWidth = (int)((float)this.mWidth * scaleFactor);
        this.mHeight = (int)((float)this.mHeight * scaleFactor);
        this.mBaseColor = Color.parseColor((String)"#ffffff");
        this.mXcolor = Color.parseColor((String)"#cdffffff");
        this.mXPaint = new Paint(1);
        this.mXPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mXPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mXPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mXPaint.setPathEffect((PathEffect)new CornerPathEffect(15.0f));
        this.mXPaint.setColor(this.mXcolor);
        this.mXPaint.setShadowLayer(4.5f, 0.0f, 5.0f, 0x45000000);
        this.mXPaint.setDither(true);
        this.mBgPaint = new Paint(1);
        this.mBgPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mBgPaint.setColor(this.mBaseColor);
        this.mBgPaint.setDither(true);
        this.mPanelType = panel_type;
        this.mDrawableType = panelDrawableType;
        this.initRectF();
    }

    public void setAlpha(int alpha) {
        this.mBgPaint.setAlpha(alpha);
        this.mXPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBgPaint.setColorFilter(cf);
        this.mXPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
        this.initRectF();
    }

    private void initRectF() {
        float bottom;
        float right;
        float top;
        float left;
        switch (this.mPanelType) {
            case LEFT: {
                left = 0.0f;
                top = 0.0f;
                right = this.mWidth / 2;
                bottom = this.mHeight;
                this.mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case TOP: {
                left = 0.0f;
                top = 0.0f;
                right = this.mWidth;
                bottom = this.mHeight / 2;
                this.mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case RIGHT: {
                left = this.mWidth / 2;
                top = 0.0f;
                right = this.mWidth;
                bottom = this.mHeight;
                this.mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
                break;
            }
            case BOTTOM: {
                left = 0.0f;
                top = this.mHeight / 2;
                right = this.mWidth;
                bottom = this.mHeight;
                this.mWhiteBackgroundRectF = new RectF(left, top, right, bottom);
            }
        }
        left = 0.0f;
        top = 0.0f;
        right = this.mWidth;
        bottom = this.mHeight;
        this.mWhiteBackgroundRoundedRectF = new RectF(left, top, right, bottom);
        float centerX = (float)this.mWidth / 2.0f;
        float centerY = (float)this.mHeight / 2.0f;
        float size = (float)this.mWidth * 0.54f;
        float width = (float)this.mWidth * 0.258f;
        float offsetSize = size / 2.0f - width / 3.5f;
        float offsetWidth = width / 2.0f;
        this.mPath.moveTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPath.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPath.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPath.lineTo(centerX - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPath.lineTo(centerX - offsetWidth / 2.0f, centerY - offsetWidth / 2.0f - offsetSize);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f, centerY - offsetWidth / 2.0f - offsetSize);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f, centerY - offsetWidth / 2.0f);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f + offsetSize, centerY - offsetWidth / 2.0f);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f + offsetSize, centerY + offsetWidth / 2.0f);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPath.lineTo(centerX + offsetWidth / 2.0f, centerY + offsetWidth / 2.0f + offsetSize);
        this.mPath.lineTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f + offsetSize);
        this.mPath.lineTo(centerX - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
        this.mPath.lineTo(centerX - offsetSize - offsetWidth / 2.0f, centerY + offsetWidth / 2.0f);
    }

    public void draw(Canvas canvas) {
        float centerX = (float)this.mWidth / 2.0f;
        float centerY = (float)this.mHeight / 2.0f;
        this.mBgPaint.setColor(this.mBaseColor);
        this.mXPaint.setColor(this.mXcolor);
        float radius = 0.14084508f * (float)this.mWidth;
        canvas.drawRect(this.mWhiteBackgroundRectF, this.mBgPaint);
        canvas.drawRoundRect(this.mWhiteBackgroundRoundedRectF, radius, radius, this.mBgPaint);
        switch (this.mDrawableType) {
            case CLOSED_VIEW: {
                canvas.drawPath(this.mPath, this.mXPaint);
                break;
            }
            case OPENED_VIEW: {
                int saveCount = canvas.save();
                canvas.rotate(45.0f, centerX, centerY);
                canvas.drawPath(this.mPath, this.mXPaint);
                canvas.restoreToCount(saveCount);
                break;
            }
        }
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        this.initRectF();
    }

    public void setBaseColor(int baseColor) {
        this.mBaseColor = baseColor;
        this.mBgPaint.setColor(baseColor);
    }

    public static enum PanelDrawableType {
        CLOSED_VIEW,
        OPENED_VIEW;

    }
}

