/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;

public class AboutKidozView
extends RelativeLayout {
    private final String TAG = AboutKidozView.class.getSimpleName();
    private int mWidth;
    private int mHeight;
    private Paint mLogoPaint;
    private RectF mRectF;

    public AboutKidozView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.initImageParameters();
        this.initPaints();
        this.initRectF();
        this.initTitle();
    }

    private void initTitle() {
        float TEXT_SIZE = 0.14705883f;
        TextView title = new TextView(this.getContext());
        title.setSingleLine(true);
        title.setTextColor(Color.parseColor((String)"#04a0e1"));
        title.setTextSize(0, (float)((int)(TEXT_SIZE * (float)this.mHeight)));
        title.setEllipsize(TextUtils.TruncateAt.END);
        title.setShadowLayer(2.0f, 1.0f, 1.0f, Color.parseColor((String)"#666666"));
        title.setTypeface(null, 1);
        title.setText((CharSequence)"KIDOZ");
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)title, (ViewGroup.LayoutParams)params);
    }

    private void initRectF() {
        float left = 0.0f * (float)this.mWidth;
        float top = 0.0f * (float)this.mHeight;
        float right = 1.0f * (float)this.mWidth;
        float bottom = 0.18382353f * (float)this.mHeight;
        this.mRectF = new RectF(left, top, right, bottom);
    }

    private void initImageParameters() {
        float scaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = (int)(154.0f * scaleFactor);
        this.mHeight = (int)(200.0f * scaleFactor);
    }

    private void initPaints() {
        this.mLogoPaint = new Paint(1);
        this.mLogoPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.setLayerType(1, this.mLogoPaint);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        float TEXT_WIDTH = 1.0f;
        float MARGIN_LEFT = 0.21904762f;
        float MARGIN_TOP = 0.5882353f;
        this.getChildAt(0).layout((int)(MARGIN_LEFT * (float)this.mWidth), (int)(MARGIN_TOP * (float)this.mHeight), (int)(TEXT_WIDTH * (float)this.mWidth), this.getMeasuredHeight());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float left = 0.0f * (float)this.mWidth;
        float top = 0.09558824f * (float)this.mHeight;
        float right = 1.0f * (float)this.mWidth;
        float bottom = 1.0f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#ffffff"));
        canvas.drawRect(left, top, right, bottom, this.mLogoPaint);
        float radius = 0.114285715f * (float)this.mWidth;
        canvas.drawRoundRect(this.mRectF, radius, radius, this.mLogoPaint);
        radius = 0.18571429f * (float)this.mWidth;
        float centerX = 0.5f * (float)this.mWidth;
        float centerY = 0.22426471f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#f8de46"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
        radius = 0.15714286f * (float)this.mWidth;
        centerX = 0.2904762f * (float)this.mWidth;
        centerY = 0.43014705f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#e13333"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
        radius = 0.15714286f * (float)this.mWidth;
        centerX = 0.7f * (float)this.mWidth;
        centerY = 0.43014705f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#4aaed3"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
        radius = 0.15714286f * (float)this.mWidth;
        centerX = 0.2904762f * (float)this.mWidth;
        centerY = 0.28308824f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#e6f8a850"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
        radius = 0.15714286f * (float)this.mWidth;
        centerX = 0.7f * (float)this.mWidth;
        centerY = 0.28308824f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#e6b0d63a"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
        radius = 0.15714286f * (float)this.mWidth;
        centerX = 0.5f * (float)this.mWidth;
        centerY = 0.41911766f * (float)this.mHeight;
        this.mLogoPaint.setColor(Color.parseColor((String)"#ffffff"));
        canvas.drawCircle(centerX, centerY, radius, this.mLogoPaint);
    }
}

