/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.assets_handling.ImageAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.assets_handling.StringAssetsUtils;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkRequestType;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.structure.ContentData;
import java.io.BufferedInputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Response;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
class BaseAPIManager
extends BaseConnectionClient {
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap();

    BaseAPIManager() {
    }

    @TargetApi(value=11)
    protected void startServerConnection(Context context, String serverUrl, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog, boolean removePrevRequest) {
        if (removePrevRequest) {
            try {
                if (this.runningTaskList.containsKey((Object)requestType) && this.runningTaskList.get((Object)requestType) != null) {
                    RequestAsyncTask task = this.runningTaskList.get((Object)requestType);
                    if (task.getStatus() != AsyncTask.Status.FINISHED) {
                        task.cancel(true);
                        task.closeCurrentConnection();
                    } else {
                        this.runningTaskList.remove((Object)requestType);
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
            }
        }
        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, serverUrl, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback, devLog);
        this.runningTaskList.put(requestType, requestAsyncTask);
        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute(new Void[0]);
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public void cancelAllRunningRequests() {
        for (Map.Entry<SdkRequestType, RequestAsyncTask> entry : this.runningTaskList.entrySet()) {
            RequestAsyncTask asyncTask = entry.getValue();
            if (asyncTask == null || asyncTask.getStatus() != AsyncTask.Status.RUNNING || asyncTask.getStatus() != AsyncTask.Status.PENDING) continue;
            asyncTask.cancel(true);
            asyncTask.closeCurrentConnection();
        }
        this.runningTaskList.clear();
    }

    private ResultData<?> parseWebServiceResponse(Context context, SdkRequestType sdkRequestType, String dataResponce, boolean devLog) {
        ResultData<ContentData> webServiceResult = null;
        if (sdkRequestType != null && context != null) {
            switch (sdkRequestType) {
                case LOAD_SDK_CONTENT: {
                    ContentData contentData = new ContentData();
                    contentData.decodeResponse(dataResponce);
                    ResultData<ContentData> resultData = new ResultData<ContentData>();
                    resultData.setData(contentData);
                    webServiceResult = resultData;
                    if (!devLog) break;
                    if (contentData.getContentDataItems() == null) {
                        Log.d((String)"[KIDOZ SDK]", (String)"Error : Unable to get FeedView data!");
                        break;
                    }
                    if (contentData.getContentDataItems().isEmpty()) {
                        Log.d((String)"[KIDOZ SDK]", (String)"Error : FeedView data list is Empty!");
                        break;
                    }
                    Log.d((String)"[KIDOZ SDK]", (String)("Success : Received " + contentData.getContentDataItems() + "FeedView data items!"));
                    break;
                }
                case VALIDATE_SDK: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<PropertiesObj> resultData = new ResultData<PropertiesObj>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful()) {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                            resultData.setData(propertiesObj);
                        }
                        webServiceResult = resultData;
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                    }
                    break;
                }
                case GET_SDK_RESOURCES: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<Boolean> resultData = new ResultData<Boolean>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful()) {
                            boolean isSoundsAssetsSynced;
                            boolean isParentalLockAssetsSynced;
                            boolean isImagesAssetsSynced;
                            StringAssetsUtils.parseStrings(context, dataResponce);
                            SDKLogger.printDebbugLog(TAG, ">>>>Get SDK assets");
                            String isAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, "IMAGE_ASSETS_SYNCED_FLAG");
                            if (isAssetsSyncedFlag == null) {
                                SDKLogger.printDebbugLog(TAG, ">>>>Downloading image assets");
                                isImagesAssetsSynced = ImageAssetsUtils.parseAssets(context, dataResponce);
                                if (isImagesAssetsSynced) {
                                    SDKLogger.printDebbugLog(TAG, ">>>>All image assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, "IMAGE_ASSETS_SYNCED_FLAG", "IMAGE_ASSETS_SYNCED_FLAG");
                                } else {
                                    SDKLogger.printDebbugLog(TAG, ">>>>Not all image assets downloaded");
                                }
                            } else {
                                SDKLogger.printDebbugLog(TAG, ">>>>Image assets already downloaded");
                                isImagesAssetsSynced = true;
                            }
                            String isParentalLockAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ASSETS_SYNCED_FLAG");
                            if (isParentalLockAssetsSyncedFlag == null) {
                                SDKLogger.printDebbugLog(TAG, ">>>>Downloading parental lock assets");
                                isParentalLockAssetsSynced = ImageAssetsUtils.parseLockIcons(context, dataResponce);
                                if (isParentalLockAssetsSynced) {
                                    SDKLogger.printDebbugLog(TAG, ">>>>All parental lock assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, "PARENTAL_LOCK_ASSETS_SYNCED_FLAG", "PARENTAL_LOCK_ASSETS_SYNCED_FLAG");
                                } else {
                                    SDKLogger.printDebbugLog(TAG, ">>>>Not all parental lock assets downloaded");
                                }
                            } else {
                                SDKLogger.printDebbugLog(TAG, ">>>>Parental lock assets already downloaded");
                                isParentalLockAssetsSynced = true;
                            }
                            String isSoundsAssetsSyncedFlag = SharedPreferencesUtils.loadSharedPreferencesData(context, "SOUND_ASSETS_SYNCED_FLAG");
                            if (isSoundsAssetsSyncedFlag == null) {
                                SDKLogger.printDebbugLog(TAG, ">>>>Downloading sound assets");
                                isSoundsAssetsSynced = SoundAssetsUtils.parseSounds(context, dataResponce);
                                if (isSoundsAssetsSynced) {
                                    SDKLogger.printDebbugLog(TAG, ">>>>All sound assets downloaded");
                                    SharedPreferencesUtils.saveSharedPreferencesData(context, "SOUND_ASSETS_SYNCED_FLAG", "SOUND_ASSETS_SYNCED_FLAG");
                                } else {
                                    SDKLogger.printDebbugLog(TAG, ">>>>Not all sound assets downloaded");
                                }
                            } else {
                                SDKLogger.printDebbugLog(TAG, ">>>>Sound assets already downloaded");
                                isSoundsAssetsSynced = true;
                            }
                            resultData.setData(isImagesAssetsSynced && isParentalLockAssetsSynced && isSoundsAssetsSynced);
                        }
                        webServiceResult = resultData;
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse get SDK resources: " + ex.getMessage());
                    }
                    break;
                }
                case GET_STYLE: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<Boolean> resultData = new ResultData<Boolean>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful()) {
                            resultData.setData(AssetUtil.parseAndSaveAssets(context, dataResponce));
                        }
                        webServiceResult = resultData;
                        break;
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse get style: " + ex.getMessage());
                    }
                }
            }
        }
        return webServiceResult;
    }

    public void cancelRequest(SdkRequestType requestType) {
        if (this.runningTaskList.containsKey((Object)requestType) && this.runningTaskList.get((Object)requestType) != null && this.runningTaskList.get((Object)requestType).getStatus() != AsyncTask.Status.FINISHED) {
            this.runningTaskList.get((Object)requestType).cancel(true);
            this.runningTaskList.get((Object)requestType).closeCurrentConnection();
        }
    }

    class RequestAsyncTask
    extends AsyncTask<Void, Void, ResultData<?>> {
        private BaseConnectionClient.CONNECTION_TYPE restRequestType = BaseConnectionClient.CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Call mCall;
        private Context mContext;
        private boolean mDeveloperLogging = false;
        private String mServerUrl;

        public RequestAsyncTask(Context context, String serverUrl, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog) {
            this.mContext = context;
            this.restRequestType = type;
            this.sdkRequestType = requestType;
            this.mContentValues = contentValues;
            this.mResultCallback = resultCallback;
            this.numOfReconnectionsOnFail = numOfReconnecsOnFail;
            this.mDeveloperLogging = devLog;
            this.mServerUrl = serverUrl;
        }

        protected ResultData<?> doInBackground(Void ... params) {
            String dataResponce = null;
            ResultData webServiceResult = null;
            int mReconnectionTries = 0;
            if (!this.isCancelled()) {
                Response response = null;
                while (mReconnectionTries <= this.numOfReconnectionsOnFail) {
                    block22: {
                        ++mReconnectionTries;
                        if (this.isCancelled()) break;
                        try {
                            if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.POST) {
                                SDKLogger.printPostRequestDebugLog(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                                this.mCall = BaseConnectionClient.makePostConnection(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                                if (this.mCall != null) {
                                    response = this.mCall.execute();
                                }
                            } else if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.GET) {
                                SDKLogger.printGetRequestDebugLog(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                                this.mCall = BaseConnectionClient.makeGetConnection(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                                if (this.mCall != null) {
                                    response = this.mCall.execute();
                                }
                            }
                        }
                        catch (Exception e) {
                            if (this.sdkRequestType == null) break block22;
                            SDKLogger.printErrorLog(" \n IO Exception On [" + this.sdkRequestType.name() + "] request! \n" + e.getMessage());
                        }
                    }
                    if (response != null) {
                        if (this.isCancelled()) break;
                        if (response.isSuccessful()) {
                            try {
                                SDKLogger.printDebbugLog(" \n Successful connection ! , Code :  " + response.code());
                                dataResponce = StreamToStringConverter.readStream(new BufferedInputStream(response.body().byteStream()), this, true);
                                response.body().close();
                                break;
                            }
                            catch (Exception e) {
                                SDKLogger.printErrorLog(" \n Unable to convertByte Stream to String! : \n\n" + e.getMessage());
                            }
                        } else {
                            SDKLogger.printErrorLog(" \n Server connectivity Error!  Code : " + response.code());
                        }
                    }
                    try {
                        if (this.isCancelled()) break;
                        Thread.sleep(300 * mReconnectionTries * 2);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (this.sdkRequestType != null) {
                SDKLogger.printResponse(dataResponce, this.sdkRequestType.name());
            }
            if (this.isCancelled()) {
                return null;
            }
            if (dataResponce != null) {
                if (!this.isCancelled() && this.mContext != null) {
                    try {
                        webServiceResult = BaseAPIManager.this.parseWebServiceResponse(this.mContext, this.sdkRequestType, dataResponce, this.mDeveloperLogging);
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse service response: " + ex.getMessage());
                    }
                }
                return webServiceResult;
            }
            return null;
        }

        protected void onPostExecute(ResultData<?> result) {
            if (!this.isCancelled()) {
                if (result == null) {
                    if (this.mResultCallback != null) {
                        this.mResultCallback.onFailed();
                    }
                } else if (this.mResultCallback != null) {
                    this.mResultCallback.onServerResult(result);
                }
            }
            BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.sdkRequestType != null && BaseAPIManager.this.runningTaskList != null) {
                BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
            }
        }

        public void closeCurrentConnection() {
            if (this.mCall != null && !this.mCall.isCanceled()) {
                this.mCall.cancel();
            }
        }

        public String getRequestTag() {
            return this.sdkRequestType.name();
        }
    }
}

