/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class SdkReceiver
extends BroadcastReceiver {
    private final String TAG = SdkReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        String packageName;
        String action;
        if (intent != null && (action = intent.getAction()) != null && action.equalsIgnoreCase("android.intent.action.PACKAGE_ADDED") && intent.getData() != null && (packageName = intent.getData().getSchemeSpecificPart()) != null) {
            SDKLogger.printWarningLog("--------------------+++++++  INSTALL RECEIVER LAUNCHED ++++++ ------------------");
            this.updateInstallEvent(context, packageName);
        }
    }

    private void updateInstallEvent(Context context, String packageName) {
        IsEventRecord record;
        int MAX_ACCEPTABLE_INSTALL_INTERVAL = 86400000;
        DatabaseManager databaseManager = DatabaseManager.getInstance(context);
        if (databaseManager != null && (record = databaseManager.getIsEventTable().getRecord(packageName)) != null) {
            long setTime = -1L;
            try {
                setTime = Long.parseLong(record.getTimeStamp());
            }
            catch (NumberFormatException e) {
                setTime = -1L;
            }
            if (setTime != -1L && System.currentTimeMillis() - setTime < 86400000L) {
                EventManager.getInstance(context).logSponsoredContentInstallEvent(context, record.getWidgetType(), record.getStyleId(), record.getPackageName(), record.getAdvertiserId(), record.getPackageName(), record.getPositionIndex(), false);
                EventManager.getInstance(context).startEventsSync(context);
                if (ConstantDef.DGM) {
                    SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!!");
                    SDKLogger.printWarningLog("\ngetPackageName : " + record.getPackageName());
                    SDKLogger.printWarningLog("\ngetTimeStamp : " + record.getTimeStamp());
                    SDKLogger.printWarningLog("\ngetItemType : " + record.getContentType());
                    SDKLogger.printWarningLog("\ngetLocationInFeed : " + record.getPositionIndex());
                    SDKLogger.printWarningLog("\ngetApppName : " + record.getName());
                    SDKLogger.printWarningLog("\ngetAdvertiser ID : " + record.getAdvertiserId());
                    SDKLogger.printWarningLog("\ngetWidgetType : " + record.getWidgetType());
                    SDKLogger.printWarningLog("\ngetStyleId : " + record.getStyleId());
                }
            }
            databaseManager.getIsEventTable().deleteRecord(packageName);
        }
    }
}

