/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.ui_views.KidozTopBar;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;

public class WebPlayerView
extends FrameLayout {
    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor((String)"#36a7ec");
    private static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.25f;
    private RelativeLayout mInnerContainer;
    private KidozTopBar mKidozTopBar;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;
    private View.OnClickListener mCloseBtnClickListener = null;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;
    private String mWidgetType;
    private LoadingProgressView mLoadingProgressView;

    public WebPlayerView(Context context, WebPlayerType webPlayerType, String widgetType) {
        super(context);
        this.mWidgetType = widgetType;
        this.mWebPlayerType = webPlayerType;
        this.initiateView();
    }

    private void initiateView() {
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.initWebView();
        this.initTopBar();
        if (this.mWebPlayerType != null && this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
            this.mKidozWebView.setAlpha(0.0f);
            this.mInnerContainer.setBackgroundColor(Color.parseColor((String)"#77000000"));
            this.mKidozTopBar.setVisibility(4);
            this.mLoadingProgressView = new LoadingProgressView(this.getContext());
            Point point = Utils.getScreenSize(this.getContext());
            int size = (int)((float)Math.min(point.x, point.y) * 0.25f);
            RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
            prParams.addRule(13);
            this.mInnerContainer.addView((View)this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
            this.mLoadingProgressView.startLoadingAnimation();
        } else {
            this.mInnerContainer.setBackgroundColor(-1);
        }
    }

    private void initTopBar() {
        this.mKidozTopBar = new KidozTopBar(this.getContext(), true, this.mWidgetType, null);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                if (WebPlayerView.this.mCloseBtnClickListener != null) {
                    WebPlayerView.this.mCloseBtnClickListener.onClick(view);
                }
            }
        });
        this.mKidozTopBar.showParentalLockIcon(false);
        this.mInnerContainer.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
    }

    private void initWebView() {
        int paddingTop;
        this.mKidozWebView = new KidozWebView(this.getContext(), this.mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        Point point = Utils.getScreenSize(this.getContext());
        params.topMargin = paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mInnerContainer.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)params);
        this.mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener(){

            @Override
            public void onLounch() {
                if (WebPlayerView.this.mRemoveViewRequestListener != null) {
                    WebPlayerView.this.mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId, String title) {
        this.mKidozWebView.loadWebUrl(url, googlePlayAppId);
        if (title != null) {
            this.mKidozTopBar.setTitle(title);
        } else {
            this.mKidozTopBar.setTitle("");
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopLoading();
        }
    }

    public void setOnCloseButtonClickListenr(View.OnClickListener clickListener) {
        this.mCloseBtnClickListener = clickListener;
    }

    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener) {
        this.mRemoveViewRequestListener = listener;
    }

    public void releaseAndcloseView() {
        if (this.mKidozWebView != null) {
            this.mKidozWebView.stopAndReleaseWebView();
        }
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public static interface IOnRemoveViewRequestListener {
        public void onRemoveView();
    }
}

