/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebPlayerView;
import com.kidoz.sdk.api.structure.ContentItem;
import de.greenrobot.event.EventBus;
import java.io.Serializable;

public class WebPlayerDialog
extends BaseDialog {
    private static final String TAG = WebPlayerDialog.class.getSimpleName();
    private static final int WEB_PLAYER_RESOURCE_ID = 1;
    private static final String CONTENT_ITEM_SAVE_STATE_KEY = "CONTENT_ITEM_SAVE_STATE_KEY_WP";
    private static final String WEB_PLAYER_TYPE_SAVE_STATE_KEY = "WEB_PLAYER_TYPE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_STATE_SAVE_STATE_KEY = "ORIENTATION_STATE_SAVE_STATE_KEY_WP";
    private static final String ORIENTATION_MODIFY_SAVE_STATE_KEY = "ORIENTATION_MODIFY_SAVE_STATE_KEY_WP";
    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;
    private boolean mAllowOrientationModify = false;
    private String mWidgetType = null;
    private String mStyleId = null;

    public WebPlayerDialog(Context context, ContentItem contentItem, String widgetType, String styleId, WebPlayerType webPlayerType, boolean allowOrientationModification) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.mContentItem = contentItem;
        this.mWebPlayerType = webPlayerType;
        this.mAllowOrientationModify = allowOrientationModification;
        this.mWidgetType = widgetType;
        this.mStyleId = styleId;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mAllowOrientationModify = savedInstanceState.getBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY);
        }
        if (this.mAllowOrientationModify) {
            if (savedInstanceState != null && savedInstanceState.containsKey(ORIENTATION_STATE_SAVE_STATE_KEY)) {
                this.mCurrentOrientationState = savedInstanceState.getInt(ORIENTATION_STATE_SAVE_STATE_KEY);
            } else if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
                this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
                this.mCallingActivity.setRequestedOrientation(4);
            }
        }
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(CONTENT_ITEM_SAVE_STATE_KEY)) {
                this.mContentItem = (ContentItem)((Object)savedInstanceState.getSerializable(CONTENT_ITEM_SAVE_STATE_KEY));
            }
            this.mWebPlayerType = (WebPlayerType)((Object)savedInstanceState.getSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY));
        }
        this.mWebPlayerView = new WebPlayerView((Context)this.mCallingActivity, this.mWebPlayerType, this.mWidgetType);
        if (this.mContentItem != null) {
            this.mWebPlayerView.loadWebUrl(this.mContentItem.getData(), this.mContentItem.getId(), this.mContentItem.getName());
        }
        this.mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener(){

            public void onClick(View v) {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener(){

            @Override
            public void onRemoveView() {
                WebPlayerDialog.this.closeDialog();
            }
        });
        this.setContentView((View)this.mWebPlayerView);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
            }
        });
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (bundle != null) {
            bundle.putSerializable(WEB_PLAYER_TYPE_SAVE_STATE_KEY, (Serializable)((Object)this.mWebPlayerType));
            bundle.putSerializable(ORIENTATION_STATE_SAVE_STATE_KEY, (Serializable)Integer.valueOf(this.mCurrentOrientationState));
            bundle.putBoolean(ORIENTATION_MODIFY_SAVE_STATE_KEY, this.mAllowOrientationModify);
        }
        return bundle;
    }

    @Override
    public void closeDialog() {
        super.closeDialog();
    }

    public void dismiss() {
        super.dismiss();
        if (this.mWebPlayerType != null) {
            switch (this.mWebPlayerType) {
                case ONLINE_GAME: {
                    WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
                    EventBus.getDefault().post((Object)eventMessage);
                    break;
                }
                case WEB_BROWSER: {
                    WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_CLOSE, WidgetType.createFromString(this.mWidgetType));
                    EventBus.getDefault().post((Object)eventMessage);
                    break;
                }
            }
        }
    }

    @Override
    public void openDialog() {
        super.openDialog();
        String activityName = "";
        String action = "";
        switch (this.mWebPlayerType) {
            case EXTERNAL_LINK: {
                activityName = "Web Player External Link";
                action = "Web External Link View";
                break;
            }
            case ONLINE_GAME: {
                WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
                EventBus.getDefault().post((Object)eventMessage);
                activityName = "Web Player Online Game";
                action = "Online Games Player View";
                break;
            }
            case WEB_BROWSER: {
                WidgetEventMessage eventMessage = new WidgetEventMessage(EventMessage.MessageType.PLAYER_OPEN, WidgetType.createFromString(this.mWidgetType));
                EventBus.getDefault().post((Object)eventMessage);
                activityName = "Web Player Web Browser";
                action = "Website View";
                break;
            }
        }
        try {
            EventManager.getInstance(this.getContext()).logEventWithDuration(this.getContext(), this.mWidgetType, this.mStyleId, EventManager.LOG_NORMAL_LEVEL, 1, EventManager.LOG_CLOSE_RESOURCE_LEVEL, "Web Player", action, this.mContentItem.getName(), this.mContentItem.getId(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mWebPlayerView != null) {
            try {
                this.mWebPlayerView.releaseAndcloseView();
            }
            catch (Exception ex) {
                SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
        if (this.mAllowOrientationModify) {
            this.restoreUserOriginalOrientation();
        }
        EventManager.getInstance(this.getContext()).logEventWithDurationEnd(this.getContext(), this.mWidgetType, this.mStyleId, 1, false);
    }
}

