/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import com.kidoz.sdk.api.dialogs.WebDialog.VideoEnabledWebView;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.players.video_player.VideoJavaScriptInterface;
import java.io.File;

public class VideoManager {
    private static VideoManager sVideoManager = null;
    private VideoEnabledWebView mIFrameVideo;
    private VideoJavaScriptInterface mVideoJavaScriptInterface;

    protected VideoManager() {
    }

    private void initIFrameVideo(Context context, String url) {
        File path;
        String state;
        this.mIFrameVideo = new VideoEnabledWebView(context);
        this.mIFrameVideo.setVerticalScrollBarEnabled(false);
        this.mIFrameVideo.setHorizontalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.mIFrameVideo.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT > 16) {
            this.mIFrameVideo.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.mIFrameVideo.setLayerType(2, null);
        }
        if ("mounted".equals(state = Environment.getExternalStorageState()) && (path = context.getCacheDir()) != null) {
            this.mIFrameVideo.getSettings().setAppCachePath(path.toString() + "/VideoCache");
        }
        this.mIFrameVideo.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.mIFrameVideo.getSettings().setCacheMode(-1);
        this.mIFrameVideo.getSettings().setLoadWithOverviewMode(true);
        this.mIFrameVideo.getSettings().setJavaScriptEnabled(true);
        this.mIFrameVideo.getSettings().setUseWideViewPort(true);
        this.mIFrameVideo.getSettings().setAppCacheEnabled(true);
        this.mIFrameVideo.getSettings().setSupportZoom(false);
        this.mIFrameVideo.setWebChromeClient(new WebChromeClient());
        this.mVideoJavaScriptInterface = new VideoJavaScriptInterface();
        this.mIFrameVideo.addJavascriptInterface(this.mVideoJavaScriptInterface, "VideoJavaScriptInterface");
        this.mIFrameVideo.loadUrl("http://cdn.kidoz.net/video_player/video_player_sdk.html");
    }

    public static VideoManager getInstance(Context context) {
        if (sVideoManager == null) {
            sVideoManager = new VideoManager();
            PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
            if (appConfig != null) {
                sVideoManager.initIFrameVideo(context, appConfig.getDefaultYouTubePlayerHtmlLink());
            } else {
                sVideoManager.initIFrameVideo(context, "http://cdn.kidoz.net/video_player/video_player_sdk.html");
            }
        }
        return sVideoManager;
    }

    public VideoEnabledWebView getIFrameVideo() {
        ViewParent parent;
        if (this.mIFrameVideo != null && (parent = this.mIFrameVideo.getParent()) != null) {
            ((ViewGroup)parent).removeView((View)this.mIFrameVideo);
        }
        return this.mIFrameVideo;
    }

    public VideoJavaScriptInterface getVideoJavaScriptInterface() {
        return this.mVideoJavaScriptInterface;
    }
}

