/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.interfaces;

import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import de.greenrobot.event.EventBus;

public class KidozPlayerEventHelper {
    private WidgetType mWidgetType;
    private IPlayerListener iPlayerListener;

    public KidozPlayerEventHelper(IPlayerListener listener, WidgetType widgetType) {
        this.iPlayerListener = listener;
        this.mWidgetType = widgetType;
    }

    public void register() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void unRegister() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public void onEvent(WidgetEventMessage event) {
        if (event != null && event.getWidgetType() == this.mWidgetType && this.iPlayerListener != null) {
            switch (event.getMessageType()) {
                case PLAYER_OPEN: {
                    this.iPlayerListener.onOpen();
                    break;
                }
                case PLAYER_CLOSE: {
                    this.iPlayerListener.onClose();
                }
            }
        }
    }

    public static interface IPlayerListener {
        public void onOpen();

        public void onClose();
    }
}

