/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import org.json.JSONException;
import org.json.JSONObject;

public class PropertiesObj {
    public static final String DEFAULT_YOUTUBE_HTML_URL = "http://cdn.kidoz.net/video_player/video_player_sdk.html";
    private static final String CONFIG_VERSION_KEY = "configuration_version";
    private static final String IS_PARENTAL_LOCK_KEY = "is_parental_lock_activated";
    private static final String FEED_BUTTON_VIEW_URL_KEY = "btnUrl";
    private static final String FEED_BUTTON_ANIMATION_TYPE_KEY = "btnAnimation";
    private static final String PANEL_BUTTON_URL_KEY = "panelBtn";
    private static final String PANEL_BUTTON_CLOSE_URL_KEY = "panelBtnClose";
    private static final String PANEL_BUTTON_ANIMATION_TYPE_KEY = "panelBtnAnimation";
    private static final String PANEL_BACKGROUND_COLOR_KEY = "panelBgClr";
    private static final String SDK_STYLE_VERSION_KEY = "style";
    private static final String PANEL_BUTTON_SCALE_PERCENTAGE_KEY = "panelBtnScale";
    private static final String FAMILY_PANEL_ANIMATION_URL_KEY = "familyPanelAnimation";
    private static final String HTML_LOADER_DEFAULT_URL_KEY = "htmlLoaderDefaultURL";
    private static final String YOUTUBE_PLAYER_DEFAULT_HTML_KEY = "defaultHTMLPlayerURL";
    JSONObject mProperties = new JSONObject();

    public PropertiesObj(JSONObject data) {
        this.mProperties = data;
    }

    public JSONObject getData() {
        return this.mProperties;
    }

    public int getConfigVersion() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(CONFIG_VERSION_KEY, 1);
        }
        return result;
    }

    public boolean isParentalLockActive() {
        boolean result = false;
        if (this.mProperties != null) {
            result = this.mProperties.optBoolean(IS_PARENTAL_LOCK_KEY, false);
        }
        return result;
    }

    public String getFeedButtonUrl() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(FEED_BUTTON_VIEW_URL_KEY);
        }
        return result;
    }

    public String getPanelButtonUrl() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(PANEL_BUTTON_URL_KEY);
        }
        return result;
    }

    public String getFamilyPanelAnimationUrl() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(FAMILY_PANEL_ANIMATION_URL_KEY);
        }
        return result;
    }

    public String getPanelButtonCloseUrl() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(PANEL_BUTTON_CLOSE_URL_KEY);
        }
        return result;
    }

    public int getFeedButtonAnimationType() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(FEED_BUTTON_ANIMATION_TYPE_KEY, 0);
        }
        return result;
    }

    public int getPanelButtonAnimationType() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(PANEL_BUTTON_ANIMATION_TYPE_KEY, 0);
        }
        return result;
    }

    public String getPanelBackGroundColor() {
        String result = null;
        if (this.mProperties != null) {
            result = this.mProperties.optString(PANEL_BACKGROUND_COLOR_KEY, "#ffffff");
        }
        return result;
    }

    public double getPanelButtonScaleValue() {
        double result = 0.0;
        if (this.mProperties != null) {
            result = this.mProperties.optDouble(PANEL_BUTTON_SCALE_PERCENTAGE_KEY, (double)0.15f);
        }
        return result;
    }

    public int getSdkStyleVersion() {
        int result = -1;
        if (this.mProperties != null) {
            result = this.mProperties.optInt(SDK_STYLE_VERSION_KEY, 0);
        }
        return result;
    }

    public JSONObject getProperties() {
        return this.mProperties;
    }

    public String getHtmlLoaderDefaultLink() {
        String result = "";
        if (this.mProperties != null) {
            result = this.mProperties.optString(HTML_LOADER_DEFAULT_URL_KEY, "");
        }
        return result;
    }

    public String getDefaultYouTubePlayerHtmlLink() {
        String result = DEFAULT_YOUTUBE_HTML_URL;
        if (this.mProperties != null) {
            result = this.mProperties.optString(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, result);
        }
        return result;
    }

    public void setConfigVersion(int version) {
        try {
            this.mProperties.put(CONFIG_VERSION_KEY, version);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateConfigFromData(PropertiesObj data) {
        try {
            if (data != null) {
                this.mProperties.put(FEED_BUTTON_ANIMATION_TYPE_KEY, data.getFeedButtonAnimationType());
                this.mProperties.put(FEED_BUTTON_VIEW_URL_KEY, (Object)data.getFeedButtonUrl());
                this.mProperties.put(IS_PARENTAL_LOCK_KEY, data.isParentalLockActive());
                this.mProperties.put(PANEL_BUTTON_ANIMATION_TYPE_KEY, data.getPanelButtonAnimationType());
                this.mProperties.put(PANEL_BUTTON_URL_KEY, (Object)data.getPanelButtonUrl());
                this.mProperties.put(FAMILY_PANEL_ANIMATION_URL_KEY, (Object)data.getFamilyPanelAnimationUrl());
                this.mProperties.put(PANEL_BUTTON_CLOSE_URL_KEY, (Object)data.getPanelButtonCloseUrl());
                this.mProperties.put(PANEL_BACKGROUND_COLOR_KEY, (Object)data.getPanelBackGroundColor());
                this.mProperties.put(SDK_STYLE_VERSION_KEY, data.getSdkStyleVersion());
                this.mProperties.put(PANEL_BUTTON_SCALE_PERCENTAGE_KEY, data.getPanelButtonScaleValue());
                this.mProperties.put(HTML_LOADER_DEFAULT_URL_KEY, (Object)data.getHtmlLoaderDefaultLink());
                this.mProperties.put(YOUTUBE_PLAYER_DEFAULT_HTML_KEY, (Object)data.getDefaultYouTubePlayerHtmlLink());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

