/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;

public class BaseDialog
extends Dialog {
    private final String TAG = BaseDialog.class.getSimpleName();
    protected Activity mCallingActivity;
    private long mDisplayDuration;
    protected boolean mIsWaitingToOpen;
    protected int mCurrentOrientationState = -1;
    private boolean mIsAllowedToChangeOrientation;
    private Utils.StaticHandler mStaticHandler;

    public BaseDialog(Context context) {
        super(context);
        if (context != null) {
            if (context instanceof Activity) {
                this.mCallingActivity = (Activity)context;
            } else if (context instanceof ContextWrapper) {
                this.mCallingActivity = (Activity)((ContextWrapper)context).getBaseContext();
            }
        }
    }

    public BaseDialog(Context context, int theme) {
        super(context, theme);
        try {
            if (context != null) {
                if (context instanceof Activity) {
                    this.mCallingActivity = (Activity)context;
                } else if (context instanceof ContextWrapper) {
                    this.mCallingActivity = (Activity)((ContextWrapper)context).getBaseContext();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BaseDialog(Context context, int theme, boolean isAllowedToChangeOrientation) {
        super(context, theme);
        try {
            if (context != null) {
                if (context instanceof Activity) {
                    this.mCallingActivity = (Activity)context;
                } else if (context instanceof ContextWrapper) {
                    this.mCallingActivity = (Activity)((ContextWrapper)context).getBaseContext();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mIsAllowedToChangeOrientation = isAllowedToChangeOrientation;
    }

    public void openDialog() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            this.getWindow().setFlags(8, 8);
            this.getWindow().getDecorView().setSystemUiVisibility(this.mCallingActivity.getWindow().getDecorView().getSystemUiVisibility());
            this.mDisplayDuration = System.currentTimeMillis();
            super.show();
            this.getWindow().clearFlags(8);
            WindowManager wm = (WindowManager)this.mCallingActivity.getSystemService("window");
            wm.updateViewLayout(this.getWindow().getDecorView(), (ViewGroup.LayoutParams)this.getWindow().getAttributes());
            if (this.mIsAllowedToChangeOrientation) {
                this.saveUserOriginalOrientation();
                this.mCallingActivity.setRequestedOrientation(4);
            }
        }
    }

    public void closeDialog() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            if (this.mIsAllowedToChangeOrientation) {
                this.restoreUserOriginalOrientation();
            }
            this.dismiss();
        }
    }

    public void show() {
        try {
            throw new DialogException();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to open dialog: " + ex.getMessage());
            return;
        }
    }

    public int getTotalDisplayDuration() {
        int totalTimeInSeconds = (int)((System.currentTimeMillis() - this.mDisplayDuration) / 1000L);
        return totalTimeInSeconds;
    }

    public void setContentView(View view) {
        super.setContentView(view);
        this.initConfigurationHelperView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        this.initConfigurationHelperView(view);
    }

    private void initConfigurationHelperView(View view) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            ConfigurationHelperView configurationHelperView = new ConfigurationHelperView(this.getContext());
            viewGroup.addView((View)configurationHelperView);
        }
    }

    protected void onDialogOrientationChange(boolean isPortrait) {
    }

    protected void onDialogFocusChange(boolean isVisible) {
    }

    protected void onDialogVisibilityChange(int isVisible) {
    }

    protected void onDialogWindowVisibilityChange(boolean visible) {
    }

    public void restoreUserOriginalOrientation() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.mCallingActivity.setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.mCallingActivity.setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.mCallingActivity.setRequestedOrientation(4);
                }
            }
        }
    }

    public void saveUserOriginalOrientation() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
        }
    }

    public boolean getIsCanOpen() {
        return false;
    }

    protected Utils.StaticHandler getMyHandlerInstance() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return this.mStaticHandler;
    }

    public class ConfigurationHelperView
    extends View {
        public ConfigurationHelperView(Context context) {
            super(context);
        }

        protected void onConfigurationChanged(Configuration newConfig) {
            super.onConfigurationChanged(newConfig);
            if (newConfig.orientation == 2) {
                BaseDialog.this.onDialogOrientationChange(false);
            } else {
                BaseDialog.this.onDialogOrientationChange(true);
            }
        }

        public void onWindowFocusChanged(boolean hasWindowFocus) {
            super.onWindowFocusChanged(hasWindowFocus);
            BaseDialog.this.onDialogFocusChange(hasWindowFocus);
        }

        protected void onVisibilityChanged(View changedView, int visibility) {
            super.onVisibilityChanged(changedView, visibility);
            BaseDialog.this.onDialogVisibilityChange(visibility);
        }

        protected void onWindowVisibilityChanged(int visibility) {
            super.onWindowVisibilityChanged(visibility);
            if (visibility == 0) {
                BaseDialog.this.onDialogWindowVisibilityChange(true);
            } else if (visibility == 8 || visibility == 4) {
                BaseDialog.this.onDialogWindowVisibilityChange(false);
            }
        }
    }

    private class DialogException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DialogException() {
        }

        @Override
        public String getMessage() {
            return "Don't use the show() method\nUse openDialog() instead!";
        }
    }
}

