/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.feed_view.FeedFamilyViewDialog;
import com.kidoz.sdk.api.ui_views.feed_view.FeedViewDialog;
import de.greenrobot.event.EventBus;
import org.json.JSONObject;

public class FeedView {
    public static final String KIDOZ_FEED_BUTTON = "feedButton";
    public static final String KIDOZ_FEED_BUTTON_SCALE = "feedButtonScale";
    public static final String OVERRIDE_USER_PROPERTIES = "overrideUserProperties";
    public static final String LOUNCH_INTERSTITIAL_ON_OPEN = "lounchInterstitialOnOpen";
    public static final String TAG = FeedView.class.getSimpleName();
    public static final String STYLE_ID = "style_id";
    private Builder mBuilder;
    private FeedViewDialog mFeedViewDialog;
    private FeedFamilyViewDialog mFamilyViewDialog;
    protected ContentLogicLoader mContentLogicLoader;
    protected IOnFeedViewEventListener mOnInterstitialViewEventListener;
    protected boolean mIsAutomaticInvocation = false;
    protected String mFeedViewType = null;
    protected boolean mIsPostLoadData = false;
    protected boolean mShowWhenInitiated = false;
    protected JSONObject mJsonObjectProperties;
    protected static boolean mOncePerSessionLoaded = false;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private DialogInterface.OnDismissListener dismissListener;
    private KidozPlayerListener mKidozPlayerListener;

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    protected FeedView(Builder builder) {
        this.mBuilder = builder;
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen() {
                if (FeedView.this.mKidozPlayerListener != null) {
                    FeedView.this.mKidozPlayerListener.onPlayerOpen();
                }
                if (FeedView.this.mFamilyViewDialog != null && FeedView.this.mFamilyViewDialog.isShowing()) {
                    FeedView.this.mFamilyViewDialog.pauseAction();
                }
            }

            @Override
            public void onClose() {
                if (FeedView.this.mKidozPlayerListener != null) {
                    FeedView.this.mKidozPlayerListener.onPlayerClose();
                }
                if (FeedView.this.mFamilyViewDialog != null && FeedView.this.mFamilyViewDialog.isShowing()) {
                    FeedView.this.mFamilyViewDialog.resumeAction();
                }
            }
        }, WidgetType.WIDGET_TYPE_FEED);
        this.dismissListener = new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (FeedView.this.mKidozPlayerEventHelper != null) {
                    FeedView.this.mKidozPlayerEventHelper.unRegister();
                }
                if (FeedView.this.mOnInterstitialViewEventListener != null) {
                    FeedView.this.mOnInterstitialViewEventListener.onDismissView();
                }
            }
        };
        this.initContentLogicLoader();
        if (KidozSDK.isInitialised()) {
            this.checkIfValidationNeededAndInit();
        } else if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    private void checkIfValidationNeededAndInit() {
        if (mOncePerSessionLoaded) {
            this.mJsonObjectProperties = DatabaseManager.getInstance(this.mBuilder.mContext).getConfigTable().loadProperties(TAG);
            if (this.mJsonObjectProperties != null) {
                this.mFeedViewType = this.mJsonObjectProperties.optString(TAG);
                if (this.mShowWhenInitiated) {
                    this.showView();
                }
                EventBus.getDefault().post((Object)new EventMessage(EventMessage.MessageType.INIT_FEED_BUTTON));
                if (this.mOnInterstitialViewEventListener != null) {
                    this.mOnInterstitialViewEventListener.onViewReady();
                }
            } else {
                this.validateLayoutAndAssets();
            }
        } else {
            this.validateLayoutAndAssets();
        }
    }

    public void onEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.checkIfValidationNeededAndInit();
            this.unregisterEventBus();
        }
    }

    private void unregisterEventBus() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void validateLayoutAndAssets() {
        SdkAPIManager.getSdkApiInstance(this.mBuilder.mContext).getStyle(this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getValue(), new ApiResultCallback<Boolean>(){

            @Override
            public void onServerResult(ResultData<?> result) {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful()) {
                    if (result.getData() != null) {
                        boolean isAssetsReady = (Boolean)result.getData();
                        if (isAssetsReady) {
                            FeedView.this.mJsonObjectProperties = DatabaseManager.getInstance(FeedView.this.mBuilder.mContext).getConfigTable().loadProperties(TAG);
                            if (FeedView.this.mJsonObjectProperties != null) {
                                FeedView.this.mFeedViewType = FeedView.this.mJsonObjectProperties.optString(TAG);
                                EventBus.getDefault().post((Object)new EventMessage(EventMessage.MessageType.INIT_FEED_BUTTON));
                                mOncePerSessionLoaded = true;
                                if (FeedView.this.mOnInterstitialViewEventListener != null) {
                                    FeedView.this.mOnInterstitialViewEventListener.onViewReady();
                                }
                                if (FeedView.this.mShowWhenInitiated) {
                                    FeedView.this.showView();
                                }
                            }
                        } else {
                            this.onFailed();
                        }
                    }
                } else {
                    this.onFailed();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (FeedView.this.mFeedViewType.equals(FeedViewDialog.TAG)) {
                    FeedView.this.mFeedViewDialog.setContentData(contentData);
                } else if (FeedView.this.mFeedViewType.equals(FeedFamilyViewDialog.TAG)) {
                    FeedView.this.mFamilyViewDialog.setContentData(contentData);
                }
                if (!FeedView.this.mIsPostLoadData && FeedView.this.mOnInterstitialViewEventListener != null) {
                    FeedView.this.mOnInterstitialViewEventListener.onReadyToShow();
                }
                CookieManager.resetStorage(FeedView.this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getStringValue(), StorageLife.WIDGET);
            }

            @Override
            public void onLoadContentFailed() {
            }
        });
    }

    public void showView() {
        this.showViewInner();
    }

    private void showViewInner() {
        if (KidozSDK.isInitialised()) {
            this.mShowWhenInitiated = false;
            this.mIsAutomaticInvocation = true;
            this.mIsPostLoadData = true;
            if (this.mOnInterstitialViewEventListener != null) {
                this.mOnInterstitialViewEventListener.onReadyToShow();
            }
            this.openSimpleDialog();
        } else {
            this.mShowWhenInitiated = true;
        }
    }

    protected void openSimpleDialog() {
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
        if (this.mBuilder.mContext != null && this.mBuilder.mContext instanceof Activity) {
            if (this.mJsonObjectProperties == null) {
                this.mJsonObjectProperties = DatabaseManager.getInstance(this.mBuilder.mContext).getConfigTable().loadProperties(TAG);
            }
            if (this.mFeedViewType != null && this.mJsonObjectProperties != null) {
                if (this.mFeedViewType.equals(FeedViewDialog.TAG)) {
                    if (this.mFeedViewDialog == null || !this.mFeedViewDialog.isShowing()) {
                        this.mFeedViewDialog = new FeedViewDialog(this.mBuilder.mContext, this.mOnInterstitialViewEventListener, this.mIsAutomaticInvocation, this.mJsonObjectProperties);
                        this.mFeedViewDialog.setOnDismissListener(this.dismissListener);
                        this.mFeedViewDialog.setOnCloseButtonClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                FeedView.this.dismissView();
                                EventManager.getInstance(FeedView.this.mBuilder.mContext).clearAllTempStoredEvents();
                                FeedView.this.unregisterEventBus();
                            }
                        });
                        this.mFeedViewDialog.openDialog();
                        if (this.mJsonObjectProperties != null) {
                            this.mContentLogicLoader.loadContent(this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mJsonObjectProperties.optString(STYLE_ID));
                        }
                    }
                } else if (this.mFeedViewType.equals(FeedFamilyViewDialog.TAG) && (this.mFamilyViewDialog == null || !this.mFamilyViewDialog.isShowing())) {
                    this.mFamilyViewDialog = new FeedFamilyViewDialog(this.mBuilder.mContext, this.mOnInterstitialViewEventListener, this.mIsAutomaticInvocation, this.mJsonObjectProperties);
                    this.mFamilyViewDialog.setOnDismissListener(this.dismissListener);
                    this.mFamilyViewDialog.setOnCloseButtonClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            FeedView.this.dismissView();
                            EventManager.getInstance(FeedView.this.mBuilder.mContext).clearAllTempStoredEvents();
                            FeedView.this.unregisterEventBus();
                        }
                    });
                    this.mFamilyViewDialog.openDialog();
                    if (this.mJsonObjectProperties != null) {
                        this.mContentLogicLoader.loadContent(this.mBuilder.mContext, WidgetType.WIDGET_TYPE_FEED.getStringValue(), this.mJsonObjectProperties.optString(STYLE_ID));
                    }
                }
            } else {
                Log.e((String)"[KIDOZ SDK]", (String)"Feed view object has not been initiated yet !");
            }
        }
    }

    public void dismissView() {
        if (this.mFeedViewType != null) {
            if (this.mFeedViewType.equals(FeedViewDialog.TAG)) {
                if (this.mFeedViewDialog != null) {
                    this.mFeedViewDialog.closeDialog();
                }
            } else if (this.mFeedViewType.equals(FeedFamilyViewDialog.TAG) && this.mFamilyViewDialog != null) {
                this.mFamilyViewDialog.closeDialog();
            }
        }
    }

    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener) {
        this.mOnInterstitialViewEventListener = listener;
        if (this.mFeedViewType != null) {
            if (this.mFeedViewType.equals(FeedViewDialog.TAG)) {
                if (this.mFeedViewDialog != null) {
                    this.mFeedViewDialog.setOnInterstitialViewEventListener(this.mOnInterstitialViewEventListener);
                }
            } else if (this.mFeedViewType.equals(FeedFamilyViewDialog.TAG) && this.mFamilyViewDialog != null) {
                this.mFamilyViewDialog.setOnInterstitialViewEventListener(this.mOnInterstitialViewEventListener);
            }
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context context) {
            this.mContext = context;
        }

        public FeedView build() {
            return new FeedView(this);
        }
    }
}

