package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PanelAdapter extends RecyclerView.Adapter<PanelAdapter.ViewHolder> implements View.OnClickListener
{
    private PANEL_TYPE mPanelType;
    private PanelViewListener mPanelViewListener;
    private ArrayList<ContentItem> mContent;
    private File mSoundFile;
    private Handler mHandler;
    private boolean mIsCanClick;
    private int mLastPosition;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap<String, Integer>();
    private String mWidgetType;
    private String mStyleID;

    private int mWidth;
    private int mHeight;

   /* public PanelAdapter(Context context, PANEL_TYPE panelType,int w,int h)
    {
        mWidth = w;
        mHeight = h;

        mPanelType = panelType;
        mSoundFile = SoundAssetsUtils.getSoundAssetFile(context, SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK);
        mLastPosition = -1;
        mContent = new ArrayList<ContentItem>();
        mHandler = new Handler();
        mIsCanClick = true;
    }*/

    public PanelAdapter(Context context, PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        mSoundFile = SoundAssetsUtils.getSoundAssetFile(context, SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK);
        mLastPosition = -1;
        mContent = new ArrayList<ContentItem>();
        mHandler = new Handler();
        mIsCanClick = true;
    }

    public void setSizePropertiesAndUpdate(int w, int h)
    {
        mWidth = w;
        mHeight = h;

        notifyItemRangeChanged(0,mContent.size());
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
    }

    public void setContent(ContentData contentData)
    {
        synchronized (this)
        {
            if (contentData != null && contentData.getContentDataItems() != null)
            {
                mWidgetType = contentData.getSourceWidgetType();
                mStyleID = contentData.getStyleID();
            }
            mSponsoredContentDisplayed.clear();

            if (mContent.isEmpty() == true)
            {
                mContent.clear();
                mContent.addAll(contentData.getContentDataItems());
                notifyItemRangeInserted(0, getItemCount());
                notifyItemRangeChanged(0, getItemCount());
            } else
            {
                mContent.clear();
                mContent.addAll(contentData.getContentDataItems());
                notifyDataSetChanged();
            }
        }
    }

    public void clearContent()
    {
        synchronized (this)
        {
            if (mContent != null)
            {
                mLastPosition = -1;
                if (mContent.isEmpty() == true)
                {
                    notifyItemRangeRemoved(0, getItemCount());
                    notifyItemRangeChanged(0, getItemCount());
                    mContent.clear();
                } else
                {
                    mContent.clear();
                    notifyDataSetChanged();
                }
            }
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder
    {
        private OneContentItemView mPanelContentItem;
        private KidozCardView mParentContainer;

        public ViewHolder(KidozCardView parent, OneContentItemView view)
        {
            super(parent);
            mParentContainer = parent;
            mPanelContentItem = view;
            parent.setSoundEffectsEnabled(false);
        }

        public void setData(ContentItem contentItem)
        {
            mPanelContentItem.setData(contentItem);
        }
    }

    @Override
    public int getItemCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType)
    {
        OneContentItemView panelContentItem = new OneContentItemView(parent.getContext(), mWidth, mHeight);

        KidozCardView mCardContainerView = new KidozCardView(parent.getContext());
        mCardContainerView.setId(Utils.generateViewId());

        int val = Utils.dpTOpx(parent.getContext(), 5);
        mCardContainerView.setRadius(val);
        mCardContainerView.setCardBackgroundColor(Color.parseColor("#ccffffff"));

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(panelContentItem.mWidth, ViewGroup.LayoutParams.MATCH_PARENT);

        mCardContainerView.setClipToPadding(false);
        params.setMargins(val, val, val, val);
        mCardContainerView.setContentPadding(val, val, val, val);
        mCardContainerView.addView(panelContentItem, params);
        mCardContainerView.setUseCompatPadding(true);

        ViewHolder viewHolder = new ViewHolder(mCardContainerView, panelContentItem);
        viewHolder.mParentContainer.setOnClickListener(this);
        viewHolder.mParentContainer.setTag(viewHolder);

        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, int position)
    {
        ContentItem contentItem = mContent.get(position);
        sendImpressionLog(holder, contentItem, position);

        holder.mPanelContentItem.applyViewSettingsByContentType(contentItem.getContentType());

        holder.setData(contentItem);

        if (position > mLastPosition)
        {
            holder.mPanelContentItem.setVisibility(View.INVISIBLE);
            mHandler.postDelayed(new Runnable()
            {
                @Override
                public void run()
                {
                    GenAnimator.recycleItemAnimation(holder.mPanelContentItem, new GenAnimator.ViewAnimationListener()
                    {
                        @Override
                        public void onAnimationEnd()
                        {
                        }

                        @Override
                        public void onAnimationStart()
                        {
                            holder.mPanelContentItem.setVisibility(View.VISIBLE);
                        }
                    });
                }
            }, 0);
            mLastPosition = position;
        } else
        {
            holder.mPanelContentItem.clearAnimation();
            holder.mPanelContentItem.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void onClick(final View view)
    {
        if (mIsCanClick == true)
        {
            SdkSoundManager.playSound(view.getContext(), mSoundFile.getAbsolutePath());
            mIsCanClick = false;
            SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
            {
                @Override
                public void onAnimationStart(Animator animation)
                {
                }

                @Override
                public void onAnimationEnd(Animator animation)
                {
                    final ViewHolder viewHolder = (ViewHolder) view.getTag();
                    int position = viewHolder.getAdapterPosition();
                    ContentItem contentItem = mContent.get(position);

                    if (position != RecyclerView.NO_POSITION)
                    {
                        if (mPanelViewListener != null)
                        {
                            mPanelViewListener.onItemClick(contentItem, position);
                        }
                    }
                    mIsCanClick = true;
                }

                @Override
                public void onAnimationCancel(Animator animation)
                {

                }

                @Override
                public void onAnimationRepeat(Animator animation)
                {

                }
            }, 50, 100);
        }
    }

    public void setPanelViewListener(PanelViewListener panelViewListener)
    {
        mPanelViewListener = panelViewListener;
    }

    private void sendImpressionLog(ViewHolder viewHolder, ContentItem contentItem, int position)
    {
        //TODO Any fix related this function should be implemented in ItemsBaseRecycleViewAdapter.class too.
        if (contentItem != null && contentItem.isPromoted() == true)
        {
            if (mSponsoredContentDisplayed != null)
            {
                if (contentItem.getIsAvoidAutoImpression() == false)
                {
                    if (mSponsoredContentDisplayed.containsKey(contentItem.getId()) == false)
                    {
                        mSponsoredContentDisplayed.put(contentItem.getId(), position);
                        EventManager.getInstance(viewHolder.mPanelContentItem.getContext()).logSponsoredContentImpressionEvent(viewHolder.mPanelContentItem.getContext(), mWidgetType, mStyleID, EventParameters.ACTION_IMPRESSION, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position, false);
                    }
                }
            }
        }
    }

    public void toggleClick(boolean isCanClick)
    {
        mIsCanClick = isCanClick;
    }
}
