package com.kidoz.sdk.api.ui_views.one_item_view;

import android.animation.Animator;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;

import com.kidoz.sdk.api.general.assets_handling.SoundAssetsUtils;
import com.kidoz.sdk.api.general.utils.SdkAnimationsUtils;
import com.kidoz.sdk.api.general.utils.SdkSoundManager;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.OneContentItemView;

import java.util.ArrayList;

/**
 * Created by roni on 11/18/2015.
 */
public class ItemViewPagerAdapter extends PagerAdapter
{
    private ArrayList<ContentItem> mContent;
    private ViewPagerItemClickListener mViewPagerItemClickListener;
    private boolean mIsCanClick;

    protected int mWidth;
    protected int mHeight;

    public ItemViewPagerAdapter(int width, int height)
    {
        mContent = new ArrayList<ContentItem>();
        mIsCanClick = true;
        mWidth = width;
        mHeight = height;
    }

    public void setViewPagerItemClickListener(ViewPagerItemClickListener viewPagerItemClickListener)
    {
        mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    @Override
    public int getCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mContent = content;
        notifyDataSetChanged();
    }

    public void clearContent()
    {
        mContent.clear();
        notifyDataSetChanged();
    }

    @Override
    public Object instantiateItem(ViewGroup container, final int position)
    {
        final ContentItem contentItem = mContent.get(position);
        OneContentItemView panelContentItem = new OneContentItemView(container.getContext(), mWidth, mHeight);
        panelContentItem.setTag(position);

        panelContentItem.applyViewSettingsByContentType(contentItem.getContentType());

        panelContentItem.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                if (mIsCanClick == true)
                {
                    SdkSoundManager.playSound(view.getContext(), SoundAssetsUtils.getSoundAssetFile(view.getContext(), SoundAssetsUtils.SOUND_ASSET_TYPE.ITEM_CLICK).getAbsolutePath());
                    mIsCanClick = false;
                    SdkAnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                    {
                        @Override
                        public void onAnimationStart(Animator animation)
                        {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation)
                        {
                            mViewPagerItemClickListener.onClickEnd(contentItem, position);
                            mIsCanClick = true;
                        }

                        @Override
                        public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override
                        public void onAnimationRepeat(Animator animation)
                        {

                        }
                    }, 50, 100);
                }
            }
        });
        if (contentItem != null)
        {
            panelContentItem.setData(contentItem);
        }
        container.addView(panelContentItem);
        return panelContentItem;
    }

    @Override
    public boolean isViewFromObject(View view, Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object)
    {
        container.removeView((OneContentItemView) object);
    }

    public interface ViewPagerItemClickListener
    {
        void onClickEnd(ContentItem contentItem, int position);
    }

    public ContentItem getContentItem(int position)
    {
        ContentItem result = null;
        if (mContent != null && mContent.size() > position)
        {
            result = mContent.get(position);
        }
        return result;
    }

    public boolean isAdapterEmpty()
    {
        if (mContent == null)
        {
            return true;
        } else
        {
            return mContent.isEmpty();
        }
    }
}
