package com.kidoz.sdk.api.ui_views.interstitial;

import android.content.Context;
import android.content.Intent;

import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.assets_handling.StyleParser;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.CookieManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;

import org.json.JSONObject;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import de.greenrobot.event.EventBus;

public class IntrstWrapper
{
    public enum InterstitialEvents
    {
        OPENED, CLOSED
    }

    private static IntrstWrapper mInstance = null;

    public Context mContext;
    private HtmlViewWrapper webView;

    private ContentLogicLoader mContentLogicLoader;
    private String mStyleId;
    private boolean mIsInitialLoadFinished = false;
    private boolean mIsAutoShowOnReady = false;

    private JSONObject mProperties;
    private Lock mLounchLock;
    private boolean mIsShowInProgress = false;
    private boolean mIsInvokeEvents = false;

    public static IntrstWrapper initInstance(Context context)
    {
        if (mInstance == null)
        {
            return mInstance = new IntrstWrapper(context);
        } else
        {
            mInstance.validateIfPrepared();
            return mInstance;
        }
    }

    protected IntrstWrapper(Context context)
    {
        mContext = context;

        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        mLounchLock = new ReentrantLock();

        // Has been initialised
        if (KidozSDK.isInitialised() == true)
        {
            validateLayoutAndAssets();
        }

        initContentLogicLoader();
    }

    private void validateLayoutAndAssets()
    {
        SdkAPIManager.getSdkApiInstance(mContext).getStyle(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getValue(), new ApiResultCallback<Boolean>()
        {
            @Override
            public void onServerResult(ResultData<?> result)
            {
                if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() == true)
                {
                    if (result.getData() != null)
                    {
                        boolean isAssetsReady = (Boolean) result.getData();
                        if (isAssetsReady == true)
                        {
                            mProperties = DatabaseManager.getInstance(mContext).getConfigTable().loadProperties(KidozInterstitial.TAG);
                            if (mProperties != null)
                            {
                                mStyleId = mProperties.optString(StyleParser.STYLE_ID);
                            }

                            prepareWebView();
                        } else
                        {
                            onFailed();
                        }
                    }
                } else
                {
                    onFailed();
                }
            }

            @Override
            public void onFailed()
            {
            }
        });
    }

    private synchronized void prepareWebView()
    {
        webView = HtmlManager.getIntrstDefaultHtmlView(mContext);
        if (webView == null)
        {
            webView = HtmlManager.initIntrstDefaultHtmlView(mContext);
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface()
            {
                @Override
                public void onViewReady()
                {
                    super.onViewReady();
                    mIsInitialLoadFinished = true;
                    if (mIsAutoShowOnReady == true)
                    {
                        mIsAutoShowOnReady = false;
                        mContentLogicLoader.loadContent(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), mStyleId);
                    }
                }
            });

            PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
            if (appConfig != null)
            {
                webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
            }
        } else
        {
            webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
            if (mIsInitialLoadFinished == false)
            {
                PropertiesObj appConfig = DatabaseManager.getInstance(mContext).getConfigTable().loadAppProperties();
                if (appConfig != null)
                {

                    webView.loadHtml(appConfig.getHtmlLoaderDefaultLink());
                }
            } else
            {
                if (mIsAutoShowOnReady == true)
                {
                    mIsAutoShowOnReady = false;
                    mContentLogicLoader.loadContent(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), mStyleId);
                }
            }
        }
    }

    /**
     * Initiate  content loader logic ,that handles all the logic for loading content
     **/
    private void initContentLogicLoader()
    {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback()
        {
            @Override
            public void onDataReady(final ContentData contentData)
            {
                if (contentData != null && contentData.isHasContentToShow())
                {
                    ContentItem contentItem = contentData.getContentDataItems().get(0);
                    if (contentItem.getContentType() == ContentType.HTML)
                    {
                        openAdActivity(contentItem);
                    } else
                    {
                        mIsShowInProgress = false;
                    }
                } else
                {
                    mIsShowInProgress = false;
                }

                // Reset The storage of the impressions for the HTML content
                CookieManager.resetStorage(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
            }

            @Override
            public void onLoadContentFailed()
            {
                mIsShowInProgress = false;
            }
        });
    }

    public synchronized void show(boolean invokeEvents)
    {
        if (mIsShowInProgress == false)
        {
            mIsInvokeEvents = invokeEvents;
            if (mIsInitialLoadFinished)
            {
                mContentLogicLoader.loadContent(mContext, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), mStyleId);
            } else
            {
                mIsAutoShowOnReady = true;
            }
        }
    }

    /**
     * Prepare correct interstitial dialog depending on the type of the HTML used
     * I both cases of Default and non default HTMl we need to wait until loading is finished before showing
     * the interstitial view for correct flow
     */
    private synchronized void openAdActivity(final ContentItem contentItem)
    {
        if (contentItem.getIsNonDefaultHtml())
        {
            openActivity(contentItem);
        } else
        {
            openActivity(contentItem);
        }
    }

    private void openActivity(ContentItem contentItem)
    {
        if (mLounchLock.tryLock())
        {
            try
            {
                try
                {
                    if (mIsInvokeEvents)
                    {
                        EventBus.getDefault().post(InterstitialEvents.OPENED);
                    }

                    KidozAdActivity.itm = contentItem;
                    Intent intent = new Intent(mContext, KidozAdActivity.class);
                    intent.putExtra(KidozAdActivity.STYLE_ID_KEY, mStyleId);

                    intent.addFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                    mContext.startActivity(intent);
                } catch (Exception e)
                {
                }
            } finally
            {
                mLounchLock.unlock();
            }
        }
    }

    public void onEvent(WidgetEventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE)
        {
            mIsShowInProgress = false;

            if (mIsInvokeEvents)
            {
                EventBus.getDefault().post(InterstitialEvents.CLOSED);
            }
        }
    }

    // Event bus callback
    public void onEvent(EventMessage event)
    {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK)
        {
            validateLayoutAndAssets();
        }
    }

    protected void validateIfPrepared()
    {
        if (EventBus.getDefault().isRegistered(this) == false)
        {
            EventBus.getDefault().register(this);
        }

        if (mIsInitialLoadFinished)
        {
            prepareWebView();
        }
    }
}
