package com.kidoz.sdk.api.ui_views.html_view;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.CloseButtonView;

/**
 * Created by Eugine on 3/28/2016.
 */
public class BaseInterstitialDialog extends BaseDialog
{
    protected HtmlViewWrapper mWebView;
    protected CloseButtonView mCloseButtonView;

    protected RelativeLayout mInnerContainer;
    protected String mWidgetType;

    public BaseInterstitialDialog(Context context, String widgetType, HtmlViewWrapper htmlViewWrapper)
    {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        mWidgetType = widgetType;

        setCancelable(true);
        setCanceledOnTouchOutside(false);

        mWebView = htmlViewWrapper;
        mWebView.setHtmlWebViewListener(new IOnHtmlWebViewInterface()
        {
            @Override
            public void onHtmlStartLoading()
            {
                onHtmlStart();
            }

            @Override
            public void onHtmlFinishedLoading()
            {
                onHtmlFinish();
            }

            @Override
            public void onOpenMaximized()
            {
                openMaximized();
            }

            @Override
            public void onClose()
            {
                close();
            }

            @Override
            public void onDonePlayBack()
            {
                donePlayback();
            }

            @Override
            public void onViewReady()
            {
                viewReady();
            }

            @Override
            public void forwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID)
            {
                getOwnerActivity().runOnUiThread(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        ContentItem contentItem = new ContentItem();
                        contentItem.setId(appID);
                        contentItem.setName("");
                        contentItem.setData(googlePlayLink);
                        contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                        contentItem.setAdvertiserID(advertiserID);
                        contentItem.setIsPromoted(true);
                        ContentExecutionHandler.handleContentItemClick(getContext(), contentItem, widgetType, styleID, 0, false, true, null);
                    }
                });
            }
        });

        ViewGroup group = (ViewGroup) mWebView.getParent();
        if (group != null)
        {
            group.removeView(mWebView);
        }

        mInnerContainer = new RelativeLayout(getContext());
        setContentView(mInnerContainer, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        mInnerContainer.addView(mWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        initCloseButton();
    }

    protected void onHtmlStart()
    {
        mWebView.showLoadingProgressView();
    }

    protected void onHtmlFinish()
    {
        if (mWebView.isShowClose())
        {
            mCloseButtonView.setVisibility(View.VISIBLE);
        }
        mWebView.hideLoadingProgressView();
    }

    protected void openMaximized()
    {
    }

    protected void close()
    {
        closeDialog();
    }

    protected void donePlayback()
    {
    }

    protected void viewReady()
    {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
    }

    private void initCloseButton()
    {
        mCloseButtonView = new CloseButtonView(getContext(), Color.parseColor("#ffffff"));
        mCloseButtonView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        relParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        relParams.setMargins(0, Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 5), 0);
        mCloseButtonView.setPadding(Utils.dpTOpx(getContext(), 12), 0, 0, Utils.dpTOpx(getContext(), 12));
        mInnerContainer.addView(mCloseButtonView, relParams);
        mCloseButtonView.setVisibility(View.INVISIBLE);

        mCloseButtonView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 70, new GenAnimator.ViewAnimationListener()
                {
                    @Override
                    public void onAnimationEnd()
                    {
                        closeDialog();
                    }

                    @Override
                    public void onAnimationStart()
                    {
                    }
                });
            }
        });
    }
}

