package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.events.DeviceUtils;
import com.kidoz.sdk.api.ui_views.custom_drawables.XViewDrawable;

/**
 * Created by Eugine on 7/20/2015.
 */


public class CloseButtonView extends RelativeLayout {

    private int mColor = Color.parseColor("#ffffff");

    public CloseButtonView(Context context, int color) {
        super(context);
        mColor = color;
        initView(context, -1, -1);
    }

    public CloseButtonView(Context context, int width, int height, int color) {
        super(context);
        mColor = color;
        initView(context, width, height);
    }

    public CloseButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(context, -1, -1);
    }

    public CloseButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context, -1, -1);
    }

    private void initView(Context context, int width, int height) {

        if (width == -1 || height == -1) {
            Point point = DeviceUtils.getScreenSize(context);
            int size = Math.min(point.x, point.y);
            width = (int) (size * 0.058);
            height = width;
        }

        XViewDrawable xViewDrawable = new XViewDrawable(getContext(),mColor);
        ImageView mInnImageView = new ImageView(getContext());
        mInnImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        mInnImageView.setImageDrawable(xViewDrawable);
        addView(mInnImageView, new RelativeLayout.LayoutParams(width, height));
    }
}
